/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice.netty;

import gg.essential.lib.ice4j.pseudotcp.PseudoTcpSocket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.local.LocalChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;

public class IceChannelInitializer
extends ChannelInitializer<LocalChannel> {
    private static final ByteBuf CLOSE_MARKER = Unpooled.buffer((int)0, (int)0);
    private static final ByteBuf CLOSE_PACKET = Unpooled.buffer((int)16);
    private final PseudoTcpSocket socket;

    public IceChannelInitializer(PseudoTcpSocket socket) {
        this.socket = socket;
    }

    protected void initChannel(LocalChannel channel) {
        final LinkedBlockingDeque outbound = new LinkedBlockingDeque();
        final Thread writer = new Thread(() -> this.lambda$initChannel$0(outbound, channel));
        writer.setName("ICE Writer");
        writer.setDaemon(true);
        final Thread reader = new Thread(() -> {
            block8: {
                try {
                    InputStream inputStream = this.socket.getInputStream();
                    while (channel.isOpen()) {
                        ByteBuf buf = channel.alloc().buffer();
                        try {
                            buf.writeBytes(inputStream, buf.writableBytes());
                            if (ByteBufUtil.equals((ByteBuf)buf, (ByteBuf)CLOSE_PACKET)) {
                                channel.close();
                                return;
                            }
                            channel.writeAndFlush((Object)buf.retain());
                        }
                        finally {
                            buf.release();
                        }
                    }
                }
                catch (IOException e) {
                    if (!channel.isOpen()) break block8;
                    e.printStackTrace();
                }
            }
        });
        reader.setName("ICE Reader");
        reader.setDaemon(true);
        channel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                super.channelActive(ctx);
                reader.start();
                writer.start();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (msg instanceof ByteBuf) {
                    outbound.add((ByteBuf)msg);
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                super.channelInactive(ctx);
                outbound.add(CLOSE_MARKER);
                reader.interrupt();
                writer.join(10000L);
                reader.join(10000L);
                IceChannelInitializer.this.socket.close();
            }
        }});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$initChannel$0(LinkedBlockingDeque outbound, LocalChannel channel) {
        try {
            outputStream = this.socket.getOutputStream();
            while (true) lbl-1000:
            // 3 sources

            {
                if ((buf = (ByteBuf)outbound.take()) == IceChannelInitializer.CLOSE_MARKER) {
                    outputStream.flush();
                    IceChannelInitializer.CLOSE_PACKET.getBytes(0, outputStream, IceChannelInitializer.CLOSE_PACKET.readableBytes());
                    outputStream.flush();
                    return;
                }
                try {
                    buf.readBytes(outputStream, buf.readableBytes());
                }
                finally {
                    buf.release();
                    continue;
                }
                break;
            }
        }
        catch (IOException | InterruptedException e) {
            if (channel.isOpen()) {
                e.printStackTrace();
            }
            return;
        }
        ** GOTO lbl-1000
    }

    static {
        UUID uuid = UUID.nameUUIDFromBytes("Essential Close Packet".getBytes(StandardCharsets.UTF_8));
        CLOSE_PACKET.writeLong(uuid.getLeastSignificantBits());
        CLOSE_PACKET.writeLong(uuid.getMostSignificantBits());
    }
}

