/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;

public class Log4jAsJulLogger
extends Logger {
    private static final Map<java.util.logging.Level, Level> levelMap = new ConcurrentHashMap<java.util.logging.Level, Level>();
    private final org.apache.logging.log4j.Logger logger;

    public Log4jAsJulLogger(String name) {
        this(LogManager.getLogger((String)name));
    }

    public Log4jAsJulLogger(org.apache.logging.log4j.Logger logger) {
        super(logger.getName(), null);
        super.setLevel(java.util.logging.Level.FINEST);
        this.logger = logger;
    }

    private static Level mapLevel(java.util.logging.Level julLevel) {
        return levelMap.getOrDefault(julLevel, Level.INFO);
    }

    @Override
    public void log(LogRecord record) {
        Filter filter2 = this.getFilter();
        if (filter2 != null && !filter2.isLoggable(record)) {
            return;
        }
        Level level = Log4jAsJulLogger.mapLevel(record.getLevel());
        Message message = this.logger.getMessageFactory().newMessage(record.getMessage(), record.getParameters());
        Throwable thrown = record.getThrown();
        this.logger.log(level, (Marker)null, message, thrown);
    }

    @Override
    public boolean isLoggable(java.util.logging.Level level) {
        return this.logger.isEnabled(Log4jAsJulLogger.mapLevel(level));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void setLevel(java.util.logging.Level newLevel) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParent(Logger parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void log(java.util.logging.Level level, String msg) {
        this.logger.log(Log4jAsJulLogger.mapLevel(level), msg);
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Object param1) {
        this.logger.log(Log4jAsJulLogger.mapLevel(level), msg, param1);
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Object[] params) {
        this.logger.log(Log4jAsJulLogger.mapLevel(level), msg, params);
    }

    @Override
    public void log(java.util.logging.Level level, String msg, Throwable thrown) {
        this.logger.log(Log4jAsJulLogger.mapLevel(level), msg, thrown);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        this.logger.entry();
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.logger.entry(new Object[]{param1});
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        this.logger.entry(params);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        this.logger.exit();
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result2) {
        this.logger.exit(result2);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.throwing(thrown);
    }

    static {
        levelMap.put(java.util.logging.Level.ALL, Level.ALL);
        levelMap.put(java.util.logging.Level.FINEST, Level.TRACE);
        levelMap.put(java.util.logging.Level.FINER, Level.TRACE);
        levelMap.put(java.util.logging.Level.FINE, Level.DEBUG);
        levelMap.put(java.util.logging.Level.CONFIG, Level.DEBUG);
        levelMap.put(java.util.logging.Level.INFO, Level.INFO);
        levelMap.put(java.util.logging.Level.WARNING, Level.WARN);
        levelMap.put(java.util.logging.Level.SEVERE, Level.ERROR);
        levelMap.put(java.util.logging.Level.OFF, Level.OFF);
    }
}

