/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.ice;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gg.essential.api.utils.Multithreading;
import gg.essential.connectionmanager.common.packet.ice.IceCandidatePacket;
import gg.essential.connectionmanager.common.packet.ice.IceSessionPacket;
import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.ice.Agent;
import gg.essential.lib.ice4j.ice.CandidatePair;
import gg.essential.lib.ice4j.ice.Component;
import gg.essential.lib.ice4j.ice.IceMediaStream;
import gg.essential.lib.ice4j.ice.IceProcessingState;
import gg.essential.lib.ice4j.ice.KeepAliveStrategy;
import gg.essential.lib.ice4j.ice.LocalCandidate;
import gg.essential.lib.ice4j.ice.NominationStrategy;
import gg.essential.lib.ice4j.ice.RemoteCandidate;
import gg.essential.lib.ice4j.ice.harvest.StunCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.TrickleCallback;
import gg.essential.lib.ice4j.ice.harvest.TurnCandidateHarvester;
import gg.essential.lib.ice4j.ice.harvest.UPNPHarvester;
import gg.essential.lib.ice4j.pseudotcp.PseudoTcpSocket;
import gg.essential.lib.ice4j.pseudotcp.PseudoTcpSocketFactory;
import gg.essential.lib.jitsi.utils.logging2.LoggerImpl;
import gg.essential.mixins.ext.network.NetworkSystemExtKt;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.ice.Log4jAsJulLogger;
import gg.essential.network.connectionmanager.ice.handler.IceCandidatePacketHandler;
import gg.essential.network.connectionmanager.ice.handler.IceSessionPacketHandler;
import gg.essential.network.connectionmanager.ice.netty.CloseAfterFirstMessage;
import gg.essential.network.connectionmanager.ice.netty.IceChannelInitializer;
import gg.essential.network.connectionmanager.ice.util.CandidateUtil;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.util.ExtensionsKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class IceManager
implements NetworkedManager {
    private static final long ICE_TIMEOUT = 30L;
    private static final int TCP_TIMEOUT = 10000;
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(IceManager.class);
    public static final Lazy<EventLoopGroup> ICE_SERVER_EVENT_LOOP_GROUP = LazyKt.lazy(() -> IceManager.makeIceEventLoopGroup(true));
    public static final Lazy<EventLoopGroup> ICE_CLIENT_EVENT_LOOP_GROUP = LazyKt.lazy(() -> IceManager.makeIceEventLoopGroup(false));
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final Map<UUID, IceConnection> connections = new ConcurrentHashMap<UUID, IceConnection>();

    private static EventLoopGroup makeIceEventLoopGroup(boolean server) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Netty " + (server ? "Server" : "Client") + " IO ICE #%d").setDaemon(true).build();
        return new DefaultEventLoopGroup(0, threadFactory);
    }

    private static void bypassSocketLimit() {
        if (System.getSecurityManager() == null) {
            LOGGER.debug("No security manager installed, no need to bypass datagram socket limit.");
            return;
        }
        try {
            Class<?> resourceManagerClass = Class.forName("sun.net.ResourceManager");
            Field numSocketsField = resourceManagerClass.getDeclaredField("numSockets");
            numSocketsField.setAccessible(true);
            AtomicInteger numSockets = (AtomicInteger)numSocketsField.get(null);
            numSockets.addAndGet(-1000);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to bypass datagram socket limit:", t);
        }
    }

    public IceManager(@NotNull ConnectionManager connectionManager, @NotNull SPSManager spsManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(IceSessionPacket.class, new IceSessionPacketHandler(this, spsManager));
        connectionManager.registerPacketHandler(IceCandidatePacket.class, new IceCandidatePacketHandler(this));
    }

    public IceConnection getConnection(UUID remote) {
        return this.connections.get(remote);
    }

    private Agent createAgent(UUID user, boolean client) {
        Agent agent = new Agent("essential-", new LoggerImpl("ice4j-" + user));
        agent.setTrickling(true);
        agent.setControlling(client);
        agent.setNominationStrategy(NominationStrategy.NOMINATE_FIRST_HOST_OR_REFLEXIVE_VALID);
        agent.addCandidateHarvester(new StunCandidateHarvester(new TransportAddress("stun.essential.gg", 3478, Transport.UDP)));
        agent.addCandidateHarvester(new UPNPHarvester());
        agent.addCandidateHarvester(new TurnCandidateHarvester(new TransportAddress("turn.essential.gg", 3478, Transport.UDP)));
        return agent;
    }

    private Component createComponent(Agent agent, IceMediaStream mediaStream) {
        try {
            return agent.createComponent(mediaStream, KeepAliveStrategy.SELECTED_ONLY, true);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create component:", (Throwable)e);
            return null;
        }
    }

    private IceConnection setupAgent(UUID user, boolean client, Consumer<IceMediaStream> configureMediaStream) {
        PseudoTcpSocket socket;
        Agent agent = this.createAgent(user, client);
        IceMediaStream mediaStream = agent.createMediaStream("minecraft");
        configureMediaStream.accept(mediaStream);
        Component component2 = this.createComponent(agent, mediaStream);
        if (component2 == null) {
            agent.free();
            return null;
        }
        try {
            socket = new PseudoTcpSocketFactory().createSocket(component2.getSocket());
        }
        catch (SocketException e) {
            LOGGER.error("Failed to create ICE pseudo tcp socket:", (Throwable)e);
            agent.free();
            return null;
        }
        IceConnection connection = new IceConnection(client, agent, mediaStream, component2, socket);
        IceConnection oldConnection = this.connections.put(user, connection);
        if (oldConnection != null) {
            try {
                oldConnection.agent.free();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.connectionManager.send(new IceSessionPacket(user, agent.getLocalUfrag(), agent.getLocalPassword()));
        Multithreading.getScheduledPool().execute(() -> {
            TrickleCallback trickleCallback = candidates -> {
                for (LocalCandidate candidate : candidates) {
                    String str = CandidateUtil.candidateToString(candidate);
                    LOGGER.debug("New local candidate for {}: {}", (Object)user, (Object)str);
                    this.connectionManager.send(new IceCandidatePacket(user, str));
                }
            };
            trickleCallback.onIceCandidates(component2.getLocalCandidates());
            agent.startCandidateTrickle(trickleCallback);
        });
        return connection;
    }

    public SocketAddress createClientAgent(UUID user) throws IOException {
        LOGGER.debug("Creating client-side ICE agent for {}", (Object)user);
        IceConnection connection = this.setupAgent(user, true, mediaStream -> {});
        if (connection == null) {
            throw new IOException("ICE setup failed. Contact support.");
        }
        try {
            connection.iceReadyFuture.join();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
        try {
            connection.tcpSocket.connect(connection.getSelectedRemoteAddress(), 10000);
        }
        catch (IOException e) {
            connection.agent.free();
            throw e;
        }
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).handler((ChannelHandler)new CloseAfterFirstMessage())).childHandler((ChannelHandler)new IceChannelInitializer(connection.tcpSocket)).group(ICE_CLIENT_EVENT_LOOP_GROUP.getValue()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly().channel().localAddress();
    }

    public void createServerAgent(UUID user, String ufrag, String password) {
        LOGGER.debug("Creating server-side ICE agent at request from {} (ufrag: {}, pwd: {})", (Object)user, (Object)ufrag, (Object)password);
        IceConnection connection = this.setupAgent(user, false, mediaStream -> {
            mediaStream.setRemoteUfrag(ufrag);
            mediaStream.setRemotePassword(password);
        });
        if (connection == null) {
            return;
        }
        class_1132 server = class_310.method_1551().method_1576();
        if (server == null) {
            LOGGER.error("Tried to register ICE socket but server was not running!");
            connection.agent.free();
            return;
        }
        connection.startConnectivityChecks();
        ((CompletableFuture)connection.iceReadyFuture.thenComposeAsync(__ -> {
            CompletableFuture future2 = new CompletableFuture();
            try {
                connection.tcpSocket.accept(connection.getSelectedRemoteAddress(), 10000);
                future2.complete(null);
            }
            catch (IOException e) {
                future2.completeExceptionally(e);
            }
            return future2;
        }, (Executor)ICE_SERVER_EVENT_LOOP_GROUP.getValue())).thenRunAsync(() -> {
            SocketAddress iceEndpoint = NetworkSystemExtKt.getIceEndpoint(server.method_3787());
            ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(ICE_SERVER_EVENT_LOOP_GROUP.getValue())).handler((ChannelHandler)new IceChannelInitializer(connection.tcpSocket))).channel(LocalChannel.class)).connect(iceEndpoint);
        }, (Executor)ExtensionsKt.getExecutor((MinecraftServer)server));
    }

    public void addRemoteCandidate(UUID user, String candidateStr) {
        LOGGER.debug("New remote candidate from {}: {}", (Object)user, (Object)candidateStr);
        IceConnection connection = this.connections.get(user);
        if (connection == null) {
            LOGGER.debug("Ignoring candidate from {} because they have no active session.", (Object)user);
            return;
        }
        RemoteCandidate candidate = CandidateUtil.candidateFromString(candidateStr, connection.component);
        if (candidate == null) {
            return;
        }
        Multithreading.runAsync(() -> {
            connection.component.addUpdateRemoteCandidates(candidate);
            connection.component.updateRemoteCandidates();
        });
    }

    static {
        IceManager.bypassSocketLimit();
        try {
            Function<String, Logger> loggerFactory = Log4jAsJulLogger::new;
            Field loggerFactoryField = LoggerImpl.class.getDeclaredField("loggerFactory");
            loggerFactoryField.setAccessible(true);
            loggerFactoryField.set(null, loggerFactory);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (System.getProperty("gg.essential.lib.ice4j.MAX_CTRAN_RETRANS_TIMER") == null) {
            System.setProperty("gg.essential.lib.ice4j.MAX_CTRAN_RETRANS_TIMER", String.valueOf(1600));
        }
        if (System.getProperty("gg.essential.lib.ice4j.MAX_RETRANSMISSIONS") == null) {
            System.setProperty("gg.essential.lib.ice4j.MAX_RETRANSMISSIONS", String.valueOf(6));
        }
    }

    public static class IceConnection {
        private final Agent agent;
        private final IceMediaStream mediaStream;
        private final Component component;
        private final PseudoTcpSocket tcpSocket;
        private final CompletableFuture<Void> iceReadyFuture;
        private boolean needsRemoteCredentials;

        public IceConnection(boolean client, Agent agent, IceMediaStream mediaStream, Component component2, PseudoTcpSocket tcpSocket) {
            this.agent = agent;
            this.mediaStream = mediaStream;
            this.component = component2;
            this.tcpSocket = tcpSocket;
            this.iceReadyFuture = IceConnection.createReadyFuture(agent, client);
            this.needsRemoteCredentials = client;
        }

        public void setRemoteCredentials(String ufrag, String password) {
            if (!this.needsRemoteCredentials) {
                return;
            }
            this.needsRemoteCredentials = false;
            this.mediaStream.setRemoteUfrag(ufrag);
            this.mediaStream.setRemotePassword(password);
            this.startConnectivityChecks();
        }

        public void startConnectivityChecks() {
            Multithreading.getScheduledPool().execute(this.agent::startConnectivityEstablishment);
        }

        public TransportAddress getSelectedRemoteAddress() {
            CandidatePair selectedPair = this.component.getSelectedPair();
            if (selectedPair == null) {
                throw new IllegalStateException("No candidate pair selected");
            }
            return selectedPair.getRemoteCandidate().getTransportAddress();
        }

        private static CompletableFuture<Void> createReadyFuture(Agent agent, boolean client) {
            CompletableFuture<Void> future2 = new CompletableFuture<Void>();
            Multithreading.schedule(() -> future2.completeExceptionally(new IceFailedException(client)), 30L, TimeUnit.SECONDS);
            Runnable update = () -> {
                IceProcessingState state = agent.getState();
                if (state.isEstablished()) {
                    future2.complete(null);
                } else if (state.isOver()) {
                    future2.completeExceptionally(new IceFailedException(client));
                }
            };
            agent.addStateChangeListener(event -> update.run());
            update.run();
            future2.exceptionally(__ -> {
                agent.free();
                return null;
            });
            return future2;
        }
    }

    private static class IceFailedException
    extends PrettyIOException {
        public IceFailedException(boolean client) {
            super((client ? "Server" : "Client") + " is unreachable (ICE failed)");
        }
    }

    private static class PrettyIOException
    extends IOException {
        public PrettyIOException(String message) {
            super(message);
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }
}

