/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.upnp;

import gg.essential.api.utils.Multithreading;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionInviteAddPacket;
import gg.essential.gui.notification.Notifications;
import gg.essential.handlers.discord.DiscordIntegration;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.universal.UMinecraft;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;

public class ServerUPnPSessionInviteAddPacketHandler
extends PacketHandler<ServerUPnPSessionInviteAddPacket> {
    private final Set<UUID> cooldowns = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerUPnPSessionInviteAddPacket packet) {
        UUID hostUUID;
        SPSManager spsManager = connectionManager.getSpsManager();
        UPnPSession session = spsManager.getRemoteSession(hostUUID = packet.getHostUUID());
        if (session == null || !EssentialConfig.INSTANCE.getEssentialFull() || this.cooldowns.contains(hostUUID)) {
            return;
        }
        if (EssentialConfig.INSTANCE.getDiscordSdk()) {
            List<DiscordIntegration.ActivityAdapter> adapters = DiscordIntegration.INSTANCE.getActivityAdapters();
            for (DiscordIntegration.ActivityAdapter adapter : adapters) {
                if (!adapter.removeInviteNotification(hostUUID)) continue;
                return;
            }
        }
        this.cooldowns.add(hostUUID);
        Multithreading.schedule(() -> this.cooldowns.remove(hostUUID), 7L, TimeUnit.SECONDS);
        class_310 mc = UMinecraft.getMinecraft();
        UUIDUtil.getName(hostUUID).thenAcceptAsync(hostName -> Notifications.INSTANCE.push("World Invite", hostName + " has invited you to join their world. Click here to join!", () -> {
            class_437 currentScreen = mc.field_1755;
            if (currentScreen == null) {
                currentScreen = new class_442();
            }
            class_642 serverData = new class_642(hostName, spsManager.getSpsAddress(hostUUID), false);
            serverData.method_2995(class_642.class_643.field_3767);
            class_412.method_36877((class_437)currentScreen, (class_310)mc, (class_639)class_639.method_2950((String)serverData.field_3761), (class_642)serverData);
            return Unit.INSTANCE;
        }), ExtensionsKt.getExecutor(mc));
    }
}

