/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.cosmetics;

import gg.essential.api.gui.Slot;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserUnlockedPacket;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.elementa.ElementaVersion;
import gg.essential.elementa.constraints.PixelConstraint;
import gg.essential.gui.common.CosmeticPreview;
import gg.essential.gui.notification.Notifications;
import gg.essential.gui.studio.CosmeticStudio;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import java.util.HashSet;
import java.util.Set;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

public class ServerCosmeticsUserUnlockedPacketHandler
extends PacketHandler<ServerCosmeticsUserUnlockedPacket> {
    private static CosmeticStudio openGui = null;

    public static void setOpenGui(CosmeticStudio gui) {
        openGui = gui;
    }

    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerCosmeticsUserUnlockedPacket packet) {
        CosmeticsManager cosmeticsManager = connectionManager.getCosmeticsManager();
        Set<String> unlockedCosmetics = cosmeticsManager.getUnlockedCosmetics();
        HashSet<String> newCosmetics = new HashSet<String>();
        for (String s : packet.getUnlocked()) {
            if (unlockedCosmetics.contains(s)) continue;
            newCosmetics.add(s);
        }
        cosmeticsManager.addUnlockedCosmetics(packet.getUnlocked());
        if (openGui != null) {
            openGui.processPurchase(newCosmetics);
        }
        if (packet.occurredFromPurchase()) {
            for (String newCosmetic : newCosmetics) {
                Cosmetic cosmetic = cosmeticsManager.getCosmetic(newCosmetic);
                if (cosmetic == null) continue;
                Notifications.INSTANCE.push("Purchase", "Your purchase of " + cosmetic.getDisplayName("en_us") + " has been processed.", 4.0f, () -> Unit.INSTANCE, () -> Unit.INSTANCE, notificationBuilder -> {
                    notificationBuilder.setElementaVersion(ElementaVersion.V1);
                    CosmeticPreview cosmeticPreview = new CosmeticPreview(cosmetic, null, null);
                    cosmeticPreview.getConstraints().setWidth(new PixelConstraint(50.0f));
                    cosmeticPreview.getConstraints().setHeight(new PixelConstraint(50.0f));
                    notificationBuilder.withCustomComponent(Slot.PREVIEW, cosmeticPreview);
                    return Unit.INSTANCE;
                });
            }
        }
    }
}

