/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.cosmetics;

import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticAnimationTriggerPacket;
import gg.essential.cosmetics.WearableBedrockModel;
import gg.essential.cosmetics.model.CosmeticType;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ServerCosmeticAnimationTriggerPacketHandler
extends PacketHandler<ServerCosmeticAnimationTriggerPacket> {
    private final CosmeticsManager manager;

    public ServerCosmeticAnimationTriggerPacketHandler(CosmeticsManager manager) {
        this.manager = manager;
    }

    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerCosmeticAnimationTriggerPacket packet) {
        Set<WeakReference<WearableBedrockModel>> models = WearableBedrockModel.models.get(packet.getUserId());
        if (models == null) {
            return;
        }
        models.removeIf(ref -> {
            WearableBedrockModel wearableBedrockModel = (WearableBedrockModel)ref.get();
            if (wearableBedrockModel == null) {
                return true;
            }
            CosmeticType cosmeticType = this.manager.getCosmeticType(wearableBedrockModel.getCosmetic().getType());
            if (cosmeticType != null && cosmeticType.getSlot() == packet.getCosmeticSlot()) {
                wearableBedrockModel.fireTriggerFromAnimation(packet.getTriggerName());
            }
            return false;
        });
        if (models.isEmpty()) {
            WearableBedrockModel.models.remove(packet.getUserId());
        }
    }
}

