/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.handler.chat;

import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import com.sparkuniverse.toolbox.chat.model.Channel;
import com.sparkuniverse.toolbox.chat.model.Message;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessagePacket;
import gg.essential.gui.friends.FriendsGui;
import gg.essential.gui.notification.Notifications;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.chat.ChatManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.universal.USound;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.GuiUtil;
import gg.essential.util.UUIDUtil;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Unit;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class ServerChatChannelMessagePacketHandler
extends PacketHandler<ServerChatChannelMessagePacket> {
    public static final AtomicInteger prefetching = new AtomicInteger();

    @Override
    protected void onHandle(@NotNull ConnectionManager connectionManager, @NotNull ServerChatChannelMessagePacket packet) {
        ChatManager chatManager = connectionManager.getChatManager();
        for (Message message : packet.getMessages()) {
            Optional<Channel> channelOptional = chatManager.getChannel(message.getChannelId());
            if (!channelOptional.isPresent()) {
                return;
            }
            Channel channel = channelOptional.get();
            chatManager.addMessageToChannel(channel.getId(), message);
            FriendsGui fg = FriendsGui.getInstance();
            if (fg != null) {
                fg.handleMessagePacket(message, channel);
                continue;
            }
            if (channel.isMuted() || prefetching.get() != 0 || !EssentialConfig.INSTANCE.getEssentialFull()) continue;
            UUIDUtil.getName(channel.getType() == ChannelType.DIRECT_MESSAGE ? ExtensionsKt.getOtherUser(channel) : message.getSender()).thenAcceptAsync((Consumer)new NotificationHandler(channel, message), ExtensionsKt.getExecutor(class_310.method_1551()));
        }
    }

    static class NotificationHandler
    implements Consumer<String> {
        private final Channel channel;
        private final Message message;

        NotificationHandler(Channel channel, Message message) {
            this.channel = channel;
            this.message = message;
        }

        @Override
        public void accept(String name) {
            String notificationTitle;
            String string = notificationTitle = this.channel.getType() == ChannelType.DIRECT_MESSAGE ? name : String.format("%s (%s)", this.channel.getName(), name);
            if (EssentialConfig.INSTANCE.getMessageSound() || EssentialConfig.INSTANCE.getStreamerMode()) {
                USound.INSTANCE.playExpSound();
            }
            if (this.message.getSender().equals(UUIDUtil.getClientUUID()) || this.message.isRead()) {
                return;
            }
            Notifications.INSTANCE.push(notificationTitle, this.message.getContents(), () -> {
                GuiUtil.INSTANCE.openScreen(new FriendsGui(this.channel.getId()));
                return Unit.INSTANCE;
            });
        }
    }
}

