/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gg.essential.Essential;
import gg.essential.api.utils.mojang.Model;
import gg.essential.connectionmanager.common.packet.cosmetic.ClientCosmeticsUserEquippedVisibilityTogglePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticAnimationTriggerPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticPlayerSettingsPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticTypesPopulatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsPopulatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsSkinTexturePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserEquippedPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserEquippedVisibilityPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.ServerCosmeticsUserUnlockedPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ClientCosmeticOutfitCosmeticSettingsUpdatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ClientCosmeticOutfitEquippedCosmeticsUpdatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ClientCosmeticOutfitSelectPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ClientCosmeticOutfitSelectedRequestPacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ClientCosmeticOutfitSkinUpdatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ServerCosmeticOutfitPopulatePacket;
import gg.essential.connectionmanager.common.packet.cosmetic.outfit.ServerCosmeticOutfitSelectedResponsePacket;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.holder.SkinLayersHolder;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticAssets;
import gg.essential.cosmetics.model.CosmeticOutfit;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.cosmetics.model.CosmeticType;
import gg.essential.event.network.server.ServerJoinEvent;
import gg.essential.handlers.EssentialSkinManager;
import gg.essential.handlers.GameProfileManager;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.model.EssentialAsset;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticEquipVisibilityResponse;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticAnimationTriggerPacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticOutfitPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticOutfitSelectedResponsePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticPlayerSettingsPacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticSkinTexturePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticTypesPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsUserEquippedPacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsUserEquippedVisibilityPacketHandler;
import gg.essential.network.connectionmanager.handler.cosmetics.ServerCosmeticsUserUnlockedPacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.network.cosmetics.OutfitSkin;
import gg.essential.network.cosmetics.dev.DevCosmetics;
import gg.essential.network.cosmetics.dev.DevCosmeticsImpl;
import gg.essential.universal.UMinecraft;
import gg.essential.util.Multithreading;
import gg.essential.util.Skin;
import gg.essential.util.UUIDUtil;
import gg.essential.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosmeticsManager
implements SubscriptionManager.Listener,
NetworkedManager {
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final SubscriptionManager subscriptionManager;
    @NotNull
    private final PacketQueue updateQueue;
    @Nullable
    private DevCosmetics devCosmetics;
    @NotNull
    private final Map<String, Cosmetic> cosmetics = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, CosmeticType> cosmeticTypes = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, CosmeticOutfit> outfits = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, ImmutableMap<CosmeticSlot, String>> equippedCosmetics = Maps.newConcurrentMap();
    @NotNull
    private final Map<UUID, ImmutableMap<String, ImmutableList<CosmeticSetting>>> cosmeticSettings = Maps.newConcurrentMap();
    @NotNull
    private final Set<String> unlockedCosmetics = Sets.newConcurrentHashSet();
    @NotNull
    private final Pattern PARTNER_TAG_REGEX = Pattern.compile("mod:(?<modID>.+)");
    @NotNull
    private final Pattern EVENT_TAG_REGEX = Pattern.compile("event:(?<event>.+)");
    @NotNull
    private final Map<String, CompletableFuture<Boolean>> cosmeticReadyStatus = new ConcurrentHashMap<String, CompletableFuture<Boolean>>();
    @NotNull
    private final @NotNull Map<String, CompletableFuture<byte @NotNull []>> assetFutures = new ConcurrentHashMap<String, CompletableFuture<byte[]>>();
    @NotNull
    private final Map<String, String> cosmeticNames = new ConcurrentHashMap<String, String>();
    private boolean ownCosmeticsVisible = true;
    private String selectedOutfit = null;
    private boolean initialMojangSkinSync = false;

    public CosmeticsManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.subscriptionManager = connectionManager.getSubscriptionManager();
        this.subscriptionManager.addListener(this);
        this.updateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
        connectionManager.registerPacketHandler(ServerCosmeticsPopulatePacket.class, new ServerCosmeticsPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticTypesPopulatePacket.class, new ServerCosmeticTypesPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticsUserUnlockedPacket.class, new ServerCosmeticsUserUnlockedPacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticOutfitPopulatePacket.class, new ServerCosmeticOutfitPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticAnimationTriggerPacket.class, new ServerCosmeticAnimationTriggerPacketHandler(this));
        connectionManager.registerPacketHandler(ServerCosmeticsUserEquippedPacket.class, new ServerCosmeticsUserEquippedPacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticsUserEquippedVisibilityPacket.class, new ServerCosmeticsUserEquippedVisibilityPacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticPlayerSettingsPacket.class, new ServerCosmeticPlayerSettingsPacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticOutfitSelectedResponsePacket.class, new ServerCosmeticOutfitSelectedResponsePacketHandler());
        connectionManager.registerPacketHandler(ServerCosmeticsSkinTexturePacket.class, new ServerCosmeticSkinTexturePacketHandler());
        Essential.EVENT_BUS.register(this);
    }

    @NotNull
    public Map<String, Cosmetic> getCosmetics() {
        if (this.devCosmetics == null) {
            this.loadDevCosmetics();
        }
        return Collections.unmodifiableMap(this.cosmetics);
    }

    @NotNull
    public Map<String, CosmeticType> getCosmeticTypes() {
        return Collections.unmodifiableMap(this.cosmeticTypes);
    }

    @NotNull
    public Map<String, CosmeticOutfit> getOutfits() {
        return this.outfits;
    }

    @NotNull
    public ImmutableMap<String, ImmutableList<CosmeticSetting>> getCosmeticSettings() {
        ImmutableMap result2 = this.getCosmeticSettings(UUIDUtil.getClientUUID());
        return result2 != null ? result2 : ImmutableMap.of();
    }

    @Nullable
    public ImmutableMap<String, ImmutableList<CosmeticSetting>> getCosmeticSettings(UUID playerId) {
        return this.cosmeticSettings.get(playerId);
    }

    public boolean getOwnCosmeticsVisible() {
        return this.ownCosmeticsVisible;
    }

    public void setOwnCosmeticsVisible(boolean state) {
        this.ownCosmeticsVisible = state;
    }

    public void setCosmeticSettings(@NotNull UUID playerId, @NotNull Map<String, List<CosmeticSetting>> settings) {
        if (this.subscriptionManager.isSubscribedOrSelf(playerId)) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            settings.forEach((key, value2) -> builder.put(key, (Object)ImmutableList.copyOf((Collection)value2)));
            this.cosmeticSettings.put(playerId, (ImmutableMap<String, ImmutableList<CosmeticSetting>>)builder.build());
        }
    }

    public void removeCosmeticSettings(@NotNull UUID playerId) {
        this.cosmeticSettings.remove(playerId);
    }

    public void removeEquippedCosmetics(@NotNull UUID playerId) {
        this.equippedCosmetics.remove(playerId);
    }

    public void updateCosmeticSettings(@NotNull String cosmeticId, @NotNull List<CosmeticSetting> settings) {
        HashMap<String, ImmutableList<CosmeticSetting>> cosmeticSettings = new HashMap<String, ImmutableList<CosmeticSetting>>((Map<String, ImmutableList<CosmeticSetting>>)this.getCosmeticSettings());
        if (!settings.isEmpty()) {
            cosmeticSettings.put(cosmeticId, (ImmutableList<CosmeticSetting>)settings);
        } else {
            cosmeticSettings.remove(cosmeticId);
        }
        this.setCosmeticSettings(UUIDUtil.getClientUUID(), cosmeticSettings);
        if (this.selectedOutfit != null) {
            CosmeticOutfit cosmeticOutfit = this.outfits.get(this.selectedOutfit);
            cosmeticOutfit.getCosmeticSettings().put(cosmeticId, settings);
            this.connectionManager.send(new ClientCosmeticOutfitCosmeticSettingsUpdatePacket(this.selectedOutfit, cosmeticId, settings));
        } else {
            Essential.logger.error("Unable to update cosmetic settings on connection manager. selectedEquipmentID is null");
        }
    }

    @NotNull
    public Set<String> getUnlockedCosmetics() {
        return this.unlockedCosmetics;
    }

    public void addUnlockedCosmetics(@NotNull Collection<String> unlockedCosmetics) {
        this.unlockedCosmetics.addAll(unlockedCosmetics);
    }

    @NotNull
    public ImmutableMap<CosmeticSlot, String> getEquippedCosmetics() {
        ImmutableMap result2 = this.getEquippedCosmetics(UUIDUtil.getClientUUID());
        return result2 != null ? result2 : ImmutableMap.of();
    }

    @Nullable
    public ImmutableMap<CosmeticSlot, String> getEquippedCosmetics(UUID playerId) {
        return this.equippedCosmetics.get(playerId);
    }

    public void setEquippedCosmetics(@NotNull UUID playerId, @NotNull Map<CosmeticSlot, String> equippedCosmetics) {
        if (this.subscriptionManager.isSubscribedOrSelf(playerId)) {
            this.equippedCosmetics.put(playerId, (ImmutableMap<CosmeticSlot, String>)ImmutableMap.copyOf(equippedCosmetics));
        }
    }

    public void updateEquippedCosmetic(@NotNull CosmeticSlot slot, @Nullable String cosmeticId) {
        if (this.selectedOutfit != null) {
            CosmeticOutfit cosmeticOutfit = this.outfits.get(this.selectedOutfit);
            this.updateEquippedCosmetic(cosmeticOutfit, slot, cosmeticId);
        }
    }

    public void updateEquippedCosmetic(int outfitIndex, @NotNull CosmeticSlot slot, @Nullable String cosmeticId) {
        List<CosmeticOutfit> orderedOutfits = this.getOrderedOutfits();
        if (outfitIndex < 0 || outfitIndex > orderedOutfits.size() - 1) {
            return;
        }
        CosmeticOutfit outfit = orderedOutfits.get(outfitIndex);
    }

    private void updateEquippedCosmetic(@NotNull CosmeticOutfit outfit, @NotNull CosmeticSlot slot, @Nullable String cosmeticId) {
        if (cosmeticId != null) {
            outfit.getEquippedCosmetics().put(slot, cosmeticId);
        } else {
            outfit.getEquippedCosmetics().remove((Object)slot);
        }
        this.connectionManager.send(new ClientCosmeticOutfitEquippedCosmeticsUpdatePacket(outfit.getId(), slot, cosmeticId));
        if (outfit.getId().equals(this.selectedOutfit)) {
            HashMap<CosmeticSlot, String> equippedCosmetics = new HashMap<CosmeticSlot, String>((Map<CosmeticSlot, String>)this.getEquippedCosmetics());
            if (cosmeticId != null) {
                equippedCosmetics.put(slot, cosmeticId);
            } else {
                equippedCosmetics.remove((Object)slot);
            }
            this.setEquippedCosmetics(UUIDUtil.getClientUUID(), equippedCosmetics);
        }
    }

    @NotNull
    public ImmutableMap<CosmeticSlot, String> getVisibleCosmetics(UUID playerId) {
        ImmutableMap result2 = this.getEquippedCosmetics(playerId);
        if (!this.ownCosmeticsVisible && playerId.equals(UUIDUtil.getClientUUID())) {
            result2 = null;
        }
        return result2 != null ? result2 : ImmutableMap.of();
    }

    @NotNull
    public Optional<Cosmetic> getCosmeticOptional(@NotNull String cosmeticId) {
        return Optional.ofNullable(this.getCosmetic(cosmeticId));
    }

    @Nullable
    public Cosmetic getCosmetic(@NotNull String cosmeticId) {
        return this.cosmetics.get(cosmeticId);
    }

    public boolean hasEquipped(String cosmeticId) {
        return this.hasEquipped(UUIDUtil.getClientUUID(), cosmeticId);
    }

    public boolean hasEquipped(UUID uuid, String cosmeticId) {
        ImmutableMap<CosmeticSlot, String> equippedCosmetics = this.getEquippedCosmetics(uuid);
        if (equippedCosmetics == null) {
            return false;
        }
        return equippedCosmetics.containsValue(cosmeticId);
    }

    @NotNull
    public Optional<CosmeticType> getCosmeticTypeOptional(@NotNull String cosmeticId) {
        return Optional.ofNullable(this.getCosmeticType(cosmeticId));
    }

    @Nullable
    public CosmeticType getCosmeticType(@NotNull String cosmeticType) {
        return this.cosmeticTypes.get(cosmeticType);
    }

    @Nullable
    public CosmeticType getCosmeticType(@NotNull Cosmetic cosmetic) {
        return this.cosmeticTypes.get(cosmetic.getType());
    }

    @Nullable
    public CosmeticType getCosmeticTypeByCosmeticId(@NotNull String cosmeticId) {
        Cosmetic cosmetic = this.getCosmetic(cosmeticId);
        if (cosmetic == null) {
            return null;
        }
        return this.getCosmeticType(cosmetic);
    }

    private DevCosmetics getDevCosmetics() {
        if (this.devCosmetics == null) {
            Path path = Essential.getInstance().getBaseDir().toPath().resolve("cosmetics");
            if (Files.exists(path, new LinkOption[0])) {
                Path inner = path.resolve("cosmetics");
                if (Files.exists(inner, new LinkOption[0])) {
                    path = inner;
                }
                try {
                    this.devCosmetics = new DevCosmeticsImpl(this, path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.devCosmetics == null) {
                this.devCosmetics = DevCosmetics.None.INSTANCE;
            }
        }
        return this.devCosmetics;
    }

    public void addCosmetic(@NotNull Cosmetic cosmetic) {
        cosmetic = this.getDevCosmetics().substitute(cosmetic);
        this.cosmetics.put(cosmetic.getId(), cosmetic);
        this.cosmeticReadyStatus.remove(cosmetic.getId());
        this.getCosmeticReadyStatus(cosmetic);
        @Nullable CosmeticSetting[] settings = cosmetic.getSettings();
        if (settings != null) {
            for (CosmeticSetting setting : settings) {
                if (setting == null || !"localization".equalsIgnoreCase(setting.getType())) continue;
                this.cosmeticNames.put(setting.getId(), (String)setting.getData("en_US"));
            }
        }
    }

    @NotNull
    public CompletableFuture<Boolean> getCosmeticReadyStatus(@NotNull Cosmetic cosmetic) {
        return this.cosmeticReadyStatus.computeIfAbsent(cosmetic.getId(), key -> {
            CosmeticAssets assets = cosmetic.getAssets();
            return CompletableFuture.allOf((CompletableFuture[])Arrays.stream(new EssentialAsset[]{assets.getAnimations(), assets.getGeometry().getSteve(), assets.getGeometry().getAlex(), assets.getSkinMask() == null ? null : assets.getSkinMask().getSteve(), assets.getSkinMask() == null ? null : assets.getSkinMask().getAlex(), assets.getTexture()}).filter(Objects::nonNull).map(this::getAssetBytes).toArray(CompletableFuture[]::new)).handle((done, throwable) -> throwable == null);
        });
    }

    @NotNull
    public CompletableFuture<byte[]> getAssetBytes(@NotNull EssentialAsset asset) {
        return this.assetFutures.computeIfAbsent(asset.getChecksum(), key -> CompletableFuture.supplyAsync(() -> {
            byte[] bytes;
            Path cachePath2 = this.getAssetCachePath(asset);
            if (Files.exists(cachePath2, new LinkOption[0])) {
                try {
                    bytes = Files.readAllBytes(cachePath2);
                    String checksum = DigestUtils.md5Hex((byte[])bytes);
                    if (checksum.equalsIgnoreCase(asset.getChecksum())) {
                        return bytes;
                    }
                    Essential.logger.warn("Checksum mismatch for {}: {}", (Object)cachePath2, (Object)checksum);
                }
                catch (IOException e) {
                    Essential.logger.warn("Failed to read asset from cache at " + cachePath2 + ": ", (Throwable)e);
                }
            }
            Essential.logger.debug("Downloading asset: {} -> {}", (Object)asset.getUrl(), (Object)cachePath2);
            try {
                bytes = WebUtil.downloadToBytes(asset.getUrl(), "Mozilla/4.76 (Essential Asset Downloader)");
            }
            catch (IOException e) {
                Essential.logger.error("Failed to download \"" + asset.getUrl() + "\": ", (Throwable)e);
                throw new CompletionException(e);
            }
            try {
                Files.createDirectories(cachePath2.getParent(), new FileAttribute[0]);
                Files.write(cachePath2, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                Essential.logger.error("Failed to cache \"" + asset.getUrl() + "\" at \"" + cachePath2 + "\": ", (Throwable)e);
            }
            return bytes;
        }, Multithreading.POOL));
    }

    private Path getAssetCachePath(EssentialAsset asset) {
        String checksum = asset.getChecksum();
        return Essential.getInstance().getBaseDir().toPath().resolve("cosmetic-cache").resolve(String.valueOf(checksum.charAt(0))).resolve(String.valueOf(checksum.charAt(1))).resolve(checksum.substring(2));
    }

    @Deprecated
    public InputStream getCosmeticAsset(EssentialAsset cosmeticAsset) throws FileNotFoundException {
        try {
            return new ByteArrayInputStream(this.getAssetBytes(cosmeticAsset).join());
        }
        catch (CompletionException e) {
            throw new FileNotFoundException(this.getAssetCachePath(cosmeticAsset).toString());
        }
    }

    public String supplyAssetBytes(byte[] bytes) {
        String checksum = DigestUtils.md5Hex((byte[])bytes);
        this.assetFutures.put(checksum, CompletableFuture.completedFuture(bytes));
        return checksum;
    }

    public void addCosmeticType(@NotNull CosmeticType cosmeticType) {
        this.cosmeticTypes.put(cosmeticType.getId(), cosmeticType);
    }

    public void removeCosmetic(@NotNull String cosmeticId) {
        this.cosmetics.remove(cosmeticId);
    }

    public void removeCosmeticType(@NotNull String cosmeticTypeId) {
        this.cosmeticTypes.remove(cosmeticTypeId);
    }

    public void removeCosmeticSetting(@NotNull String cosmeticId) {
        this.cosmeticSettings.remove(cosmeticId);
    }

    public void clearCosmetics() {
        this.cosmetics.clear();
        this.cosmeticNames.clear();
    }

    public void clearCosmeticTypes() {
        this.cosmeticTypes.clear();
    }

    public void clearCosmeticSettings() {
        this.cosmeticSettings.clear();
    }

    public void clearUnlockedCosmetics() {
        this.unlockedCosmetics.clear();
    }

    public void clearEquippedCosmetics() {
        this.equippedCosmetics.clear();
    }

    @Override
    public void resetState() {
        this.updateQueue.reset();
        this.setSelectedOutfit(null);
        this.outfits.clear();
        this.clearEquippedCosmetics();
        this.clearUnlockedCosmetics();
        this.clearCosmeticSettings();
        this.clearCosmeticTypes();
        this.clearCosmetics();
    }

    @Override
    public void onConnected() {
        this.resetState();
        this.connectionManager.send(new ClientCosmeticsUserEquippedVisibilityTogglePacket(this.ownCosmeticsVisible), new CosmeticEquipVisibilityResponse(this.ownCosmeticsVisible, false));
    }

    @Override
    public void onSubscriptionAdded(@NotNull Set<UUID> uuids) {
        for (UUID uuid : uuids) {
            this.connectionManager.send(new ClientCosmeticOutfitSelectedRequestPacket(uuid));
        }
    }

    @Override
    public void onSubscriptionRemoved(@NotNull Set<UUID> uuids) {
        for (UUID uuid : uuids) {
            this.equippedCosmetics.remove(uuid);
            this.cosmeticSettings.remove(uuid);
        }
    }

    public void loadDevCosmetics() {
        for (Map.Entry<String, Cosmetic> entry : this.getDevCosmetics().getAll().entrySet()) {
            if (this.cosmetics.containsKey(entry.getKey())) continue;
            this.addCosmetic(entry.getValue());
        }
        for (Map.Entry<String, SkinLayersHolder> entry : this.getDevCosmetics().getTypes().entrySet()) {
            if (this.cosmeticTypes.containsKey(entry.getKey())) continue;
            this.addCosmeticType((CosmeticType)entry.getValue());
        }
    }

    public boolean isCreatorPartnerCosmetic(String cosmeticId) {
        Cosmetic cosmetic = this.cosmetics.get(cosmeticId);
        if (cosmetic == null) {
            return false;
        }
        return cosmetic.getTags().contains("PARTNER");
    }

    public boolean isPartnerCosmetic(String cosmeticID) {
        return this.isCreatorPartnerCosmetic(cosmeticID) || this.isModPartnerCosmetic(cosmeticID) || this.isEventPartnerCosmetic(cosmeticID);
    }

    public boolean isModPartnerCosmetic(String cosmeticId) {
        Cosmetic cosmetic = this.cosmetics.get(cosmeticId);
        if (cosmetic == null) {
            return false;
        }
        for (String tag2 : cosmetic.getTags()) {
            if (!this.PARTNER_TAG_REGEX.matcher(tag2).find()) continue;
            return true;
        }
        return false;
    }

    public boolean isEventPartnerCosmetic(String cosmeticId) {
        Cosmetic cosmetic = this.cosmetics.get(cosmeticId);
        if (cosmetic == null) {
            return false;
        }
        for (String tag2 : cosmetic.getTags()) {
            if (!this.EVENT_TAG_REGEX.matcher(tag2).find()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getEventIDOfCosmetic(String cosmeticId) {
        if (!this.isEventPartnerCosmetic(cosmeticId)) {
            return null;
        }
        Cosmetic cosmetic = this.cosmetics.get(cosmeticId);
        for (String tag2 : cosmetic.getTags()) {
            Matcher matcher = this.EVENT_TAG_REGEX.matcher(tag2);
            if (!matcher.find()) continue;
            return matcher.group("event");
        }
        return null;
    }

    @Nullable
    public String getModIdOfCosmetic(String cosmeticId) {
        if (!this.isModPartnerCosmetic(cosmeticId)) {
            return null;
        }
        Cosmetic cosmetic = this.cosmetics.get(cosmeticId);
        for (String tag2 : cosmetic.getTags()) {
            Matcher matcher = this.PARTNER_TAG_REGEX.matcher(tag2);
            if (!matcher.find()) continue;
            return matcher.group("modID");
        }
        return null;
    }

    @Nullable
    public String getPartnerName(@NotNull String id2) {
        if (this.cosmeticNames.containsKey(id2)) {
            return this.cosmeticNames.get(id2);
        }
        if (this.isModPartnerCosmetic(id2)) {
            return this.getModIdOfCosmetic(id2);
        }
        if (this.isCreatorPartnerCosmetic(id2)) {
            return class_1074.method_4662((String)("cosmetic." + id2 + ".partnername"), (Object[])new Object[0]);
        }
        if (this.isEventPartnerCosmetic(id2)) {
            return class_1074.method_4662((String)("studio." + this.getEventIDOfCosmetic(id2)), (Object[])new Object[0]);
        }
        return null;
    }

    public void updateOutfitSkin(OutfitSkin skin, boolean allProfiles) {
        if (this.selectedOutfit == null && !allProfiles) {
            return;
        }
        String formatted = skin.serialize();
        for (CosmeticOutfit value2 : this.outfits.values()) {
            if (formatted.equals(value2.getSkinTexture()) || !allProfiles && !value2.getId().equals(this.selectedOutfit)) continue;
            value2.setSkinTexture(formatted);
            this.connectionManager.send(new ClientCosmeticOutfitSkinUpdatePacket(value2.getId(), formatted));
        }
    }

    public void selectOutfit(int index2) {
        List<CosmeticOutfit> orderedOutfits = this.getOrderedOutfits();
        if (index2 > orderedOutfits.size() - 1) {
            return;
        }
        CosmeticOutfit cosmeticOutfit = orderedOutfits.get(index2);
        CosmeticOutfit oldOutfit = this.setSelectedOutfit(cosmeticOutfit);
        this.connectionManager.send(new ClientCosmeticOutfitSelectPacket(cosmeticOutfit.getId()));
        if (cosmeticOutfit.getSkinTexture() != null && !OutfitSkin.skinEquals(cosmeticOutfit, oldOutfit)) {
            this.applyOutfitSkin(cosmeticOutfit, false);
        }
    }

    private void applyOutfitSkin(CosmeticOutfit cosmeticOutfit, boolean updateWithMojang) {
        Skin skin;
        if (cosmeticOutfit.getSkinTexture() == null) {
            return;
        }
        GameProfileManager gameProfileManager = Essential.getInstance().getGameProfileManager();
        EssentialSkinManager skinManager = Essential.getInstance().getSkinManager();
        OutfitSkin outfitSkin = OutfitSkin.getOutfitSkin(cosmeticOutfit);
        Skin skin2 = skin = outfitSkin != null ? outfitSkin.getSkin() : null;
        if (skin != null) {
            Model model = skin.getModel();
            String hash = skin.getHash();
            gameProfileManager.updatePlayerSkin(UUIDUtil.getClientUUID(), hash, model.getType());
            if (updateWithMojang) {
                skinManager.changeSkin(UMinecraft.getMinecraft().method_1548().method_1674(), model, String.format("https://textures.minecraft.net/texture/%s", hash));
            }
        }
    }

    public List<CosmeticOutfit> getOrderedOutfits() {
        ArrayList<CosmeticOutfit> outfits = new ArrayList<CosmeticOutfit>(this.outfits.values());
        outfits.sort(Comparator.comparingLong(value2 -> value2.getCreatedAt().getTime()));
        return outfits;
    }

    @Nullable
    public CosmeticOutfit setSelectedOutfit(@Nullable CosmeticOutfit outfit) {
        CosmeticOutfit oldOutfit;
        CosmeticOutfit cosmeticOutfit = oldOutfit = this.selectedOutfit != null ? this.outfits.get(this.selectedOutfit) : null;
        if (oldOutfit != null) {
            oldOutfit.setSelected(false);
            this.selectedOutfit = null;
        }
        if (outfit == null) {
            return oldOutfit;
        }
        outfit.setSelected(true);
        this.selectedOutfit = outfit.getId();
        this.setEquippedCosmetics(UUIDUtil.getClientUUID(), outfit.getEquippedCosmetics());
        this.setCosmeticSettings(UUIDUtil.getClientUUID(), outfit.getCosmeticSettings());
        if (!OutfitSkin.skinEquals(outfit, oldOutfit)) {
            this.applyOutfitSkin(outfit, oldOutfit != null);
        }
        if (!this.initialMojangSkinSync) {
            this.initialMojangSkinSync = true;
            this.initialSyncSkinFromMojang();
        }
        return oldOutfit;
    }

    private void initialSyncSkinFromMojang() {
        this.syncSkinFromMojang(Essential.getInstance().getSkinManager().getActiveSkin());
    }

    private void syncSkinFromMojang() {
        Skin skin = Essential.getInstance().getSkinManager().fetchActiveSkin();
        if (skin != null) {
            this.syncSkinFromMojang(skin);
        }
    }

    private void syncSkinFromMojang(Skin mojangSkin) {
        boolean selectedOutfitLocked;
        CosmeticOutfit selectedOutfit;
        CosmeticOutfit cosmeticOutfit = selectedOutfit = this.selectedOutfit != null ? this.outfits.get(this.selectedOutfit) : null;
        if (selectedOutfit == null) {
            return;
        }
        OutfitSkin selectedOutfitSkin = OutfitSkin.getOutfitSkin(selectedOutfit);
        boolean bl = selectedOutfitLocked = selectedOutfitSkin != null && selectedOutfitSkin.getLocked();
        if (selectedOutfitLocked && selectedOutfitSkin.getSkin().equals(mojangSkin)) {
            return;
        }
        String formatted = new OutfitSkin(mojangSkin, false).serialize();
        for (CosmeticOutfit orderedOutfit : this.getOrderedOutfits()) {
            OutfitSkin outfitSkin = OutfitSkin.getOutfitSkin(orderedOutfit);
            if (outfitSkin != null && outfitSkin.getLocked() || formatted.equals(orderedOutfit.getSkinTexture())) continue;
            orderedOutfit.setSkinTexture(formatted);
            this.connectionManager.send(new ClientCosmeticOutfitSkinUpdatePacket(orderedOutfit.getId(), formatted));
        }
        this.applyOutfitSkin(selectedOutfit, selectedOutfitLocked);
    }

    public void setCurrentSkinUserSelected(boolean locked) {
        if (this.selectedOutfit == null) {
            return;
        }
        CosmeticOutfit cosmeticOutfit = this.outfits.get(this.selectedOutfit);
        OutfitSkin skin = OutfitSkin.getOutfitSkin(cosmeticOutfit);
        if (skin == null) {
            return;
        }
        skin = skin.withLocked(locked);
        String formatted = skin.serialize();
        cosmeticOutfit.setSkinTexture(formatted);
        this.connectionManager.send(new ClientCosmeticOutfitSkinUpdatePacket(this.selectedOutfit, formatted));
    }

    @Subscribe
    public void onWorldJoin(ServerJoinEvent event) {
        Multithreading.runAsync(() -> this.syncSkinFromMojang());
    }
}

