/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.chat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sparkuniverse.toolbox.chat.enums.ChannelType;
import com.sparkuniverse.toolbox.chat.model.Channel;
import com.sparkuniverse.toolbox.chat.model.Message;
import gg.essential.Essential;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelMemberAddPacket;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelMemberRemovePacket;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelMessageDeletePacket;
import gg.essential.connectionmanager.common.packet.chat.ChatChannelUpdatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelCreatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessageCreatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessageReadStatePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessageReportPacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMessagesRetrievePacket;
import gg.essential.connectionmanager.common.packet.chat.ClientChatChannelMutePacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChannelMemberActionResponsePacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatAnnouncementsChannelPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelAddPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelClearPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessagePacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessageReportPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelMessageReportReasonsPacket;
import gg.essential.connectionmanager.common.packet.chat.ServerChatChannelRemovePacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.gui.friends.FriendsGui;
import gg.essential.gui.notification.Notifications;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelMemberAddPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelMemberRemovePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelMessageDeletePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ChatChannelUpdatePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatAnnouncementsChannelPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelAddPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelClearPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelMessagePacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelMessageReportReasonsPacketHandler;
import gg.essential.network.connectionmanager.handler.chat.ServerChatChannelRemovePacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.util.CachedAvatarImage;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.UUIDUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatManager
implements NetworkedManager {
    @NotNull
    private final Map<Long, Channel> channels = Maps.newConcurrentMap();
    @NotNull
    private final Map<Long, ConcurrentMap<Long, Message>> channelMessages = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, Map<String, String>> reportReasons = Maps.newConcurrentMap();
    @NotNull
    private final Set<Long> announcementChannelIds = Sets.newConcurrentHashSet();
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final PacketQueue mutedStateUpdateQueue;
    private int unreadMessages = -1;

    public ChatManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.mutedStateUpdateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
        connectionManager.registerPacketHandler(ChatChannelMemberAddPacket.class, new ChatChannelMemberAddPacketHandler());
        connectionManager.registerPacketHandler(ChatChannelMessageDeletePacket.class, new ChatChannelMessageDeletePacketHandler());
        connectionManager.registerPacketHandler(ChatChannelMemberRemovePacket.class, new ChatChannelMemberRemovePacketHandler());
        connectionManager.registerPacketHandler(ChatChannelUpdatePacket.class, new ChatChannelUpdatePacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelAddPacket.class, new ServerChatChannelAddPacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelClearPacket.class, new ServerChatChannelClearPacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelMessagePacket.class, new ServerChatChannelMessagePacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelRemovePacket.class, new ServerChatChannelRemovePacketHandler());
        connectionManager.registerPacketHandler(ServerChatChannelMessageReportReasonsPacket.class, new ServerChatChannelMessageReportReasonsPacketHandler());
        connectionManager.registerPacketHandler(ServerChatAnnouncementsChannelPacket.class, new ServerChatAnnouncementsChannelPacketHandler());
    }

    @NotNull
    public Map<Long, Channel> getChannels() {
        return this.channels;
    }

    @NotNull
    public Map<String, Map<String, String>> getReportReasons() {
        return this.reportReasons;
    }

    public void setReportReasons(@Nullable Map<String, Map<String, String>> reportReasons) {
        this.reportReasons.clear();
        if (reportReasons == null) {
            return;
        }
        this.reportReasons.putAll(reportReasons);
    }

    @NotNull
    public Optional<Channel> getChannel(@NotNull Long id2) {
        return Optional.ofNullable(this.channels.get(id2));
    }

    public long getPrimaryAnnouncementChannelId() {
        Channel channel = this.getPrimaryAnnouncementChannel();
        return channel != null ? channel.getId() : 0L;
    }

    @Nullable
    public Channel getPrimaryAnnouncementChannel() {
        for (Channel channel : this.channels.values()) {
            if (channel.getType() != ChannelType.ANNOUNCEMENT) continue;
            return channel;
        }
        return null;
    }

    @NotNull
    public Set<Long> getAnnouncementChannelIds() {
        return this.announcementChannelIds;
    }

    public void setAnnouncementChannelIds(@NotNull Set<Long> channelIds) {
        this.announcementChannelIds.clear();
        this.announcementChannelIds.addAll(channelIds);
    }

    @NotNull
    public Map<String, String> getReportReasons(@NotNull String preferredLocale) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : this.reportReasons.entrySet()) {
            Map<String, String> values2 = entry.getValue();
            String value2 = values2.get(preferredLocale);
            if (value2 == null) {
                value2 = values2.get("en_US");
            }
            builder.put((Object)entry.getKey(), (Object)value2);
        }
        return builder.build();
    }

    public void addChannels(@NotNull Iterable<Channel> channels) {
        for (Channel channel : channels) {
            this.addChannel(channel);
        }
    }

    public void addChannel(@NotNull Channel channel) {
        FriendsGui friendsGui;
        this.channels.put(channel.getId(), channel);
        for (UUID member : channel.getMembers()) {
            CachedAvatarImage.ofUUID(member);
            UUIDUtil.getName(member);
        }
        ServerChatChannelMessagePacketHandler.prefetching.incrementAndGet();
        this.retrieveRecentMessageHistory(channel.getId(), 10, packet -> ServerChatChannelMessagePacketHandler.prefetching.decrementAndGet());
        if (ExtensionsKt.isAnnouncement(channel)) {
            Iterator<Comparable<UUID>> iterator2 = this.announcementChannelIds.iterator();
            while (iterator2.hasNext()) {
                long announcementChannelId = (Long)iterator2.next();
                if (announcementChannelId == channel.getId()) continue;
                ServerChatChannelMessagePacketHandler.prefetching.incrementAndGet();
                this.retrieveRecentMessageHistory(announcementChannelId, 100, packet -> ServerChatChannelMessagePacketHandler.prefetching.decrementAndGet());
            }
        }
        if ((friendsGui = FriendsGui.getInstance()) != null) {
            friendsGui.onNewChatChannel(channel);
        }
    }

    public void setChannelInfo(long channelId, @Nullable String channelName, @Nullable String channelTopic) {
        FriendsGui friendsGui;
        Optional<Channel> channelOptional = this.getChannel(channelId);
        if (!channelOptional.isPresent()) {
            return;
        }
        Channel channel = channelOptional.get();
        if (channelName != null) {
            channel.setName(channelName);
        }
        if (channelTopic != null) {
            channel.setTopic(channelTopic);
        }
        if ((friendsGui = FriendsGui.getInstance()) != null) {
            friendsGui.updateChannelInfo(channel);
        }
    }

    public void removeChannels(long[] channelIds) {
        for (long channelId : channelIds) {
            this.removeChannel(channelId);
        }
    }

    public void removeChannels(@NotNull Iterable<Long> channelIds) {
        for (long channelId : channelIds) {
            this.removeChannel(channelId);
        }
    }

    @Nullable
    public Channel removeChannel(long id2) {
        FriendsGui friendsGui;
        Channel channel = this.channels.remove(id2);
        this.channelMessages.remove(id2);
        this.updateUnreads();
        if (channel != null && (friendsGui = FriendsGui.getInstance()) != null) {
            friendsGui.deleteGroup(id2);
        }
        return channel;
    }

    public void clearChannels() {
        this.channels.clear();
        this.channelMessages.clear();
        this.announcementChannelIds.clear();
        this.reportReasons.clear();
        this.updateUnreads();
    }

    @Override
    public void onConnected() {
        this.mutedStateUpdateQueue.reset();
        this.resetState();
    }

    @Override
    public void resetState() {
        this.clearChannels();
    }

    @Nullable
    public Map<Long, Message> getMessages(long channelId) {
        ConcurrentMap<Long, Message> messageMap = this.channelMessages.get(channelId);
        return messageMap != null ? Collections.unmodifiableMap(messageMap) : null;
    }

    public void addMessageToChannel(long channelId, @NotNull Message message) {
        ConcurrentMap map2 = this.channelMessages.get(channelId);
        if (map2 == null) {
            map2 = Maps.newConcurrentMap();
            this.channelMessages.put(channelId, map2);
        }
        map2.put(message.getId(), message);
        this.updateUnreads();
    }

    public void sendMessage(long channelId, @NotNull String messageContent) {
        this.sendMessage(channelId, messageContent, null);
    }

    public void sendMessage(long channelId, @NotNull String messageContent, @Nullable Consumer<Optional<Packet>> callback) {
        this.connectionManager.send(new ClientChatChannelMessageCreatePacket(channelId, messageContent), callback);
    }

    public void removeMessage(long channelId, long messageId) {
        Message message;
        ConcurrentMap<Long, Message> channelMessages = this.channelMessages.get(channelId);
        if (channelMessages != null && (message = (Message)channelMessages.remove(messageId)) != null) {
            this.updateUnreads();
            FriendsGui friendsGui = FriendsGui.getInstance();
            if (friendsGui != null) {
                friendsGui.onMessageDeleted(message);
            }
        }
    }

    public void deleteMessage(long channelId, long messageId) {
        this.deleteMessage(channelId, messageId, null);
        this.removeMessage(channelId, messageId);
    }

    public void deleteMessage(long channelId, long messageId, @Nullable Consumer<Optional<Packet>> callback) {
        this.connectionManager.send(new ChatChannelMessageDeletePacket(channelId, messageId), callback);
    }

    public void createGroupDM(@NotNull UUID[] members2, @Nullable String groupName, @Nullable Consumer<Optional<Channel>> callback) {
        for (UUID member : members2) {
            if (this.connectionManager.getRelationshipManager().isFriend(member) || member == UUIDUtil.getClientUUID()) continue;
            Notifications.INSTANCE.push("Failed to create group", "You are not friends with one of the members");
            if (callback != null) {
                callback.accept(Optional.empty());
            }
            return;
        }
        if (groupName == null) {
            groupName = "New Group";
        } else if (groupName.length() > 64) {
            groupName = groupName.substring(0, 63);
        }
        this.connectionManager.send(new ClientChatChannelCreatePacket(ChannelType.GROUP_DIRECT_MESSAGE, groupName, members2), response2 -> {
            Optional<Object> channel;
            if (!response2.isPresent()) {
                Notifications.INSTANCE.push("Error", "A timeout occurred please try again");
                channel = Optional.empty();
            } else if (response2.get() instanceof ServerChatChannelAddPacket) {
                channel = ((ServerChatChannelAddPacket)response2.get()).getChannels().stream().findFirst();
            } else {
                Notifications.INSTANCE.push("Error", "An unexpected error occurred");
                channel = Optional.empty();
            }
            if (callback != null) {
                callback.accept(channel);
            }
        });
    }

    public void createDM(@NotNull UUID otherParty, @Nullable String playerName, @Nullable Consumer<Optional<Packet>> callback) {
        if (!this.connectionManager.getRelationshipManager().isFriend(otherParty)) {
            Notifications.INSTANCE.push("Failed to create DM", "You are not friends with this player");
            return;
        }
        this.connectionManager.send(new ClientChatChannelCreatePacket(ChannelType.DIRECT_MESSAGE, playerName, new UUID[]{otherParty}), callback);
    }

    public void updateChannelInformation(long channelId, @Nullable String channelName, @Nullable String channelTopic) {
        Channel currentChannelInfo = this.channels.get(channelId);
        if (currentChannelInfo == null) {
            Notifications.INSTANCE.push("Error updating channel", "Channel does not exist");
            return;
        }
        if (channelName == null) {
            channelName = currentChannelInfo.getName();
        } else if (channelName.length() > 64) {
            channelName = channelName.substring(0, 63);
        }
        if (channelTopic == null) {
            channelTopic = currentChannelInfo.getTopic();
        }
        if (channelName.equals(currentChannelInfo.getName()) && (channelTopic == null || channelTopic.equals(currentChannelInfo.getTopic()))) {
            Notifications.INSTANCE.push("Error updating channel", "Nothing to update");
            return;
        }
        ChatChannelUpdatePacket update = new ChatChannelUpdatePacket(channelId, channelName, channelTopic);
        this.connectionManager.send(update, responseOptional -> {
            Packet packet = responseOptional.orElse(null);
            if (!(packet instanceof ResponseActionPacket) || !((ResponseActionPacket)packet).isSuccessful()) {
                Notifications.INSTANCE.push("Error updating channel", "An unexpected error has occurred. Try again.");
                return;
            }
            this.setChannelInfo(channelId, update.getName(), update.getTopic());
        });
    }

    public void addPlayerToChannel(long channelId, @NotNull UUID player2) {
        Channel channel = this.channels.get(channelId);
        if (channel == null) {
            Notifications.INSTANCE.push("Error adding player", "Channel does not exist");
            return;
        }
        if (channel.getType() != ChannelType.GROUP_DIRECT_MESSAGE) {
            Notifications.INSTANCE.push("Error adding player", "Channel is not a group DM");
            return;
        }
        if (channel.getType().hasUserLimit() && channel.getMembers().size() + 1 > channel.getType().getBaseUserLimit()) {
            Notifications.INSTANCE.push("Error adding player", "Channel has reached it's user limit");
            return;
        }
        this.connectionManager.send(new ChatChannelMemberAddPacket(channelId, new UUID[]{player2}), maybePacket -> {
            Packet packet = maybePacket.orElse(null);
            if (packet instanceof ServerChannelMemberActionResponsePacket) {
                for (Map.Entry<UUID, Boolean> entry : ((ServerChannelMemberActionResponsePacket)packet).getResults().entrySet()) {
                    UUID uuid = entry.getKey();
                    if (entry.getValue().booleanValue()) {
                        channel.getMembers().add(uuid);
                        continue;
                    }
                    UUIDUtil.getName(uuid).thenAccept(name -> Notifications.INSTANCE.push("Error adding player", "Failed to adding " + name + " to group."));
                }
                FriendsGui friendsGui = FriendsGui.getInstance();
                if (friendsGui != null) {
                    friendsGui.updateChannelInfo(channel);
                }
            } else {
                Notifications.INSTANCE.push("Error adding player", "An unexpected error has occurred. Try again.");
            }
        });
    }

    public void removePlayerFromChannel(long channelId, @NotNull UUID player2) {
        Channel channel = this.channels.get(channelId);
        if (channel == null) {
            Notifications.INSTANCE.push("Error removing player", "Channel does not exist");
            return;
        }
        if (channel.getType() != ChannelType.GROUP_DIRECT_MESSAGE) {
            Notifications.INSTANCE.push("Error removing player", "Channel is not a group DM");
            return;
        }
        if (!channel.getMembers().contains(player2)) {
            Notifications.INSTANCE.push("Error removing player", "User is not in group.");
            return;
        }
        this.connectionManager.send(new ChatChannelMemberRemovePacket(channelId, new UUID[]{player2}), maybePacket -> {
            Packet packet = maybePacket.orElse(null);
            if (packet instanceof ServerChannelMemberActionResponsePacket) {
                for (Map.Entry<UUID, Boolean> entry : ((ServerChannelMemberActionResponsePacket)packet).getResults().entrySet()) {
                    UUID uuid = entry.getKey();
                    if (entry.getValue().booleanValue()) {
                        if (uuid.equals(UUIDUtil.getClientUUID())) {
                            this.removeChannel(channelId);
                            return;
                        }
                        channel.getMembers().remove(uuid);
                        continue;
                    }
                    UUIDUtil.getName(uuid).thenAccept(name -> Notifications.INSTANCE.push("Error removing player", "Failed to remove " + name + " from group."));
                }
                FriendsGui friendsGui = FriendsGui.getInstance();
                if (friendsGui != null) {
                    friendsGui.updateChannelInfo(channel);
                }
            } else {
                Notifications.INSTANCE.push("Error removing player", "An unexpected error has occurred. Try again.");
            }
        });
    }

    public void retrieveMessageHistory(long channelId, @Nullable Long before, @Nullable Long after, @Nullable Consumer<Optional<Packet>> callback) {
        this.retrieveMessageHistory(channelId, before, after, 50, callback);
    }

    public void retrieveMessageHistory(long channelId, Long before, Long after, int messageLimit, @Nullable Consumer<Optional<Packet>> callback) {
        if (!this.channels.containsKey(channelId)) {
            Essential.logger.error("Attempted to request message history for a channel that is not locally cached!");
            return;
        }
        this.connectionManager.send(new ClientChatChannelMessagesRetrievePacket(channelId, before, after, messageLimit), response2 -> {
            Packet packet = response2.orElse(null);
            if (packet instanceof ServerChatChannelMessagePacket) {
                boolean isEmpty;
                boolean bl = isEmpty = ((ServerChatChannelMessagePacket)packet).getMessages().length == 0;
                if (before == null && after == null && isEmpty) {
                    this.channelMessages.putIfAbsent(channelId, Maps.newConcurrentMap());
                }
            }
            if (callback != null) {
                callback.accept((Optional<Packet>)response2);
            }
        });
    }

    public void retrieveRecentMessageHistory(long channelId, @Nullable Consumer<Optional<Packet>> callback) {
        this.retrieveRecentMessageHistory(channelId, 50, callback);
    }

    public void retrieveRecentMessageHistory(long channelId, int messageLimit, @Nullable Consumer<Optional<Packet>> callback) {
        this.retrieveMessageHistory(channelId, null, null, messageLimit, callback);
    }

    public boolean isMuted(@NotNull Channel channel) {
        return channel.isMuted();
    }

    public void updateMutedState(@NotNull Channel channel, boolean muted) {
        this.mutedStateUpdateQueue.enqueue(new ClientChatChannelMutePacket(channel.getId(), muted), response2 -> {
            boolean success;
            Packet packet = response2.orElse(null);
            boolean bl = success = packet instanceof ResponseActionPacket && ((ResponseActionPacket)packet).isSuccessful();
            if (success) {
                channel.setMuted(muted);
            } else {
                Notifications.INSTANCE.push("Error updating channel", "Failed to save mute state.");
            }
            FriendsGui friendsGui = FriendsGui.getInstance();
            if (friendsGui != null) {
                friendsGui.updateChannelInfo(channel);
            }
        });
    }

    public void fileReport(long channelId, long messageId, String reason) {
        this.mutedStateUpdateQueue.enqueue(new ClientChatChannelMessageReportPacket(channelId, messageId, reason), response2 -> {
            Packet packet = response2.orElse(null);
            if (packet instanceof ServerChatChannelMessageReportPacket) {
                Notifications.INSTANCE.push("Report", "Your report has been submitted.");
            } else {
                Notifications.INSTANCE.push("Report", "An error occurred while submitting the report. Please contact support if issues persist.");
            }
        });
    }

    public boolean hasUnreadMessages() {
        return this.numUnread() > 0;
    }

    public int numUnread() {
        if (this.unreadMessages == -1) {
            this.unreadMessages = 0;
            for (ConcurrentMap<Long, Message> value2 : this.channelMessages.values()) {
                for (Message message : value2.values()) {
                    if (message.isRead()) continue;
                    ++this.unreadMessages;
                }
            }
        }
        return this.unreadMessages;
    }

    private void updateUnreads() {
        this.unreadMessages = -1;
    }

    public void updateReadState(Message message, boolean read) {
        if (message.isRead() == read) {
            return;
        }
        message.setRead(read);
        this.updateUnreads();
        this.connectionManager.send(new ClientChatChannelMessageReadStatePacket(message.getChannelId(), message.getId(), read));
        FriendsGui friendsGui = FriendsGui.getInstance();
        if (friendsGui != null) {
            friendsGui.updateReadStates();
        }
    }
}

