/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager;

import gg.essential.Essential;
import gg.essential.api.utils.Multithreading;
import gg.essential.config.EssentialConfig;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.connection.ClientConnectionDisconnectPacket;
import gg.essential.connectionmanager.common.packet.connection.ClientConnectionLoginPacket;
import gg.essential.connectionmanager.common.packet.connection.ConnectionKeepAlivePacket;
import gg.essential.connectionmanager.common.packet.connection.ConnectionRegisterPacketTypeIdPacket;
import gg.essential.connectionmanager.common.packet.connection.ServerConnectionReconnectPacket;
import gg.essential.connectionmanager.common.packet.multiplayer.ServerMultiplayerJoinServerPacket;
import gg.essential.connectionmanager.common.packet.response.ResponseActionPacket;
import gg.essential.connectionmanager.common.packet.telemetry.ClientTelemetryPacket;
import gg.essential.event.client.ReAuthEvent;
import gg.essential.event.essential.TosAcceptedEvent;
import gg.essential.gui.account.AccountSwitcher;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.client.MinecraftHook;
import gg.essential.network.connectionmanager.CloseReason;
import gg.essential.network.connectionmanager.Connection;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.chat.ChatManager;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ClientConnectionDisconnectPacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ConnectionRegisterPacketTypeIdPacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ServerConnectionKeepAlivePacketHandler;
import gg.essential.network.connectionmanager.handler.connection.ServerConnectionReconnectPacketHandler;
import gg.essential.network.connectionmanager.handler.multiplayer.ServerMultiplayerJoinServerPacketHandler;
import gg.essential.network.connectionmanager.ice.IceManager;
import gg.essential.network.connectionmanager.profile.ProfileManager;
import gg.essential.network.connectionmanager.relationship.RelationshipManager;
import gg.essential.network.connectionmanager.serverdiscovery.ServerDiscoveryManager;
import gg.essential.network.connectionmanager.social.SocialManager;
import gg.essential.network.connectionmanager.sps.SPSManager;
import gg.essential.network.connectionmanager.subscription.SubscriptionManager;
import gg.essential.util.LoginUtil;
import gg.essential.util.ModLoaderUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionManager {
    @NotNull
    private final Connection connection = new Connection(this);
    @NotNull
    private final MinecraftHook minecraftHook;
    @NotNull
    private final List<NetworkedManager> managers = new ArrayList<NetworkedManager>();
    @NotNull
    private final SubscriptionManager subscriptionManager;
    @NotNull
    private final RelationshipManager relationshipManager;
    @NotNull
    private final CosmeticsManager cosmeticsManager;
    @NotNull
    private final ChatManager chatManager;
    @NotNull
    private final ProfileManager profileManager;
    @NotNull
    private final SPSManager spsManager;
    @NotNull
    private final ServerDiscoveryManager serverDiscoveryManager;
    @NotNull
    private final SocialManager socialManager;
    @NotNull
    private final IceManager iceManager;
    private boolean triedReauth = false;
    private boolean authenticated = false;

    public ConnectionManager(@NotNull MinecraftHook minecraftHook) {
        this.minecraftHook = minecraftHook;
        this.subscriptionManager = new SubscriptionManager(this);
        this.managers.add(this.subscriptionManager);
        this.registerPacketHandler(ConnectionRegisterPacketTypeIdPacket.class, new ConnectionRegisterPacketTypeIdPacketHandler());
        this.registerPacketHandler(ConnectionKeepAlivePacket.class, new ServerConnectionKeepAlivePacketHandler());
        this.registerPacketHandler(ClientConnectionDisconnectPacket.class, new ClientConnectionDisconnectPacketHandler());
        this.registerPacketHandler(ServerConnectionReconnectPacket.class, new ServerConnectionReconnectPacketHandler());
        this.registerPacketHandler(ServerMultiplayerJoinServerPacket.class, new ServerMultiplayerJoinServerPacketHandler());
        this.cosmeticsManager = new CosmeticsManager(this);
        this.managers.add(this.cosmeticsManager);
        this.relationshipManager = new RelationshipManager(this);
        this.managers.add(this.relationshipManager);
        this.chatManager = new ChatManager(this);
        this.managers.add(this.chatManager);
        this.profileManager = new ProfileManager(this);
        this.managers.add(this.profileManager);
        this.spsManager = new SPSManager(this);
        this.managers.add(this.spsManager);
        this.serverDiscoveryManager = new ServerDiscoveryManager(this);
        this.managers.add(this.serverDiscoveryManager);
        this.socialManager = new SocialManager(this);
        this.managers.add(this.socialManager);
        this.iceManager = new IceManager(this, this.spsManager);
        this.managers.add(this.iceManager);
    }

    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    @NotNull
    public MinecraftHook getMinecraftHook() {
        return this.minecraftHook;
    }

    @NotNull
    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    @NotNull
    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    @NotNull
    public CosmeticsManager getCosmeticsManager() {
        return this.cosmeticsManager;
    }

    @NotNull
    public ChatManager getChatManager() {
        return this.chatManager;
    }

    @NotNull
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @NotNull
    public SPSManager getSpsManager() {
        return this.spsManager;
    }

    @NotNull
    public SocialManager getSocialManager() {
        return this.socialManager;
    }

    @NotNull
    public IceManager getIceManager() {
        return this.iceManager;
    }

    public boolean isOpen() {
        return this.connection.isOpen();
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public <T extends Packet> void registerPacketHandler(Class<T> cls, PacketHandler<T> handler) {
        this.connection.registerPacketHandler(cls, handler);
    }

    @Nullable
    public ClientConnectionLoginPacket prepareLoginAsync() {
        this.authenticated = false;
        byte[] sharedSecret = gg.essential.connectionmanager.common.util.LoginUtil.generateSharedSecret();
        String sessionHash = gg.essential.connectionmanager.common.util.LoginUtil.computeHash(sharedSecret);
        int statusCode = LoginUtil.joinServer(this.minecraftHook.getSession(), this.minecraftHook.getPlayerUUID().toString().replace("-", ""), sessionHash);
        if (statusCode != 204) {
            Essential.logger.warn("Could not authenticate with Mojang - connection attempt aborted.");
            if (!this.triedReauth) {
                this.triedReauth = true;
                Essential.logger.warn("Trying to refresh session token..");
                AccountSwitcher.refreshCurrentSession(false);
            }
            return null;
        }
        return new ClientConnectionLoginPacket(this.minecraftHook.getPlayerName(), sharedSecret);
    }

    public void onOpenAsync(@NotNull ClientConnectionLoginPacket loginPacket) {
        this.send(loginPacket, response2 -> {
            if (!response2.isPresent()) {
                Essential.logger.warn("Login request got no response - closing connection.");
                this.close(CloseReason.LOGIN_REQUEST_NO_RESPONSE);
                return;
            }
            Packet packet = (Packet)response2.get();
            if (!(packet instanceof ResponseActionPacket)) {
                Essential.logger.warn("Login response type ({}) was not expected - closing connection ({}).", packet.getClass(), (Object)packet);
                this.close(CloseReason.INVALID_LOGIN_RESPONSE);
                return;
            }
            ResponseActionPacket responseActionPacket = (ResponseActionPacket)packet;
            if (!responseActionPacket.isSuccessful()) {
                Essential.logger.warn("Login attempt was not successful - closing connection.");
                this.close(CloseReason.LOGIN_REQUEST_FAILED);
                return;
            }
            this.triedReauth = false;
            this.authenticated = true;
            for (NetworkedManager manager : this.managers) {
                manager.onConnected();
            }
            Multithreading.runAsync(() -> {
                this.respond(responseActionPacket, ModLoaderUtil.createModsAnnouncePacket());
                this.send(new ClientTelemetryPacket("SESSION_START"));
                this.send(new ClientTelemetryPacket("MINI_STATE", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("mini", !EssentialConfig.INSTANCE.getEssentialFull());
                    }
                }));
            });
        });
    }

    public void onClose() {
        this.authenticated = false;
        for (NetworkedManager manager : this.managers) {
            manager.onDisconnect();
        }
        int delay2 = 30;
        if (this.connection.getURI().toString().contains("localhost")) {
            delay2 = 3;
        }
        Multithreading.schedule(this.connection::attemptConnect, delay2, TimeUnit.SECONDS);
    }

    public void respond(@NotNull Packet respondingTo, @NotNull Packet respondingWith) {
        this.send(respondingWith, null, null, null, respondingTo.getPacketUniqueId());
    }

    public void send(@NotNull Packet packet) {
        this.send(packet, null);
    }

    public void send(@NotNull Packet packet, @Nullable Consumer<Optional<Packet>> responseCallback) {
        this.send(packet, responseCallback, TimeUnit.SECONDS, 10L);
    }

    public void send(@NotNull Packet packet, @Nullable Consumer<Optional<Packet>> responseCallback, @Nullable TimeUnit timeoutUnit, @Nullable Long timeoutValue) {
        this.send(packet, responseCallback, timeoutUnit, timeoutValue, null);
    }

    public void send(@NotNull Packet packet, @Nullable Consumer<Optional<Packet>> responseCallback, @Nullable TimeUnit timeoutUnit, @Nullable Long timeoutValue, @Nullable UUID packetId) {
        this.connection.send(packet, responseCallback, timeoutUnit, timeoutValue, packetId);
    }

    public void connect() {
        this.connection.attemptConnect();
    }

    public void close(@NotNull CloseReason closeReason) {
        this.close(closeReason, null);
    }

    public void close(@NotNull CloseReason closeReason, @Nullable String metadata2) {
        this.connection.close(closeReason, metadata2);
    }

    @Subscribe
    public void onTosAcceptedEvent(@NotNull TosAcceptedEvent event) {
        this.connection.attemptConnect();
    }

    @Subscribe
    public void onReAuthEvent(@NotNull ReAuthEvent event) {
        Multithreading.schedule(() -> {
            this.close(CloseReason.REAUTHENTICATION);
            this.connection.attemptConnect();
        }, 1L, TimeUnit.SECONDS);
    }

    public ServerDiscoveryManager getServerDiscoveryManager() {
        return this.serverDiscoveryManager;
    }

    public void onTosRevoked() {
        this.close(CloseReason.USER_TOS_REVOKED);
        for (NetworkedManager manager : this.managers) {
            manager.onTosRevoked();
        }
    }
}

