/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.sparkuniverse.toolbox.relationships.enums.FriendRequestPrivacySetting;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipState;
import com.sparkuniverse.toolbox.relationships.enums.RelationshipType;
import com.sparkuniverse.toolbox.relationships.serialisation.FriendRequestPrivacySettingTypeAdapter;
import com.sparkuniverse.toolbox.relationships.serialisation.RelationshipStateAdapter;
import com.sparkuniverse.toolbox.relationships.serialisation.RelationshipTypeAdapter;
import com.sparkuniverse.toolbox.serialization.DateTimeTypeAdapter;
import com.sparkuniverse.toolbox.serialization.UUIDTypeAdapter;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.api.utils.Multithreading;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.connection.ClientConnectionLoginPacket;
import gg.essential.connectionmanager.common.packet.connection.ConnectionRegisterPacketTypeIdPacket;
import gg.essential.data.OnboardingData;
import gg.essential.handlers.CertChain;
import gg.essential.lib.caffeine.cache.Cache;
import gg.essential.lib.caffeine.cache.Caffeine;
import gg.essential.lib.caffeine.cache.Expiry;
import gg.essential.lib.caffeine.cache.RemovalCause;
import gg.essential.lib.caffeine.cache.Scheduler;
import gg.essential.lib.websocket.client.WebSocketClient;
import gg.essential.lib.websocket.handshake.ServerHandshake;
import gg.essential.network.connectionmanager.CloseReason;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.handler.PacketHandler;
import gg.essential.network.connectionmanager.legacyjre.LegacyJre;
import gg.essential.network.connectionmanager.legacyjre.LegacyJreDnsResolver;
import gg.essential.network.connectionmanager.legacyjre.LegacyJreSocketFactory;
import gg.essential.universal.UMinecraft;
import gg.essential.util.ExtensionsKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Connection
extends WebSocketClient {
    private final String PACKET_PACKAGE = "gg.essential.connectionmanager.common.packet.";
    private final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @NotNull
    private final Executor mainThreadExecutor = ExtensionsKt.getExecutor(UMinecraft.getMinecraft());
    @NotNull
    private final Map<Class<? extends Packet>, PacketHandler<?>> packetHandlers = Maps.newHashMap();
    @NotNull
    private final @NotNull Cache<@NotNull UUID, @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>>> awaitingPacketResponses;
    @NotNull
    private final AtomicInteger packetTypeId = new AtomicInteger();
    @NotNull
    private final Map<Integer, String> incomingPacketTypeIds = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, Integer> outgoingPacketTypeIds = Maps.newConcurrentMap();
    private int failedConnects = 0;
    @NotNull
    private final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(RelationshipType.class, (Object)new RelationshipTypeAdapter()).registerTypeAdapter(RelationshipState.class, (Object)new RelationshipStateAdapter()).registerTypeAdapter(FriendRequestPrivacySetting.class, (Object)new FriendRequestPrivacySettingTypeAdapter()).registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeAdapter()).create();
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final Lock connectLock = new ReentrantLock();
    private long lastReceivedKeepAlive;
    private long connectedAt = System.currentTimeMillis();
    private boolean connectedBefore = false;
    @Nullable
    private String closureExtraData;
    @Nullable
    private ClientConnectionLoginPacket loginPacket;

    public Connection(@NotNull ConnectionManager connectionManager) {
        super(URI.create(System.getProperty("essential.cm.host", System.getenv().getOrDefault("ESSENTIAL_CM_HOST", "wss://connect.essential.gg/v1"))));
        this.awaitingPacketResponses = Caffeine.newBuilder().maximumSize(10000L).executor(Multithreading.getPool()).scheduler(Scheduler.forScheduledExecutorService(Multithreading.getScheduledPool())).expireAfter(new Expiry<UUID, Pair<Long, Consumer<Optional<Packet>>>>(){

            @Override
            public long expireAfterCreate(@NotNull UUID packetId, @NotNull @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>> valueData, long currentTime) {
                return (Long)valueData.getKey();
            }

            @Override
            public long expireAfterUpdate(@NotNull UUID packetId, @NotNull @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>> valueData, long currentTime, long currentDuration) {
                return currentDuration;
            }

            @Override
            public long expireAfterRead(@NotNull UUID packetId, @NotNull @NotNull Pair<@NotNull Long, @NotNull Consumer<@NotNull Optional<Packet>>> valueData, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).evictionListener((key, value2, cause) -> {
            if (value2 != null && (RemovalCause.EXPIRED == cause || RemovalCause.SIZE == cause)) {
                @NotNull Consumer packetHandler = (Consumer)value2.getRight();
                this.mainThreadExecutor.execute(() -> packetHandler.accept(Optional.empty()));
            }
        }).build();
        this.connectionManager = connectionManager;
        this.setTcpNoDelay(true);
        this.setReuseAddr(true);
        this.setConnectionLostTimeout(0);
        if (LegacyJre.IS_LEGACY_JRE_51) {
            Essential.logger.info("Using LegacyJreDnsResolver");
            this.setDnsResolver(new LegacyJreDnsResolver());
        } else {
            Essential.logger.info("Using Default JreDnsResolver");
        }
        Multithreading.getScheduledPool().scheduleAtFixedRate(() -> {
            if (!this.isOpen()) {
                return;
            }
            long diff = System.currentTimeMillis() - this.lastReceivedKeepAlive;
            if (diff < 60000L) {
                return;
            }
            this.close(CloseReason.SERVER_KEEP_ALIVE_TIMEOUT, diff + "ms");
        }, 0L, 30L, TimeUnit.SECONDS);
    }

    public void registerIncomingPacketTypeId(@NotNull String packetName, int packetTypeId) {
        this.incomingPacketTypeIds.put(packetTypeId, packetName);
    }

    public long getLastReceivedKeepAlive() {
        return this.lastReceivedKeepAlive;
    }

    public void setLastReceivedKeepAlive(long lastReceivedKeepAlive) {
        this.lastReceivedKeepAlive = lastReceivedKeepAlive;
    }

    public <T extends Packet> void registerPacketHandler(Class<T> cls, PacketHandler<T> handler) {
        this.packetHandlers.put(cls, handler);
    }

    public void close(@NotNull CloseReason closeReason) {
        this.close(closeReason, null);
    }

    public void close(@NotNull CloseReason closeReason, @Nullable String extraData) {
        this.closureExtraData = extraData;
        this.close(closeReason.getCode(), closeReason.name());
    }

    @Override
    public void onOpen(@NotNull ServerHandshake serverHandshake) {
        Essential.logger.info("Opened connection to Essential ConnectionManager (code={}, message={})", (Object)serverHandshake.getHttpStatus(), (Object)serverHandshake.getHttpStatusMessage());
        assert (this.loginPacket != null);
        this.closureExtraData = null;
        this.packetTypeId.set(0);
        this.incomingPacketTypeIds.clear();
        this.outgoingPacketTypeIds.clear();
        String packetName = this.splitPacketPackage(ConnectionRegisterPacketTypeIdPacket.class);
        this.incomingPacketTypeIds.put(0, packetName);
        this.outgoingPacketTypeIds.put(packetName, 0);
        this.connectedAt = System.currentTimeMillis();
        this.connectionManager.onOpenAsync(this.loginPacket);
    }

    @Override
    public void onClose(int code, @NotNull String reason, boolean remote) {
        Essential.logger.info("Closed connection to Essential Connection Manager (code={}, reason={}, remote={}), connection was open for {}ms", (Object)code, (Object)(reason + (String)(this.closureExtraData == null ? "" : " (" + this.closureExtraData + ")")), (Object)remote, (Object)(System.currentTimeMillis() - this.connectedAt));
        this.mainThreadExecutor.execute(this.connectionManager::onClose);
    }

    @Override
    public void onMessage(@NotNull String message) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onMessage(@NotNull ByteBuffer byteBuffer) {
        Packet packet;
        Consumer fResponseHandler;
        PacketHandler<?> packetHandler;
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
             DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
            Pair<Long, Consumer<Optional<Packet>>> responseCallbackPair;
            Class<?> packetClass;
            int packetTypeId = dataInputStream.readInt();
            String packetName = this.incomingPacketTypeIds.get(packetTypeId);
            if (packetName == null) {
                Essential.logger.warn("Unknown packet type id {} from connection manager.", (Object)packetTypeId);
                return;
            }
            try {
                packetClass = Class.forName("gg.essential.connectionmanager.common.packet." + packetName);
            }
            catch (ClassNotFoundException e) {
                dataInputStream.close();
                byteArrayInputStream.close();
                return;
            }
            String packetIdString = this.readString(dataInputStream);
            packetHandler = this.packetHandlers.get(packetClass);
            UUID packetId = null;
            Consumer responseHandler = null;
            if (!StringUtils.isEmpty((CharSequence)packetIdString) && (responseCallbackPair = this.awaitingPacketResponses.getIfPresent(packetId = UUID.fromString(packetIdString))) != null) {
                this.awaitingPacketResponses.invalidate(packetId);
                responseHandler = (Consumer)responseCallbackPair.getRight();
            }
            fResponseHandler = responseHandler;
            if (packetHandler == null && responseHandler == null) {
                return;
            }
            String jsonString = this.readString(dataInputStream);
            try {
                packet = (Packet)this.gson.fromJson(jsonString, packetClass);
            }
            catch (JsonParseException e) {
                Essential.logger.error("Error when deserialising json '{}' for '{}'.", (Object)jsonString, packetClass, (Object)e);
                dataInputStream.close();
                byteArrayInputStream.close();
                return;
            }
            if (packetId != null) {
                packet.setUniqueId(packetId);
            }
        }
        catch (IOException e) {
            Essential.logger.error("Error when reading byte buffer data '{}'.", (Object)byteBuffer.array(), (Object)e);
            return;
        }
        if (packet instanceof ConnectionRegisterPacketTypeIdPacket) {
            packetHandler.handle(this.connectionManager, packet);
            return;
        }
        this.mainThreadExecutor.execute(() -> {
            if (!this.isOpen()) {
                return;
            }
            Consumer responseHandler = fResponseHandler;
            if (responseHandler instanceof EarlyResponseHandler) {
                try {
                    responseHandler.accept(Optional.of(packet));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                responseHandler = null;
            }
            if (packetHandler != null) {
                try {
                    packetHandler.handle(this.connectionManager, packet);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (responseHandler != null) {
                try {
                    responseHandler.accept(Optional.of(packet));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
    }

    @Override
    public void onError(@NotNull Exception e) {
        Essential.logger.error("Critical error occurred on connection management. ", (Throwable)e);
    }

    public void send(@NotNull Packet packet, @Nullable Consumer<Optional<Packet>> responseCallback, @Nullable TimeUnit timeoutUnit, @Nullable Long timeoutValue, @Nullable UUID packetId) {
        if (!this.isOpen()) {
            if (responseCallback != null) {
                responseCallback.accept(Optional.empty());
            }
            return;
        }
        boolean wantsResponseHandling = responseCallback != null && timeoutUnit != null && timeoutValue != null;
        packetId = wantsResponseHandling && packetId == null ? UUID.randomUUID() : packetId;
        int packetTypeId = this.outgoingPacketTypeIds.computeIfAbsent(this.splitPacketPackage(packet.getClass()), packetName -> {
            int newId = this.packetTypeId.incrementAndGet();
            this.send(new ConnectionRegisterPacketTypeIdPacket((String)packetName, newId), null, null, null, null);
            return newId;
        });
        byte[] packetBytes = this.gson.toJson((Object)packet).getBytes(StandardCharsets.UTF_8);
        byte[] packetIdBytes = packetId != null ? packetId.toString().getBytes(StandardCharsets.UTF_8) : this.EMPTY_BYTE_ARRAY;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeInt(packetTypeId);
            dataOutputStream.writeInt(packetIdBytes.length);
            dataOutputStream.write(packetIdBytes);
            dataOutputStream.writeInt(packetBytes.length);
            dataOutputStream.write(packetBytes);
            this.send(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            Essential.logger.error("Error occurred when sending out packet '{}'.", (Object)packet, (Object)e);
        }
        if (wantsResponseHandling) {
            this.awaitingPacketResponses.put(packetId, (Pair<Long, Consumer<Optional<Packet>>>)Pair.of((Object)timeoutUnit.toNanos(timeoutValue), responseCallback));
        }
    }

    public void attemptConnect() {
        if (!this.connectLock.tryLock()) {
            return;
        }
        try {
            this.doAttemptConnect();
        }
        finally {
            this.connectLock.unlock();
        }
    }

    private void doAttemptConnect() {
        if (!OnboardingData.hasAcceptedTos()) {
            return;
        }
        if (this.isOpen()) {
            return;
        }
        this.lastReceivedKeepAlive = System.currentTimeMillis();
        this.loginPacket = this.connectionManager.prepareLoginAsync();
        if (this.loginPacket == null) {
            this.failedConnects = Math.max(this.failedConnects, 6);
            this.retryConnectWithBackoff();
            return;
        }
        try {
            if (this.connectedBefore) {
                super.reconnectBlocking();
            } else {
                SSLSocketFactory factory2 = new CertChain().load("isrgrootx1").load("lets-encrypt-r3").done().getSocketFactory();
                if (LegacyJre.IS_LEGACY_JRE_51 || LegacyJre.IS_LEGACY_JRE_74) {
                    Essential.logger.info("Using LegacyJreSocketFactory");
                    factory2 = new LegacyJreSocketFactory(factory2, this.uri.getHost());
                } else {
                    Essential.logger.info("Using Default JreSocketFactory");
                }
                if ("wss".equals(this.uri.getScheme())) {
                    this.setSocketFactory(factory2);
                }
                this.connectBlocking(5L, TimeUnit.SECONDS);
                this.connectedBefore = true;
                this.failedConnects = 0;
            }
        }
        catch (Exception e) {
            this.connectedBefore = false;
            Essential.logger.error("Error when connecting to Essential ConnectionManager.", (Throwable)e);
            e.printStackTrace();
        }
        if (!this.isOpen()) {
            Essential.logger.warn("Unable to connect to a Essential Connection Manager.");
            this.retryConnectWithBackoff();
            return;
        }
        Essential.logger.info("Essential Connection Manager connection established.");
    }

    private void retryConnectWithBackoff() {
        ++this.failedConnects;
        Multithreading.schedule(this::attemptConnect, Math.min(TimeUnit.SECONDS.toMillis((long)Math.pow(2.0, Math.min(this.failedConnects + 3, 7))) + ThreadLocalRandom.current().nextLong(0L, 1000L), TimeUnit.SECONDS.toMillis(129L)), TimeUnit.MILLISECONDS);
    }

    @NotNull
    private String readString(@NotNull DataInputStream dataInputStream) throws IOException {
        byte[] bytes = new byte[dataInputStream.readInt()];
        dataInputStream.read(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @NotNull
    private String splitPacketPackage(@NotNull Class<? extends Packet> packetClass) {
        return packetClass.getName().replace("gg.essential.connectionmanager.common.packet.", "");
    }

    public static interface EarlyResponseHandler
    extends Consumer<Optional<Packet>> {
    }
}

