/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b!\n\u0002\u0010\u0004\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000 h2\u00020\u0001:\u0001hB\t\b\u0016\u00a2\u0006\u0004\bd\u0010eB!\b\u0016\u0012\u0006\u0010\u001d\u001a\u00020S\u0012\u0006\u0010\u001e\u001a\u00020S\u0012\u0006\u0010\u001f\u001a\u00020S\u00a2\u0006\u0004\bd\u0010fB\u001f\u0012\u0006\u0010\u001d\u001a\u00020\u0005\u0012\u0006\u0010\u001e\u001a\u00020\u0005\u0012\u0006\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\u0004\bd\u0010gJ\u0015\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u001d\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0000H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0010J\u0010\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001c\u0010\u0004J.\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u001d\u001a\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u001c\u0010 J\u0015\u0010!\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b!\u0010\u0004J\u001d\u0010\"\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\"\u0010\u000eJ\u0015\u0010#\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b%\u0010$J\u0015\u0010&\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b&\u0010\u0004J\u0015\u0010'\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b'\u0010\bJ\u0015\u0010(\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b(\u0010$J\u001a\u0010,\u001a\u00020+2\b\u0010*\u001a\u0004\u0018\u00010)H\u00d6\u0003\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020\u0000\u00a2\u0006\u0004\b.\u0010\u0010J\u001f\u00103\u001a\u00020\u00002\u0006\u00100\u001a\u00020/2\b\b\u0002\u00102\u001a\u000201\u00a2\u0006\u0004\b3\u00104J\u0018\u00106\u001a\u00020\u00052\u0006\u00105\u001a\u000201H\u0086\u0002\u00a2\u0006\u0004\b6\u00107J\u0010\u00108\u001a\u000201H\u00d6\u0001\u00a2\u0006\u0004\b8\u00109J\r\u0010:\u001a\u00020\u0005\u00a2\u0006\u0004\b:\u0010\u0019J\r\u0010;\u001a\u00020\u0005\u00a2\u0006\u0004\b;\u0010\u0019J\u001d\u0010=\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0005\u00a2\u0006\u0004\b=\u0010\nJ%\u0010@\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0005\u00a2\u0006\u0004\b@\u0010AJ\u0015\u0010B\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\bB\u0010$J\r\u0010C\u001a\u00020\u0005\u00a2\u0006\u0004\bC\u0010\u0019J\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0004J\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0004J\u0015\u0010D\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\bD\u0010\u0004J\u0015\u0010E\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\bE\u0010\bJ\u001d\u0010F\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\bF\u0010\u000eJ\r\u0010G\u001a\u00020\u0000\u00a2\u0006\u0004\bG\u0010\u0010J\r\u0010H\u001a\u00020\u0000\u00a2\u0006\u0004\bH\u0010\u0010J\u0015\u0010J\u001a\u00020\u00002\u0006\u0010I\u001a\u00020\u0000\u00a2\u0006\u0004\bJ\u0010\u0004J\u0015\u0010K\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\bK\u0010\u0004J\u0015\u0010M\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\u0000\u00a2\u0006\u0004\bM\u0010\u0004J\r\u0010N\u001a\u00020\u0000\u00a2\u0006\u0004\bN\u0010\u0010J\r\u0010O\u001a\u00020\u0000\u00a2\u0006\u0004\bO\u0010\u0010J \u0010Q\u001a\u00020\u00002\u0006\u00105\u001a\u0002012\u0006\u0010P\u001a\u00020\u0005H\u0086\u0002\u00a2\u0006\u0004\bQ\u0010RJ%\u0010Q\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020S2\u0006\u0010\u001e\u001a\u00020S2\u0006\u0010\u001f\u001a\u00020S\u00a2\u0006\u0004\bQ\u0010TJ%\u0010W\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\u0004\bW\u0010 J%\u0010Y\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u0005\u00a2\u0006\u0004\bY\u0010 J\u0015\u0010Z\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u0005\u00a2\u0006\u0004\bZ\u0010\bJ\u0015\u0010[\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020S\u00a2\u0006\u0004\b[\u0010\\J\u0015\u0010]\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b]\u0010\u0004J\u0015\u0010^\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b^\u0010\bJ\u001d\u0010_\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b_\u0010\u000eJ\u0010\u0010a\u001a\u00020`H\u00d6\u0001\u00a2\u0006\u0004\ba\u0010bR\u0016\u0010\u001d\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010cR\u0016\u0010\u001e\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010cR\u0016\u0010\u001f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010c\u00a8\u0006i"}, d2={"Lgg/essential/model/Vector3;", "", "v", "add", "(Lgg/essential/model/Vector3;)Lgg/essential/model/Vector3;", "", "s", "addScalar", "(F)Lgg/essential/model/Vector3;", "addScaledVector", "(Lgg/essential/model/Vector3;F)Lgg/essential/model/Vector3;", "a", "b", "addVectors", "(Lgg/essential/model/Vector3;Lgg/essential/model/Vector3;)Lgg/essential/model/Vector3;", "ceil", "()Lgg/essential/model/Vector3;", "min", "max", "clamp", "clampLength", "(FF)Lgg/essential/model/Vector3;", "clampScalar", "clone", "component1", "()F", "component2", "component3", "copy", "x", "y", "z", "(FFF)Lgg/essential/model/Vector3;", "cross", "crossVectors", "distanceTo", "(Lgg/essential/model/Vector3;)F", "distanceToSquared", "divide", "divideScalar", "dot", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "floor", "", "array", "", "offset", "fromArray", "([FI)Lgg/essential/model/Vector3;", "index", "get", "(I)F", "hashCode", "()I", "length", "lengthSq", "alpha", "lerp", "v1", "v2", "lerpVectors", "(Lgg/essential/model/Vector3;Lgg/essential/model/Vector3;F)Lgg/essential/model/Vector3;", "manhattanDistanceTo", "manhattanLength", "multiply", "multiplyScalar", "multiplyVectors", "negate", "normalize", "planeNormal", "projectOnPlane", "projectOnVector", "normal", "reflect", "round", "roundToZero", "value", "set", "(IF)Lgg/essential/model/Vector3;", "", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)Lgg/essential/model/Vector3;", "radius", "theta", "setFromCylindricalCoords", "phi", "setFromSphericalCoords", "setLength", "setScalar", "(Ljava/lang/Number;)Lgg/essential/model/Vector3;", "sub", "subScalar", "subVectors", "", "toString", "()Ljava/lang/String;", "F", "<init>", "()V", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "(FFF)V", "Companion", "Essential 1.19-fabric"})
public final class Vector3
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public float x;
    @JvmField
    public float y;
    @JvmField
    public float z;
    @JvmField
    @NotNull
    public static final Vector3 X = new Vector3(1.0f, 0.0f, 0.0f);
    @JvmField
    @NotNull
    public static final Vector3 Y = new Vector3(0.0f, 1.0f, 0.0f);
    @JvmField
    @NotNull
    public static final Vector3 Z = new Vector3(0.0f, 0.0f, 1.0f);

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        this(x.floatValue(), y.floatValue(), z.floatValue());
    }

    @NotNull
    public final Vector3 set(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        this.x = x.floatValue();
        this.y = y.floatValue();
        this.z = z.floatValue();
        return this;
    }

    @NotNull
    public final Vector3 setScalar(@NotNull Number s) {
        Intrinsics.checkNotNullParameter(s, "s");
        return this.set(s, s, s);
    }

    @NotNull
    public final Vector3 set(int index2, float value2) {
        switch (index2) {
            case 0: {
                this.x = value2;
                break;
            }
            case 1: {
                this.y = value2;
                break;
            }
            case 2: {
                this.z = value2;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public final float get(int index2) {
        return switch (index2) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @NotNull
    public Vector3 clone() {
        return Vector3.copy$default(this, 0.0f, 0.0f, 0.0f, 7, null);
    }

    @NotNull
    public final Vector3 copy(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.set(Float.valueOf(v.x), Float.valueOf(v.y), Float.valueOf(v.z));
    }

    @NotNull
    public final Vector3 add(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    @NotNull
    public final Vector3 addScalar(float s) {
        this.x += s;
        this.y += s;
        this.z += s;
        return this;
    }

    @NotNull
    public final Vector3 addScaledVector(@NotNull Vector3 v, float s) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x += v.x * s;
        this.y += v.y * s;
        this.z += v.z * s;
        return this;
    }

    @NotNull
    public final Vector3 addVectors(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        this.z = a.z + b.z;
        return this;
    }

    @NotNull
    public final Vector3 sub(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    @NotNull
    public final Vector3 subScalar(float s) {
        this.x -= s;
        this.y -= s;
        this.z -= s;
        return this;
    }

    @NotNull
    public final Vector3 subVectors(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
        return this;
    }

    @NotNull
    public final Vector3 multiply(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    @NotNull
    public final Vector3 multiplyScalar(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        return this;
    }

    @NotNull
    public final Vector3 multiplyVectors(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        this.x = a.x * b.x;
        this.y = a.y * b.y;
        this.z = a.z * b.z;
        return this;
    }

    @NotNull
    public final Vector3 divide(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    @NotNull
    public final Vector3 divideScalar(float s) {
        return this.multiplyScalar(1.0f / s);
    }

    @NotNull
    public final Vector3 min(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x = Math.min(this.x, v.x);
        this.y = Math.min(this.y, v.y);
        this.z = Math.min(this.z, v.z);
        return this;
    }

    @NotNull
    public final Vector3 max(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x = Math.max(this.x, v.x);
        this.y = Math.max(this.y, v.y);
        this.z = Math.max(this.z, v.z);
        return this;
    }

    @NotNull
    public final Vector3 clamp(@NotNull Vector3 min, @NotNull Vector3 max) {
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        this.x = Math.max(min.x, Math.min(max.x, this.x));
        this.y = Math.max(min.y, Math.min(max.y, this.y));
        this.z = Math.max(min.z, Math.min(max.z, this.z));
        return this;
    }

    @NotNull
    public final Vector3 clampScalar(float min, float max) {
        float f = this.x;
        f = Math.min(max, f);
        this.x = Math.max(min, f);
        f = this.y;
        f = Math.min(max, f);
        this.y = Math.max(min, f);
        f = this.z;
        f = Math.min(max, f);
        this.z = Math.max(min, f);
        return this;
    }

    @NotNull
    public final Vector3 clampLength(float min, float max) {
        float length = this.length();
        if (Float.isNaN(length)) {
            length = 1.0f;
        }
        float f = Math.min(max, length);
        return this.divideScalar(length).multiplyScalar(Math.max(min, f));
    }

    @NotNull
    public final Vector3 floor() {
        this.x = (float)Math.floor(this.x);
        this.y = (float)Math.floor(this.y);
        this.z = (float)Math.floor(this.z);
        return this;
    }

    @NotNull
    public final Vector3 ceil() {
        this.x = (float)Math.ceil(this.x);
        this.y = (float)Math.ceil(this.y);
        this.z = (float)Math.ceil(this.z);
        return this;
    }

    @NotNull
    public final Vector3 round() {
        this.x = MathKt.roundToInt(this.x);
        this.y = MathKt.roundToInt(this.y);
        this.z = MathKt.roundToInt(this.z);
        return this;
    }

    @NotNull
    public final Vector3 roundToZero() {
        this.x = this.x < 0.0f ? (float)Math.ceil(this.x) : (float)Math.floor(this.x);
        this.y = this.y < 0.0f ? (float)Math.ceil(this.y) : (float)Math.floor(this.y);
        this.z = this.z < 0.0f ? (float)Math.ceil(this.z) : (float)Math.floor(this.z);
        return this;
    }

    @NotNull
    public final Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final float dot(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final float lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final float manhattanLength() {
        return Math.abs(this.x) + Math.abs(this.y) + Math.abs(this.z);
    }

    public final float manhattanDistanceTo(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return Math.abs(this.x - v.x) + Math.abs(this.y - v.y) + Math.abs(this.z - v.z);
    }

    @NotNull
    public final Vector3 setFromSphericalCoords(float radius, float phi, float theta) {
        float sinPhiRadius = (float)Math.sin(phi) * radius;
        this.x = sinPhiRadius * (float)Math.sin(theta);
        this.y = (float)Math.cos(phi) * radius;
        this.z = sinPhiRadius * (float)Math.cos(theta);
        return this;
    }

    @NotNull
    public final Vector3 setFromCylindricalCoords(float radius, float theta, float y) {
        this.x = radius * (float)Math.sin(theta);
        this.y = y;
        this.z = radius * (float)Math.cos(theta);
        return this;
    }

    @NotNull
    public final Vector3 normalize() {
        float length = this.length();
        if (Float.isNaN(length)) {
            length = 1.0f;
        }
        return this.divideScalar(length);
    }

    @NotNull
    public final Vector3 setLength(float length) {
        return this.normalize().multiplyScalar(length);
    }

    @NotNull
    public final Vector3 lerp(@NotNull Vector3 v, float alpha) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.x += (v.x - this.x) * alpha;
        this.y += (v.y - this.y) * alpha;
        this.z += (v.z - this.z) * alpha;
        return this;
    }

    @NotNull
    public final Vector3 lerpVectors(@NotNull Vector3 v1, @NotNull Vector3 v2, float alpha) {
        Intrinsics.checkNotNullParameter(v1, "v1");
        Intrinsics.checkNotNullParameter(v2, "v2");
        return this.subVectors(v2, v1).multiplyScalar(alpha).add(v1);
    }

    @NotNull
    public final Vector3 cross(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return this.crossVectors(this, v);
    }

    @NotNull
    public final Vector3 crossVectors(@NotNull Vector3 a, @NotNull Vector3 b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        float ax = a.x;
        float ay = a.y;
        float az = a.z;
        float bx = b.x;
        float by = b.y;
        float bz = b.z;
        this.x = ay * bz - az * by;
        this.y = az * bx - ax * bz;
        this.z = ax * by - ay * bx;
        return this;
    }

    @NotNull
    public final Vector3 projectOnVector(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        float scalar = v.dot(this) / v.lengthSq();
        return this.copy(v).multiplyScalar(scalar);
    }

    @NotNull
    public final Vector3 projectOnPlane(@NotNull Vector3 planeNormal) {
        Intrinsics.checkNotNullParameter(planeNormal, "planeNormal");
        Vector3 v1 = new Vector3();
        v1.copy(this).projectOnVector(planeNormal);
        return this.sub(v1);
    }

    @NotNull
    public final Vector3 reflect(@NotNull Vector3 normal) {
        Intrinsics.checkNotNullParameter(normal, "normal");
        Vector3 v1 = new Vector3();
        return this.sub(v1.copy(normal).multiplyScalar((float)2 * this.dot(normal)));
    }

    public final float distanceTo(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return (float)Math.sqrt(this.distanceToSquared(v));
    }

    public final float distanceToSquared(@NotNull Vector3 v) {
        Intrinsics.checkNotNullParameter(v, "v");
        float dx = this.x - v.x;
        float dy = this.y - v.y;
        float dz = this.z - v.z;
        return dx * dx + dy * dy + dz * dz;
    }

    @NotNull
    public final Vector3 fromArray(@NotNull float[] array, int offset) {
        Intrinsics.checkNotNullParameter(array, "array");
        this.x = array[offset];
        this.y = array[offset + 1];
        this.z = array[offset + 2];
        return this;
    }

    public static /* synthetic */ Vector3 fromArray$default(Vector3 vector3, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vector3.fromArray(fArray, n);
    }

    public final float component1() {
        return this.x;
    }

    public final float component2() {
        return this.y;
    }

    public final float component3() {
        return this.z;
    }

    @NotNull
    public final Vector3 copy(float x, float y, float z) {
        return new Vector3(x, y, z);
    }

    public static /* synthetic */ Vector3 copy$default(Vector3 vector3, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = vector3.x;
        }
        if ((n & 2) != 0) {
            f2 = vector3.y;
        }
        if ((n & 4) != 0) {
            f3 = vector3.z;
        }
        return vector3.copy(f, f2, f3);
    }

    @NotNull
    public String toString() {
        return "Vector3(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.x);
        result2 = result2 * 31 + Float.hashCode(this.y);
        result2 = result2 * 31 + Float.hashCode(this.z);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector3)) {
            return false;
        }
        Vector3 vector3 = (Vector3)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.x), (Object)Float.valueOf(vector3.x))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.y), (Object)Float.valueOf(vector3.y))) {
            return false;
        }
        return Intrinsics.areEqual((Object)Float.valueOf(this.z), (Object)Float.valueOf(vector3.z));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004\u00a8\u0006\t"}, d2={"Lgg/essential/model/Vector3$Companion;", "", "Lgg/essential/model/Vector3;", "X", "Lgg/essential/model/Vector3;", "Y", "Z", "<init>", "()V", "Essential 1.19-fabric"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

