/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.Essential;
import gg.essential.cosmetics.boxmask.CachingModelClipper;
import gg.essential.cosmetics.boxmask.ModelClipper;
import gg.essential.cosmetics.boxmask.ModelClipperImpl;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.model.Animation;
import gg.essential.model.BedrockModel;
import gg.essential.model.Bone;
import gg.essential.model.Box3;
import gg.essential.model.EnumPart;
import gg.essential.model.ModelAnimationState;
import gg.essential.model.ModelMolangQuery;
import gg.essential.model.PlayerMolangQuery;
import gg.essential.model.RenderMetadata;
import gg.essential.model.molang.MolangQueryEntity;
import gg.essential.universal.UMatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1657;
import net.minecraft.class_742;

public class ModelInstance {
    private static final HashMap<String, BedrockModel> models = new HashMap();
    private static final ModelMolangQuery defaultMolangQuery = new ModelMolangQuery();
    private final BedrockModel model;
    private final ModelAnimationState animationState;
    private final String modelName;
    private final ModelClipper modelClipper = new CachingModelClipper(new ModelClipperImpl());
    private final Queue<Float> animationOffsets = new ConcurrentLinkedQueue<Float>();
    private float mostRecentLifetime = 0.0f;
    private long mostRecentSync = 0L;
    private float currentLifetimeOffset = 0.0f;
    private float textureWidth = 1.0f;
    private float lastTextureAdjustment = 0.0f;

    public ModelInstance(Cosmetic cosmetic) {
        this(cosmetic, "default", defaultMolangQuery);
    }

    public ModelInstance(Cosmetic cosmetic, class_742 player2) {
        this(cosmetic, player2.method_3121(), new PlayerMolangQuery((class_1657)player2));
    }

    public ModelInstance(Cosmetic cosmetic, String skinType, MolangQueryEntity entity) {
        this.model = models.computeIfAbsent(cosmetic.getId() + "-" + skinType, s -> new BedrockModel(cosmetic, skinType));
        this.animationState = new ModelAnimationState(entity);
        this.modelName = cosmetic.getDisplayName("en_US");
    }

    public static void removeCache(String cosmeticId) {
        models.keySet().removeIf(it -> it.startsWith(cosmeticId));
    }

    public ModelAnimationState getAnimationState() {
        return this.animationState;
    }

    public void startAnimation(String name) {
        Animation animationByName = this.model.getAnimationByName(name);
        if (animationByName == null) {
            Essential.logger.error("Animation '" + name + "' not found for " + this.modelName);
            return;
        }
        this.startAnimation(animationByName);
    }

    public void startAnimation(Animation animation) {
        this.animationState.startAnimation(animation);
    }

    public List<Animation> getAnimations() {
        return this.model.getAnimations();
    }

    public void stopAnimation(String name) {
        if (this.animationState != null) {
            this.animationState.stopAnimation(this.model.getAnimationByName(name));
        }
    }

    public MolangQueryEntity getEntity() {
        return this.animationState != null ? this.animationState.getEntity() : defaultMolangQuery;
    }

    public class_742 getPlayer() {
        class_1657 player2;
        MolangQueryEntity entity = this.getEntity();
        if (entity instanceof PlayerMolangQuery && (player2 = ((PlayerMolangQuery)entity).getPlayer()) instanceof class_742) {
            return (class_742)player2;
        }
        return null;
    }

    public BedrockModel getModel() {
        return this.model;
    }

    public void render(UMatrixStack matrixStack, BedrockModel.UVertexConsumerProvider vertexConsumerProvider, RenderMetadata renderMetadata) {
        ArrayList<Box3> exclusionsFromOtherCosmetics = new ArrayList<Box3>(renderMetadata.getRenderExclusion());
        exclusionsFromOtherCosmetics.removeAll(this.model.boundingBoxes);
        Bone rootBone = this.modelClipper.compute(this.model.getRootBone(), exclusionsFromOtherCosmetics);
        this.mostRecentSync = System.currentTimeMillis();
        this.mostRecentLifetime = this.getEntity().getLifeTime();
        if (this.animationState != null) {
            this.animationState.apply(rootBone);
        } else {
            rootBone.resetAnimationOffsets(true);
        }
        for (Bone bone : this.model.getBones(rootBone)) {
            if (EnumPart.fromBoneName(bone.boxName) == null) continue;
            bone.userOffsetX = renderMetadata.getPositionAdjustment().x;
            bone.userOffsetY = renderMetadata.getPositionAdjustment().y;
            bone.userOffsetZ = renderMetadata.getPositionAdjustment().z;
        }
        this.textureWidth = rootBone.textureWidth;
        this.model.render(matrixStack, vertexConsumerProvider, rootBone, renderMetadata, this.getAdjustedLifetime(this.getEntity().getLifeTime()));
    }

    private float getAdjustedLifetime(float lifetime) {
        if (this.animationOffsets.isEmpty()) {
            return lifetime;
        }
        float totalValues = 0.0f;
        float totalEntries = 0.0f;
        for (Float animationOffset : this.animationOffsets) {
            totalValues += animationOffset.floatValue();
            totalEntries += 1.0f;
        }
        float targetOffsetTime = totalValues / totalEntries;
        float totalAnimationTime = (float)this.model.getTotalHeight() / this.textureWidth / 7.0f;
        float deltaTimeBackwards = targetOffsetTime - (this.currentLifetimeOffset + totalAnimationTime);
        float deltaTimeForwards = targetOffsetTime - this.currentLifetimeOffset;
        if ((double)(lifetime - this.lastTextureAdjustment) > 0.05) {
            float timeAdjustment = Math.abs(deltaTimeBackwards) < Math.abs(deltaTimeForwards) ? RangesKt.coerceIn(deltaTimeBackwards, -0.01f, 0.01f) : RangesKt.coerceIn(deltaTimeForwards, -0.01f, 0.01f);
            this.currentLifetimeOffset += timeAdjustment;
            this.lastTextureAdjustment = lifetime;
        }
        return lifetime + this.currentLifetimeOffset;
    }

    public List<Box3> getRenderExclusions() {
        return this.model.boundingBoxes;
    }

    public void syncTextureStart() {
        float totalFrames = (float)this.model.getTotalHeight() / this.textureWidth;
        float lifeTime = (float)(System.currentTimeMillis() - this.mostRecentSync) / 1000.0f + this.mostRecentLifetime;
        int frame = (int)(lifeTime * 7.0f);
        float completedFrames = (float)frame % totalFrames;
        float targetLifetimeOffset = (totalFrames - completedFrames) / 7.0f;
        if (this.animationOffsets.size() > 3) {
            this.animationOffsets.poll();
        }
        this.animationOffsets.add(Float.valueOf(targetLifetimeOffset));
    }
}

