/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.model.Animation;
import gg.essential.model.Bone;
import gg.essential.model.Channels;
import gg.essential.model.Keyframes;
import gg.essential.model.molang.MolangContext;
import gg.essential.model.molang.MolangQuery;
import gg.essential.model.molang.MolangQueryEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0010R!\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0013R\u00020\u00000\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lgg/essential/model/ModelAnimationState;", "", "Lgg/essential/model/Bone;", "model", "", "apply", "(Lgg/essential/model/Bone;)V", "bone", "", "", "map", "findAndResetBones", "(Lgg/essential/model/Bone;Ljava/util/Map;)V", "Lgg/essential/model/Animation;", "animation", "startAnimation", "(Lgg/essential/model/Animation;)V", "stopAnimation", "", "Lgg/essential/model/ModelAnimationState$AnimationState;", "active", "Ljava/util/List;", "getActive", "()Ljava/util/List;", "Lgg/essential/model/molang/MolangQueryEntity;", "entity", "Lgg/essential/model/molang/MolangQueryEntity;", "getEntity", "()Lgg/essential/model/molang/MolangQueryEntity;", "<init>", "(Lgg/essential/model/molang/MolangQueryEntity;)V", "AnimationState", "Essential 1.19-fabric"})
public final class ModelAnimationState {
    @NotNull
    private final MolangQueryEntity entity;
    @NotNull
    private final List<AnimationState> active;

    public ModelAnimationState(@NotNull MolangQueryEntity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.entity = entity;
        this.active = new ArrayList();
    }

    @NotNull
    public final MolangQueryEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public final List<AnimationState> getActive() {
        return this.active;
    }

    public final void startAnimation(@NotNull Animation animation) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(animation, "animation");
            Iterable $this$any$iv = this.active;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnimationState it = (AnimationState)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getAnimation(), animation)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.active.add(new AnimationState(animation));
    }

    public final void stopAnimation(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter(animation, "animation");
        this.active.removeIf(arg_0 -> ModelAnimationState.stopAnimation$lambda-1(animation, arg_0));
    }

    private final void findAndResetBones(Bone bone, Map<String, Bone> map2) {
        Map<String, Bone> map3 = map2;
        String string = bone.boxName;
        Intrinsics.checkNotNullExpressionValue(string, "bone.boxName");
        map3.put(string, bone);
        bone.resetAnimationOffsets(false);
        if (bone.childModels != null) {
            for (Bone childModel : bone.childModels) {
                Intrinsics.checkNotNullExpressionValue(childModel, "childModel");
                this.findAndResetBones(childModel, map2);
            }
        }
    }

    public final void apply(@NotNull Bone model) {
        Intrinsics.checkNotNullParameter(model, "model");
        Map bones = new LinkedHashMap();
        this.findAndResetBones(model, bones);
        for (AnimationState state : this.active) {
            for (Map.Entry<String, Channels> entry : state.getAnimation().getBones().entrySet()) {
                float z;
                float y;
                float x;
                Triple<Float, Float, Float> $dstr$x$y$z;
                String boneName = entry.getKey();
                Channels channels = entry.getValue();
                if ((Bone)bones.get(boneName) == null) continue;
                Keyframes keyframes = channels.getPosition();
                if (keyframes != null && keyframes.eval(state.getContext()) != null) {
                    boolean bl = false;
                    x = ((Number)$dstr$x$y$z.component1()).floatValue();
                    y = ((Number)$dstr$x$y$z.component2()).floatValue();
                    z = ((Number)$dstr$x$y$z.component3()).floatValue();
                    bone.animOffsetX += x;
                    bone.animOffsetY += y;
                    bone.animOffsetZ += z;
                }
                Keyframes keyframes2 = channels.getRotation();
                if (keyframes2 != null && keyframes2.eval(state.getContext()) != null) {
                    boolean bl = false;
                    x = ((Number)$dstr$x$y$z.component1()).floatValue();
                    y = ((Number)$dstr$x$y$z.component2()).floatValue();
                    z = ((Number)$dstr$x$y$z.component3()).floatValue();
                    bone.animRotX = (float)Math.toRadians(x);
                    bone.animRotY = (float)Math.toRadians(y);
                    bone.animRotZ = (float)Math.toRadians(z);
                }
                Keyframes keyframes3 = channels.getScale();
                if (keyframes3 == null || keyframes3.eval(state.getContext()) == null) continue;
                boolean bl = false;
                x = ((Number)$dstr$x$y$z.component1()).floatValue();
                y = ((Number)$dstr$x$y$z.component2()).floatValue();
                z = ((Number)$dstr$x$y$z.component3()).floatValue();
                bone.animScaleX *= x;
                bone.animScaleY *= y;
                bone.animScaleZ *= z;
            }
        }
    }

    private static final boolean stopAnimation$lambda-1(Animation $animation, AnimationState it) {
        Intrinsics.checkNotNullParameter($animation, "$animation");
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getAnimation(), $animation);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0007\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00038\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005R\u0014\u0010\u0018\u001a\u00020\u00038\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0005R\u0014\u0010\u001a\u001a\u00020\u00038\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0005\u00a8\u0006\u001d"}, d2={"Lgg/essential/model/ModelAnimationState$AnimationState;", "Lgg/essential/model/molang/MolangQuery;", "Lgg/essential/model/molang/MolangQueryEntity;", "", "getAnimLoopTime", "()F", "animLoopTime", "animStartTime", "F", "getAnimTime", "animTime", "Lgg/essential/model/Animation;", "animation", "Lgg/essential/model/Animation;", "getAnimation", "()Lgg/essential/model/Animation;", "Lgg/essential/model/molang/MolangContext;", "context", "Lgg/essential/model/molang/MolangContext;", "getContext", "()Lgg/essential/model/molang/MolangContext;", "getLifeTime", "lifeTime", "getModifiedDistanceMoved", "modifiedDistanceMoved", "getModifiedMoveSpeed", "modifiedMoveSpeed", "<init>", "(Lgg/essential/model/ModelAnimationState;Lgg/essential/model/Animation;)V", "Essential 1.19-fabric"})
    public final class AnimationState
    implements MolangQuery,
    MolangQueryEntity {
        @NotNull
        private final Animation animation;
        private final /* synthetic */ MolangQueryEntity $$delegate_0;
        @NotNull
        private final MolangContext context;
        private final float animStartTime;

        public AnimationState(Animation animation) {
            Intrinsics.checkNotNullParameter(ModelAnimationState.this, "this$0");
            Intrinsics.checkNotNullParameter(animation, "animation");
            this.animation = animation;
            this.$$delegate_0 = ModelAnimationState.this.getEntity();
            this.context = new MolangContext(this);
            this.animStartTime = ModelAnimationState.this.getEntity().getLifeTime();
        }

        @NotNull
        public final Animation getAnimation() {
            return this.animation;
        }

        @Override
        public float getLifeTime() {
            return this.$$delegate_0.getLifeTime();
        }

        @Override
        public float getModifiedDistanceMoved() {
            return this.$$delegate_0.getModifiedDistanceMoved();
        }

        @Override
        public float getModifiedMoveSpeed() {
            return this.$$delegate_0.getModifiedMoveSpeed();
        }

        @NotNull
        public final MolangContext getContext() {
            return this.context;
        }

        @Override
        public float getAnimTime() {
            return ModelAnimationState.this.getEntity().getLifeTime() - this.animStartTime;
        }

        @Override
        public float getAnimLoopTime() {
            return this.getAnimTime() % this.animation.getAnimationLength();
        }
    }
}

