/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.essential.model.AnimationKt;
import gg.essential.model.Keyframe;
import gg.essential.model.molang.MolangContext;
import gg.essential.model.molang.MolangExpression;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001b\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u0012\u001a\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010j\u0002`\u00112\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lgg/essential/model/Keyframes;", "", "Ljava/util/TreeMap;", "", "Lgg/essential/model/Keyframe;", "component1", "()Ljava/util/TreeMap;", "frames", "copy", "(Ljava/util/TreeMap;)Lgg/essential/model/Keyframes;", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lgg/essential/model/molang/MolangContext;", "context", "Lkotlin/Triple;", "Lgg/essential/model/FloatVector;", "eval", "(Lgg/essential/model/molang/MolangContext;)Lkotlin/Triple;", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/TreeMap;", "getFrames", "<init>", "(Ljava/util/TreeMap;)V", "Companion", "Essential 1.19-fabric"})
public final class Keyframes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TreeMap<Float, Keyframe> frames;

    public Keyframes(@NotNull TreeMap<Float, Keyframe> frames) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        this.frames = frames;
    }

    @NotNull
    public final TreeMap<Float, Keyframe> getFrames() {
        return this.frames;
    }

    @NotNull
    public final Triple<Float, Float, Float> eval(@NotNull MolangContext context) {
        Triple<Float, Float, Float> triple;
        Triple<Float, Float, Float> triple2;
        Triple<Float, Float, Float> triple3;
        Intrinsics.checkNotNullParameter(context, "context");
        float animTime = context.getQuery().getAnimLoopTime();
        Map.Entry<Float, Keyframe> floor = this.frames.floorEntry(Float.valueOf(animTime));
        Map.Entry<Float, Keyframe> ceil = this.frames.ceilingEntry(Float.valueOf(animTime));
        Map.Entry<Float, Keyframe> entry = floor;
        if (entry == null) {
            triple3 = null;
        } else {
            Keyframe keyframe = entry.getValue();
            if (keyframe == null) {
                triple3 = null;
            } else {
                Triple<MolangExpression, MolangExpression, MolangExpression> triple4 = keyframe.getPre();
                triple3 = triple4 == null ? null : AnimationKt.eval(triple4, context);
            }
        }
        Triple<Float, Float, Float> floorValue = triple3;
        Map.Entry<Float, Keyframe> entry2 = ceil;
        if (entry2 == null) {
            triple2 = null;
        } else {
            Keyframe keyframe = entry2.getValue();
            if (keyframe == null) {
                triple2 = null;
            } else {
                Triple<MolangExpression, MolangExpression, MolangExpression> triple5 = keyframe.getPre();
                triple2 = triple5 == null ? null : AnimationKt.eval(triple5, context);
            }
        }
        Triple<Float, Float, Float> ceilValue = triple2;
        if (floorValue == null) {
            Triple<Float, Float, Float> triple6 = ceilValue;
            triple = triple6;
            Intrinsics.checkNotNull(triple6);
        } else if (ceilValue == null) {
            triple = floorValue;
        } else if (Intrinsics.areEqual(floorValue, ceilValue)) {
            triple = floorValue;
        } else {
            Float f = floor.getKey();
            Intrinsics.checkNotNullExpressionValue(f, "floor.key");
            float f2 = animTime - ((Number)f).floatValue();
            float f3 = ((Number)ceil.getKey()).floatValue();
            f = floor.getKey();
            Intrinsics.checkNotNullExpressionValue(f, "floor.key");
            triple = AnimationKt.lerp(floorValue, ceilValue, f2 / (f3 - ((Number)f).floatValue()));
        }
        return triple;
    }

    @NotNull
    public final TreeMap<Float, Keyframe> component1() {
        return this.frames;
    }

    @NotNull
    public final Keyframes copy(@NotNull TreeMap<Float, Keyframe> frames) {
        Intrinsics.checkNotNullParameter(frames, "frames");
        return new Keyframes(frames);
    }

    public static /* synthetic */ Keyframes copy$default(Keyframes keyframes, TreeMap treeMap, int n, Object object) {
        if ((n & 1) != 0) {
            treeMap = keyframes.frames;
        }
        return keyframes.copy(treeMap);
    }

    @NotNull
    public String toString() {
        return "Keyframes(frames=" + this.frames + ")";
    }

    public int hashCode() {
        return this.frames.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Keyframes)) {
            return false;
        }
        Keyframes keyframes = (Keyframes)other;
        return Intrinsics.areEqual(this.frames, keyframes.frames);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lgg/essential/model/Keyframes$Companion;", "", "Lcom/google/gson/JsonElement;", "json", "Lgg/essential/model/Keyframes;", "parse", "(Lcom/google/gson/JsonElement;)Lgg/essential/model/Keyframes;", "<init>", "()V", "Essential 1.19-fabric"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Keyframes parse(@NotNull JsonElement json2) {
            Keyframes keyframes;
            Intrinsics.checkNotNullParameter(json2, "json");
            JsonElement $this$parse_u24lambda_u2d1 = json2;
            boolean bl = false;
            if ($this$parse_u24lambda_u2d1 instanceof JsonObject) {
                void $this$associateTo$iv$iv;
                Set set = ((JsonObject)$this$parse_u24lambda_u2d1).entrySet();
                Intrinsics.checkNotNullExpressionValue(set, "entrySet()");
                Iterable $this$associate$iv = set;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    Map.Entry $dstr$key$json = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue($dstr$key$json, "(key, json)");
                    String key = (String)$dstr$key$json.getKey();
                    JsonElement json3 = (JsonElement)$dstr$key$json.getValue();
                    Intrinsics.checkNotNullExpressionValue(key, "key");
                    Float f = Float.valueOf(Float.parseFloat(key));
                    Intrinsics.checkNotNullExpressionValue(json3, "json");
                    Pair<Float, Keyframe> pair = TuplesKt.to(f, Keyframe.Companion.parse(json3));
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                Map map3 = destination$iv$iv;
                TreeMap<Float, Keyframe> treeMap = new TreeMap<Float, Keyframe>(map3);
                keyframes = new Keyframes(treeMap);
            } else {
                keyframes = new Keyframes(new TreeMap<Float, Keyframe>(MapsKt.mapOf(TuplesKt.to(Float.valueOf(0.0f), Keyframe.Companion.parse($this$parse_u24lambda_u2d1)))));
            }
            return keyframes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

