/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import com.google.gson.JsonElement;
import gg.essential.api.utils.JsonHolder;
import gg.essential.model.Bone;
import gg.essential.model.Face;
import gg.essential.model.PositionTexVertex;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.vertex.UVertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Cube {
    public float posX1;
    public float posY1;
    public float posZ1;
    public float posX2;
    public float posY2;
    public float posZ2;
    private final List<Face> quadList;
    public String boxName;

    public Cube(Bone renderer, int texU, int texV, float x, float y, float z, float dx, float dy, float dz, float delta, boolean mirror) {
        this(renderer, x, y, z, dx, dy, dz, delta, mirror, texU, texV, null);
    }

    public Cube(Bone renderer, float x, float y, float z, float dx, float dy, float dz, float delta, boolean mirror, JsonHolder uvData) {
        this(renderer, x, y, z, dx, dy, dz, delta, mirror, 0, 0, uvData);
    }

    public Cube(List<Face> precomputedFaces) {
        this.quadList = new ArrayList<Face>();
        this.quadList.addAll(precomputedFaces);
    }

    private Cube(Bone renderer, float x, float y, float z, float dx, float dy, float dz, float delta, boolean mirror, int texU, int texV, @Nullable JsonHolder uvData) {
        this.posX1 = x;
        this.posY1 = y;
        this.posZ1 = z;
        this.posX2 = x + dx;
        this.posY2 = y + dy;
        this.posZ2 = z + dz;
        this.quadList = new ArrayList<Face>();
        float x2 = x + dx;
        float y2 = y + dy;
        float z2 = z + dz;
        x -= delta;
        y -= delta;
        z -= delta;
        x2 += delta;
        y2 += delta;
        z2 += delta;
        if (mirror) {
            float f3 = x2;
            x2 = x;
            x = f3;
        }
        PositionTexVertex PositionTexVertex7 = new PositionTexVertex(x, y, z, 0.0f, 0.0f);
        PositionTexVertex PositionTexVertex2 = new PositionTexVertex(x2, y, z, 0.0f, 8.0f);
        PositionTexVertex PositionTexVertex1 = new PositionTexVertex(x2, y2, z, 8.0f, 8.0f);
        PositionTexVertex PositionTexVertex22 = new PositionTexVertex(x, y2, z, 8.0f, 0.0f);
        PositionTexVertex PositionTexVertex3 = new PositionTexVertex(x, y, z2, 0.0f, 0.0f);
        PositionTexVertex PositionTexVertex4 = new PositionTexVertex(x2, y, z2, 0.0f, 8.0f);
        PositionTexVertex PositionTexVertex5 = new PositionTexVertex(x2, y2, z2, 8.0f, 8.0f);
        PositionTexVertex PositionTexVertex6 = new PositionTexVertex(x, y2, z2, 8.0f, 0.0f);
        float[] DEFAULT_UV_NORTH = new float[]{(float)texU + dz, (float)texV + dz, (float)texU + dz + dx, (float)texV + dz + dy};
        float[] DEFAULT_UV_EAST = new float[]{texU, (float)texV + dz, (float)texU + dz, (float)texV + dz + dy};
        float[] DEFAULT_UV_SOUTH = new float[]{(float)texU + dz + dx + dz, (float)texV + dz, (float)texU + dz + dx + dz + dx, (float)texV + dz + dy};
        float[] DEFAULT_UV_WEST = new float[]{(float)texU + dz + dx, (float)texV + dz, (float)texU + dz + dx + dz, (float)texV + dz + dy};
        float[] DEFAULT_UV_UP = new float[]{(float)texU + dz, texV, (float)texU + dz + dx, (float)texV + dz};
        float[] DEFAULT_UV_DOWN = new float[]{(float)texU + dz + dx, (float)texV + dz, (float)texU + dz + dx + dx, texV};
        float[] north = uvData == null ? DEFAULT_UV_NORTH : this.readData(uvData.optJSONObject("north"));
        float[] east = uvData == null ? DEFAULT_UV_EAST : this.readData(uvData.optJSONObject("east"));
        float[] south = uvData == null ? DEFAULT_UV_SOUTH : this.readData(uvData.optJSONObject("south"));
        float[] west = uvData == null ? DEFAULT_UV_WEST : this.readData(uvData.optJSONObject("west"));
        float[] up = uvData == null ? DEFAULT_UV_UP : this.readData(uvData.optJSONObject("up"));
        float[] down = uvData == null ? DEFAULT_UV_DOWN : this.readData(uvData.optJSONObject("down"));
        this.quadList.add(new Face(new PositionTexVertex[]{PositionTexVertex4, PositionTexVertex2, PositionTexVertex1, PositionTexVertex5}, west[0], west[1], west[2], west[3], renderer.textureWidth, renderer.textureHeight));
        this.quadList.add(new Face(new PositionTexVertex[]{PositionTexVertex7, PositionTexVertex3, PositionTexVertex6, PositionTexVertex22}, east[0], east[1], east[2], east[3], renderer.textureWidth, renderer.textureHeight));
        this.quadList.add(new Face(new PositionTexVertex[]{PositionTexVertex4, PositionTexVertex3, PositionTexVertex7, PositionTexVertex2}, up[0], up[1], up[2], up[3], renderer.textureWidth, renderer.textureHeight));
        this.quadList.add(new Face(new PositionTexVertex[]{PositionTexVertex1, PositionTexVertex22, PositionTexVertex6, PositionTexVertex5}, down[0], down[1], down[2], down[3], renderer.textureWidth, renderer.textureHeight));
        this.quadList.add(new Face(new PositionTexVertex[]{PositionTexVertex2, PositionTexVertex7, PositionTexVertex22, PositionTexVertex1}, north[0], north[1], north[2], north[3], renderer.textureWidth, renderer.textureHeight));
        this.quadList.add(new Face(new PositionTexVertex[]{PositionTexVertex3, PositionTexVertex4, PositionTexVertex5, PositionTexVertex6}, south[0], south[1], south[2], south[3], renderer.textureWidth, renderer.textureHeight));
        for (int i = 0; i < 6; ++i) {
            ArrayList<PositionTexVertex> verts = new ArrayList<PositionTexVertex>(Arrays.asList(this.quadList.get((int)i).vertexPositions));
            Collections.reverse(verts);
            Collections.rotate(verts, 2);
            this.quadList.add(new Face(verts.toArray(new PositionTexVertex[0])));
        }
        if (mirror) {
            for (Face texturedquad : this.quadList) {
                texturedquad.flipFace();
            }
        }
    }

    private float[] readData(JsonHolder jsonHolder) {
        float[] data2 = new float[4];
        int i = 0;
        for (JsonElement uv : jsonHolder.optJSONArray("uv")) {
            data2[i] = uv.getAsInt();
            ++i;
        }
        for (JsonElement uv : jsonHolder.optJSONArray("uv_size")) {
            data2[i] = data2[i - 2] + (float)uv.getAsInt();
            ++i;
        }
        return data2;
    }

    public void render(UMatrixStack matrixStack, UVertexConsumer renderer, int light, float scale, float verticalUVOffset) {
        for (Face texturedquad : this.quadList) {
            texturedquad.draw(matrixStack, renderer, light, scale, verticalUVOffset);
        }
    }

    public Cube setBoxName(String name) {
        this.boxName = name;
        return this;
    }

    public List<Face> getQuadList() {
        return this.quadList;
    }
}

