/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.model.Box3;
import gg.essential.model.Vector3;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\b\u0018\u0000 Q2\u00020\u0001:\u0002QRB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\bO\u0010PJ!\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J$\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0014\u001a\u00020\u00022\b\b\u0002\u0010\u0015\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001c\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0017\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0002\u00a2\u0006\u0004\b$\u0010\u001fJ\u0019\u0010%\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b%\u0010&J!\u0010'\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b'\u0010\u0006J\u0019\u0010(\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b(\u0010&J\u0010\u0010*\u001a\u00020)H\u00d6\u0001\u00a2\u0006\u0004\b*\u0010+J\u0015\u0010,\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b,\u0010\u0013J\u0015\u0010-\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b-\u0010\u000fJ\r\u0010.\u001a\u00020\r\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020\u0000\u00a2\u0006\u0004\b0\u0010\bJ\u001d\u00101\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b1\u0010\u0016J\u0015\u00104\u001a\u00020\u00002\u0006\u00103\u001a\u000202\u00a2\u0006\u0004\b4\u00105J\u001d\u00108\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u0002\u00a2\u0006\u0004\b8\u0010\u0016J\u001b\u0010;\u001a\u00020\u00002\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000209\u00a2\u0006\u0004\b;\u0010<J\u0010\u0010>\u001a\u00020=H\u00d6\u0001\u00a2\u0006\u0004\b>\u0010?J\u0015\u0010A\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0002\u00a2\u0006\u0004\bA\u0010\u001fJ\u0015\u0010B\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\bB\u0010\u0013R\u001f\u0010H\u001a\u00060CR\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR\"\u0010\u0015\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010I\u001a\u0004\bJ\u0010\n\"\u0004\bK\u0010LR\"\u0010\u0014\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010I\u001a\u0004\bM\u0010\n\"\u0004\bN\u0010L\u00a8\u0006S"}, d2={"Lgg/essential/model/Box3;", "", "Lgg/essential/model/Vector3;", "point", "target", "clampPoint", "(Lgg/essential/model/Vector3;Lgg/essential/model/Vector3;)Lgg/essential/model/Vector3;", "clone", "()Lgg/essential/model/Box3;", "component1", "()Lgg/essential/model/Vector3;", "component2", "box", "", "containsBox", "(Lgg/essential/model/Box3;)Z", "containsPoint", "(Lgg/essential/model/Vector3;)Z", "copy", "(Lgg/essential/model/Box3;)Lgg/essential/model/Box3;", "min", "max", "(Lgg/essential/model/Vector3;Lgg/essential/model/Vector3;)Lgg/essential/model/Box3;", "", "distanceToPoint", "(Lgg/essential/model/Vector3;)F", "", "other", "equals", "(Ljava/lang/Object;)Z", "expandByPoint", "(Lgg/essential/model/Vector3;)Lgg/essential/model/Box3;", "scalar", "expandByScalar", "(F)Lgg/essential/model/Box3;", "vector", "expandByVector", "getCenter", "(Lgg/essential/model/Vector3;)Lgg/essential/model/Vector3;", "getParameter", "getSize", "", "hashCode", "()I", "intersect", "intersectsBox", "isEmpty", "()Z", "makeEmpty", "set", "", "array", "setFromArray", "([F)Lgg/essential/model/Box3;", "center", "size", "setFromCenterAndSize", "", "points", "setFromPoints", "(Ljava/util/List;)Lgg/essential/model/Box3;", "", "toString", "()Ljava/lang/String;", "offset", "translate", "union", "Lgg/essential/model/Box3$IntersectsTriangleHelper;", "intersectsTriangleHelper$delegate", "Lkotlin/Lazy;", "getIntersectsTriangleHelper", "()Lgg/essential/model/Box3$IntersectsTriangleHelper;", "intersectsTriangleHelper", "Lgg/essential/model/Vector3;", "getMax", "setMax", "(Lgg/essential/model/Vector3;)V", "getMin", "setMin", "<init>", "(Lgg/essential/model/Vector3;Lgg/essential/model/Vector3;)V", "Companion", "IntersectsTriangleHelper", "Essential 1.19-fabric"})
public final class Box3
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vector3 min;
    @NotNull
    private Vector3 max;
    @NotNull
    private final Lazy intersectsTriangleHelper$delegate;
    @NotNull
    private static final Lazy<List<Vector3>> points$delegate = LazyKt.lazy(Companion.points.2.INSTANCE);

    @JvmOverloads
    public Box3(@NotNull Vector3 min, @NotNull Vector3 max) {
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        this.min = min;
        this.max = max;
        this.intersectsTriangleHelper$delegate = LazyKt.lazy((Function0)new Function0<IntersectsTriangleHelper>(this){
            final /* synthetic */ Box3 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IntersectsTriangleHelper invoke() {
                return this.this$0.new IntersectsTriangleHelper();
            }
        });
    }

    public /* synthetic */ Box3(Vector3 vector3, Vector3 vector32, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            vector3 = new Vector3(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        }
        if ((n & 2) != 0) {
            vector32 = new Vector3(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        }
        this(vector3, vector32);
    }

    @NotNull
    public final Vector3 getMin() {
        return this.min;
    }

    public final void setMin(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.min = vector3;
    }

    @NotNull
    public final Vector3 getMax() {
        return this.max;
    }

    public final void setMax(@NotNull Vector3 vector3) {
        Intrinsics.checkNotNullParameter(vector3, "<set-?>");
        this.max = vector3;
    }

    private final IntersectsTriangleHelper getIntersectsTriangleHelper() {
        Lazy lazy2 = this.intersectsTriangleHelper$delegate;
        return (IntersectsTriangleHelper)lazy2.getValue();
    }

    @NotNull
    public final Box3 set(@NotNull Vector3 min, @NotNull Vector3 max) {
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        this.min.copy(min);
        this.max.copy(max);
        return this;
    }

    @NotNull
    public final Box3 setFromArray(@NotNull float[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        IntProgression intProgression = RangesKt.step(RangesKt.until(0, array.length), 3);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            int i;
            do {
                i = n;
                n += n3;
                float x = array[i];
                float y = array[i + 1];
                float z = array[i + 2];
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (z < minZ) {
                    minZ = z;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (!(z > maxZ)) continue;
                maxZ = z;
            } while (i != n2);
        }
        this.min.set(Float.valueOf(minX), Float.valueOf(minY), Float.valueOf(minZ));
        this.max.set(Float.valueOf(maxX), Float.valueOf(maxY), Float.valueOf(maxZ));
        return this;
    }

    @NotNull
    public final Box3 setFromPoints(@NotNull List<Vector3> points2) {
        Intrinsics.checkNotNullParameter(points2, "points");
        this.makeEmpty();
        Iterable $this$forEach$iv = points2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vector3 it = (Vector3)element$iv;
            boolean bl = false;
            this.expandByPoint(it);
        }
        return this;
    }

    @NotNull
    public final Box3 setFromCenterAndSize(@NotNull Vector3 center, @NotNull Vector3 size) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(size, "size");
        Vector3 halfSize = new Vector3().copy(size).multiplyScalar(0.5f);
        this.min.copy(center).sub(halfSize);
        this.max.copy(center).add(halfSize);
        return this;
    }

    @NotNull
    public final Box3 makeEmpty() {
        this.min.x = Float.POSITIVE_INFINITY;
        this.min.y = Float.POSITIVE_INFINITY;
        this.min.z = Float.POSITIVE_INFINITY;
        this.max.x = Float.NEGATIVE_INFINITY;
        this.max.y = Float.NEGATIVE_INFINITY;
        this.max.z = Float.NEGATIVE_INFINITY;
        return this;
    }

    public final boolean isEmpty() {
        return this.max.x < this.min.x || this.max.y < this.min.y || this.max.z < this.min.z;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 getCenter(@NotNull Vector3 target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this.isEmpty() ? target.set(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)) : target.addVectors(this.min, this.max).multiplyScalar(0.5f);
    }

    public static /* synthetic */ Vector3 getCenter$default(Box3 box3, Vector3 vector3, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = new Vector3();
        }
        return box3.getCenter(vector3);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 getSize(@NotNull Vector3 target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this.isEmpty() ? target.set(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)) : target.subVectors(this.max, this.min);
    }

    public static /* synthetic */ Vector3 getSize$default(Box3 box3, Vector3 vector3, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = new Vector3();
        }
        return box3.getSize(vector3);
    }

    @NotNull
    public final Box3 expandByPoint(@NotNull Vector3 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        this.min.min(point);
        this.max.max(point);
        return this;
    }

    @NotNull
    public final Box3 expandByVector(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        this.min.sub(vector);
        this.max.add(vector);
        return this;
    }

    @NotNull
    public final Box3 expandByScalar(float scalar) {
        this.min.addScalar(-scalar);
        this.max.addScalar(scalar);
        return this;
    }

    public final boolean containsPoint(@NotNull Vector3 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return !(point.x < this.min.x || point.x > this.max.x || point.y < this.min.y || point.y > this.max.y || point.z < this.min.z || point.z > this.max.z);
    }

    public final boolean containsBox(@NotNull Box3 box) {
        Intrinsics.checkNotNullParameter(box, "box");
        return this.min.x <= box.min.x && box.max.x <= this.max.x && this.min.y <= box.min.y && box.max.y <= this.max.y && this.min.z <= box.min.z && box.max.z <= this.max.z;
    }

    @JvmOverloads
    @NotNull
    public final Vector3 getParameter(@NotNull Vector3 point, @NotNull Vector3 target) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(target, "target");
        return target.set(Float.valueOf((point.x - this.min.x) / (this.max.x - this.min.x)), Float.valueOf((point.y - this.min.y) / (this.max.y - this.min.y)), Float.valueOf((point.z - this.min.z) / (this.max.z - this.min.z)));
    }

    public static /* synthetic */ Vector3 getParameter$default(Box3 box3, Vector3 vector3, Vector3 vector32, int n, Object object) {
        if ((n & 2) != 0) {
            vector32 = new Vector3();
        }
        return box3.getParameter(vector3, vector32);
    }

    public final boolean intersectsBox(@NotNull Box3 box) {
        Intrinsics.checkNotNullParameter(box, "box");
        return !(box.max.x < this.min.x || box.min.x > this.max.x || box.max.y < this.min.y || box.min.y > this.max.y || box.max.z < this.min.z || box.min.z > this.max.z);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 clampPoint(@NotNull Vector3 point, @NotNull Vector3 target) {
        Intrinsics.checkNotNullParameter(point, "point");
        Intrinsics.checkNotNullParameter(target, "target");
        return target.copy(point).clamp(this.min, this.max);
    }

    public static /* synthetic */ Vector3 clampPoint$default(Box3 box3, Vector3 vector3, Vector3 vector32, int n, Object object) {
        if ((n & 2) != 0) {
            vector32 = new Vector3();
        }
        return box3.clampPoint(vector3, vector32);
    }

    public final float distanceToPoint(@NotNull Vector3 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        Vector3 clampedPoint = new Vector3().copy(point).clamp(this.min, this.max);
        return clampedPoint.sub(point).length();
    }

    @NotNull
    public final Box3 intersect(@NotNull Box3 box) {
        Intrinsics.checkNotNullParameter(box, "box");
        this.min.max(box.min);
        this.max.min(box.max);
        if (this.isEmpty()) {
            this.makeEmpty();
        }
        return this;
    }

    @NotNull
    public final Box3 union(@NotNull Box3 box) {
        Intrinsics.checkNotNullParameter(box, "box");
        this.min.min(box.min);
        this.max.max(box.max);
        return this;
    }

    @NotNull
    public final Box3 translate(@NotNull Vector3 offset) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        this.min.add(offset);
        this.max.add(offset);
        return this;
    }

    @NotNull
    public Box3 clone() {
        return new Box3(null, null, 3, null).copy(this);
    }

    @NotNull
    public final Box3 copy(@NotNull Box3 box) {
        Intrinsics.checkNotNullParameter(box, "box");
        this.min.copy(box.min);
        this.max.copy(box.max);
        return this;
    }

    @NotNull
    public final Vector3 component1() {
        return this.min;
    }

    @NotNull
    public final Vector3 component2() {
        return this.max;
    }

    @NotNull
    public final Box3 copy(@NotNull Vector3 min, @NotNull Vector3 max) {
        Intrinsics.checkNotNullParameter(min, "min");
        Intrinsics.checkNotNullParameter(max, "max");
        return new Box3(min, max);
    }

    public static /* synthetic */ Box3 copy$default(Box3 box3, Vector3 vector3, Vector3 vector32, int n, Object object) {
        if ((n & 1) != 0) {
            vector3 = box3.min;
        }
        if ((n & 2) != 0) {
            vector32 = box3.max;
        }
        return box3.copy(vector3, vector32);
    }

    @NotNull
    public String toString() {
        return "Box3(min=" + this.min + ", max=" + this.max + ")";
    }

    public int hashCode() {
        int result2 = this.min.hashCode();
        result2 = result2 * 31 + this.max.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Box3)) {
            return false;
        }
        Box3 box3 = (Box3)other;
        if (!Intrinsics.areEqual(this.min, box3.min)) {
            return false;
        }
        return Intrinsics.areEqual(this.max, box3.max);
    }

    @JvmOverloads
    public Box3(@NotNull Vector3 min) {
        Intrinsics.checkNotNullParameter(min, "min");
        this(min, null, 2, null);
    }

    @JvmOverloads
    public Box3() {
        this(null, null, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 getCenter() {
        return Box3.getCenter$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 getSize() {
        return Box3.getSize$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 getParameter(@NotNull Vector3 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return Box3.getParameter$default(this, point, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Vector3 clampPoint(@NotNull Vector3 point) {
        Intrinsics.checkNotNullParameter(point, "point");
        return Box3.clampPoint$default(this, point, null, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nR!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lgg/essential/model/Box3$Companion;", "", "", "Lgg/essential/model/Vector3;", "points$delegate", "Lkotlin/Lazy;", "getPoints", "()Ljava/util/List;", "points", "<init>", "()V", "Essential 1.19-fabric"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Vector3> getPoints() {
            Lazy lazy2 = points$delegate;
            return (List)lazy2.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b$\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b$\u0010%R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\"\u0010\f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\u0004\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\"\u0010\u000f\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0004\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\"\u0010\u0012\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0004\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\"\u0010\u0015\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0004\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\"\u0010\u0018\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0004\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\"\u0010\u001b\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0004\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\"\u0010\u001e\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0004\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\"\u0010!\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0004\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\b\u00a8\u0006&"}, d2={"Lgg/essential/model/Box3$IntersectsTriangleHelper;", "", "Lgg/essential/model/Vector3;", "center", "Lgg/essential/model/Vector3;", "getCenter", "()Lgg/essential/model/Vector3;", "setCenter", "(Lgg/essential/model/Vector3;)V", "extents", "getExtents", "setExtents", "f0", "getF0", "setF0", "f1", "getF1", "setF1", "f2", "getF2", "setF2", "testAxis", "getTestAxis", "setTestAxis", "triangleNormal", "getTriangleNormal", "setTriangleNormal", "v0", "getV0", "setV0", "v1", "getV1", "setV1", "v2", "getV2", "setV2", "<init>", "(Lgg/essential/model/Box3;)V", "Essential 1.19-fabric"})
    private final class IntersectsTriangleHelper {
        @NotNull
        private Vector3 v0;
        @NotNull
        private Vector3 v1;
        @NotNull
        private Vector3 v2;
        @NotNull
        private Vector3 f0;
        @NotNull
        private Vector3 f1;
        @NotNull
        private Vector3 f2;
        @NotNull
        private Vector3 testAxis;
        @NotNull
        private Vector3 center;
        @NotNull
        private Vector3 extents;
        @NotNull
        private Vector3 triangleNormal;

        public IntersectsTriangleHelper() {
            Intrinsics.checkNotNullParameter(Box3.this, "this$0");
            this.v0 = new Vector3();
            this.v1 = new Vector3();
            this.v2 = new Vector3();
            this.f0 = new Vector3();
            this.f1 = new Vector3();
            this.f2 = new Vector3();
            this.testAxis = new Vector3();
            this.center = new Vector3();
            this.extents = new Vector3();
            this.triangleNormal = new Vector3();
        }

        @NotNull
        public final Vector3 getV0() {
            return this.v0;
        }

        public final void setV0(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.v0 = vector3;
        }

        @NotNull
        public final Vector3 getV1() {
            return this.v1;
        }

        public final void setV1(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.v1 = vector3;
        }

        @NotNull
        public final Vector3 getV2() {
            return this.v2;
        }

        public final void setV2(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.v2 = vector3;
        }

        @NotNull
        public final Vector3 getF0() {
            return this.f0;
        }

        public final void setF0(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.f0 = vector3;
        }

        @NotNull
        public final Vector3 getF1() {
            return this.f1;
        }

        public final void setF1(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.f1 = vector3;
        }

        @NotNull
        public final Vector3 getF2() {
            return this.f2;
        }

        public final void setF2(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.f2 = vector3;
        }

        @NotNull
        public final Vector3 getTestAxis() {
            return this.testAxis;
        }

        public final void setTestAxis(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.testAxis = vector3;
        }

        @NotNull
        public final Vector3 getCenter() {
            return this.center;
        }

        public final void setCenter(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.center = vector3;
        }

        @NotNull
        public final Vector3 getExtents() {
            return this.extents;
        }

        public final void setExtents(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.extents = vector3;
        }

        @NotNull
        public final Vector3 getTriangleNormal() {
            return this.triangleNormal;
        }

        public final void setTriangleNormal(@NotNull Vector3 vector3) {
            Intrinsics.checkNotNullParameter(vector3, "<set-?>");
            this.triangleNormal = vector3;
        }
    }
}

