/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import com.google.common.collect.Lists;
import gg.essential.model.BedrockModel;
import gg.essential.model.Cube;
import gg.essential.model.Face;
import gg.essential.model.PositionTexVertex;
import gg.essential.model.Side;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.vertex.UVertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Bone {
    private final BedrockModel model;
    public final String boxName;
    public float textureWidth;
    public float textureHeight;
    public float pivotX;
    public float pivotY;
    public float pivotZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public boolean mirror;
    public boolean showModel;
    public boolean isHidden;
    public List<Cube> cubeList;
    public List<Bone> childModels;
    public Bone parent;
    public float animOffsetX;
    public float animOffsetY;
    public float animOffsetZ;
    public float animRotX;
    public float animRotY;
    public float animRotZ;
    public float animScaleX;
    public float animScaleY;
    public float animScaleZ;
    public float userOffsetX;
    public float userOffsetY;
    public float userOffsetZ;
    public float childScale = 1.0f;
    private Side side = null;
    public Boolean visible;
    private boolean isVisible = true;
    private boolean fullyInvisible;

    public Bone(BedrockModel model, String name) {
        this.model = model;
        this.textureWidth = 64.0f;
        this.textureHeight = 32.0f;
        this.showModel = true;
        this.cubeList = Lists.newArrayList();
        this.boxName = name;
        this.setTextureSize(model.textureWidth, model.textureHeight);
        this.resetAnimationOffsets(false);
    }

    public Side getSide() {
        return this.side;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public void addChild(Bone child) {
        if (this.childModels == null) {
            this.childModels = Lists.newArrayList();
        }
        this.childModels.add(child);
    }

    public void propagateVisibility(boolean parentVisible, Side side) {
        boolean fullyInvisible;
        if (this.side != null && side != null && this.side != side) {
            this.isVisible = false;
            this.fullyInvisible = true;
            return;
        }
        boolean isVisible = this.visible == null ? parentVisible : this.visible;
        boolean bl = fullyInvisible = !isVisible;
        if (this.childModels != null) {
            for (Bone child : this.childModels) {
                child.propagateVisibility(isVisible, side);
                fullyInvisible &= child.fullyInvisible;
            }
        }
        this.isVisible = isVisible;
        this.fullyInvisible = fullyInvisible;
    }

    public void resetAnimationOffsets(boolean recursive) {
        this.animOffsetZ = 0.0f;
        this.animOffsetY = 0.0f;
        this.animOffsetX = 0.0f;
        this.animRotZ = 0.0f;
        this.animRotY = 0.0f;
        this.animRotX = 0.0f;
        this.animScaleZ = 1.0f;
        this.animScaleY = 1.0f;
        this.animScaleX = 1.0f;
        if (recursive && this.childModels != null) {
            for (Bone childModel : this.childModels) {
                childModel.resetAnimationOffsets(true);
            }
        }
    }

    public void render(UMatrixStack matrixStack, UVertexConsumer renderer, int light, float scale, float verticalUVOffset) {
        if (!this.isHidden && this.showModel && !this.fullyInvisible) {
            matrixStack.push();
            matrixStack.scale(this.childScale, this.childScale, this.childScale);
            float translateX = this.pivotX * scale + this.animOffsetX * scale;
            float translateY = this.pivotY * scale - this.animOffsetY * scale;
            float translateZ = this.pivotZ * scale + this.animOffsetZ * scale;
            matrixStack.translate(translateX, translateY, translateZ);
            matrixStack.scale(this.animScaleX, this.animScaleY, this.animScaleZ);
            matrixStack.rotate(this.rotateAngleZ + this.animRotZ, 0.0f, 0.0f, 1.0f, false);
            matrixStack.rotate(-this.rotateAngleY + this.animRotY, 0.0f, 1.0f, 0.0f, false);
            matrixStack.rotate(this.rotateAngleX + this.animRotX, 1.0f, 0.0f, 0.0f, false);
            matrixStack.translate(-this.pivotX * scale - this.userOffsetX * scale, -this.pivotY * scale - this.userOffsetY * scale, -this.pivotZ * scale - this.userOffsetZ * scale);
            if (this.isVisible) {
                for (Cube cube : this.cubeList) {
                    cube.render(matrixStack, renderer, light, scale, verticalUVOffset);
                }
            }
            if (this.childModels != null) {
                for (Bone childModel : this.childModels) {
                    childModel.render(matrixStack, renderer, light, scale, verticalUVOffset);
                }
            }
            matrixStack.pop();
        }
    }

    public void setTextureSize(int p_setTextureSize_1_, int p_setTextureSize_2_) {
        this.textureWidth = p_setTextureSize_1_;
        this.textureHeight = p_setTextureSize_2_;
    }

    public Bone deepCopy() {
        Bone bone = new Bone(this.model, this.boxName);
        bone.textureWidth = this.textureWidth;
        bone.textureHeight = this.textureHeight;
        bone.parent = this.parent;
        bone.pivotX = this.pivotX;
        bone.pivotY = this.pivotY;
        bone.pivotZ = this.pivotZ;
        bone.rotateAngleX = this.rotateAngleX;
        bone.rotateAngleY = this.rotateAngleY;
        bone.rotateAngleZ = this.rotateAngleZ;
        bone.cubeList = new ArrayList<Cube>();
        for (Cube cube : this.cubeList) {
            ArrayList<Face> faces = new ArrayList<Face>();
            for (Face face : cube.getQuadList()) {
                PositionTexVertex[] positionTexVertices = Arrays.copyOf(face.vertexPositions, face.vertexPositions.length);
                for (int i = 0; i < positionTexVertices.length; ++i) {
                    positionTexVertices[i] = positionTexVertices[i].copy();
                }
                faces.add(new Face(positionTexVertices));
            }
            bone.cubeList.add(new Cube(faces));
        }
        if (this.childModels != null) {
            for (Bone childModel : this.childModels) {
                bone.addChild(childModel.deepCopy());
            }
        }
        return bone;
    }
}

