/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.essential.Essential;
import gg.essential.api.utils.JsonHolder;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.events.AnimationEvent;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticGeometry;
import gg.essential.cosmetics.model.CosmeticType;
import gg.essential.model.Animation;
import gg.essential.model.Bone;
import gg.essential.model.Box3;
import gg.essential.model.Cube;
import gg.essential.model.EnumPart;
import gg.essential.model.EssentialAsset;
import gg.essential.model.RenderMetadata;
import gg.essential.model.Side;
import gg.essential.model.Vector3;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.utils.ReleasedDynamicTexture;
import gg.essential.universal.vertex.UVertexConsumer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1007;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4597;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_897;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;

public class BedrockModel {
    private static final Offset RIGHT_ARM = new Offset(-5.0f, -22.0f, 0.0f, 5.0f, 2.0f, 0.0f);
    private static final Offset LEFT_ARM = new Offset(5.0f, -22.0f, 0.0f, -5.0f, 2.0f, 0.0f);
    private static final Offset LEFT_LEG = new Offset(1.9f, -12.0f, 0.0f, -1.9f, 12.0f, 0.0f);
    private static final Offset RIGHT_LEG = new Offset(-1.9f, -12.0f, 0.0f, 1.9f, 12.0f, 0.0f);
    private static final Offset BODY = new Offset(0.0f, -24.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final Offset HEAD = new Offset(0.0f, -24.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final Offset NONE = new Offset(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final float TEXTURE_ANIMATION_FPS = 7.0f;
    private static final Gson GSON = new GsonBuilder().create();
    public final List<Bone> boneList = new ArrayList<Bone>();
    public final List<Box3> boundingBoxes = new ArrayList<Box3>();
    private final HashMap<String, Bone> bones = new HashMap();
    private final Bone rootBone = new Bone(this, "_root");
    private final Cosmetic cosmetic;
    public int textureWidth = 64;
    public int textureHeight = 32;
    private int totalHeight;
    private JsonHolder data;
    private JsonHolder animationData;
    private String name;
    private List<Animation> animations;
    private ReleasedDynamicTexture texture;
    private class_2960 textureLocation;
    private float lastFrame = -1.0f;
    private boolean containsSideOption = false;
    private AnimationEvent[] animationEvents = new AnimationEvent[0];

    public BedrockModel(Cosmetic cosmetic, String skinType) {
        this.cosmetic = cosmetic;
        this.boneList.add(this.rootBone);
        CosmeticsManager cosmeticsManager = Essential.getInstance().getConnectionManager().getCosmeticsManager();
        try {
            CosmeticGeometry geometry = cosmetic.getAssets().getGeometry();
            this.data = this.readJson(cosmeticsManager.getCosmeticAsset((EssentialAsset)ObjectUtils.firstNonNull((Object[])new EssentialAsset[]{"slim".equals(skinType) ? geometry.getAlex() : null, geometry.getSteve()})));
            EssentialAsset animations = cosmetic.getAssets().getAnimations();
            if (animations != null) {
                this.animationData = this.readJson(cosmeticsManager.getCosmeticAsset(animations));
            }
            this.texture = UGraphics.getTexture(cosmeticsManager.getCosmeticAsset(cosmetic.getAssets().getTexture()));
            if (this.animationData != null) {
                JsonArray triggers = this.animationData.optJSONArray("triggers");
                this.animationEvents = new AnimationEvent[triggers.size()];
                for (int i = 0; i < triggers.size(); ++i) {
                    this.animationEvents[i] = (AnimationEvent)GSON.fromJson((JsonElement)triggers.get(i).getAsJsonObject(), AnimationEvent.class);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.initialize(this.data);
        this.animations = Animation.parseFile(this.animationData != null ? this.animationData.getObject() : new JsonObject());
    }

    public Bone getRootBone() {
        return this.rootBone;
    }

    public AnimationEvent[] getAnimationEvents() {
        return this.animationEvents;
    }

    private JsonHolder readJson(InputStream stream) {
        try {
            String raw = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
            stream.close();
            return new JsonHolder(raw);
        }
        catch (IOException | NullPointerException e) {
            Essential.logger.error("Failed to read: {}", (Object)this.cosmetic.getId());
            return new JsonHolder();
        }
    }

    private void initialize(JsonHolder holder) {
        JsonArray arr;
        this.bones.clear();
        this.boneList.clear();
        this.boundingBoxes.clear();
        if (this.rootBone.childModels != null) {
            this.rootBone.childModels.clear();
        }
        if ((arr = holder.optJSONArray("minecraft:geometry")).size() < 1) {
            return;
        }
        JsonHolder items = new JsonHolder(arr.get(0).getAsJsonObject());
        JsonHolder description2 = items.optJSONObject("description");
        CosmeticType cosmeticType = Essential.getInstance().getConnectionManager().getCosmeticsManager().getCosmeticType(this.cosmetic.getType());
        boolean extraInflate = cosmeticType != null && (cosmeticType.getSlot() == CosmeticSlot.ARMS || cosmeticType.getSlot() == CosmeticSlot.PANTS || cosmeticType.getSlot() == CosmeticSlot.SHOES || cosmeticType.getSlot() == CosmeticSlot.FACE);
        this.totalHeight = this.texture.getHeight();
        this.rootBone.textureHeight = this.totalHeight;
        this.rootBone.textureWidth = description2.optInt("texture_width");
        for (JsonElement bones : items.optJSONArray("bones")) {
            Bone parent;
            JsonHolder bone = new JsonHolder(bones.getAsJsonObject());
            String boneName = bone.optString("name");
            if (boneName.startsWith("bbox_")) {
                for (JsonElement cubes : bone.optJSONArray("cubes")) {
                    JsonHolder cube = new JsonHolder(cubes.getAsJsonObject());
                    float[] origins = this.readFloats(cube.optJSONArray("origin"), 3);
                    float[] sizes = this.readFloats(cube.optJSONArray("size"), 3);
                    double inflate = cube.optDouble("inflate") + 0.025;
                    boolean mirror = cube.optBoolean("mirror");
                    Box3 box = new Box3();
                    float x1 = origins[0];
                    float x2 = origins[0] + sizes[0];
                    if (mirror) {
                        float x3 = x1;
                        x2 = x1;
                        x1 = x3;
                    }
                    box.setFromPoints(Arrays.asList(new Vector3(x1, -origins[1], origins[2]), new Vector3(x2, -origins[1] + -sizes[1], origins[2] + sizes[2])));
                    box.expandByScalar((float)inflate);
                    this.boundingBoxes.add(box);
                }
                continue;
            }
            Bone boneModel = new Bone(this, boneName);
            this.boneList.add(boneModel);
            this.bones.put(boneName, boneModel);
            boneModel.setTextureSize((int)this.rootBone.textureWidth, (int)this.rootBone.textureHeight);
            float[] pivots = this.readFloats(bone.optJSONArray("pivot"), 3);
            boneModel.pivotX = pivots[0];
            boneModel.pivotY = -pivots[1];
            boneModel.pivotZ = pivots[2];
            int[] rotations = this.readInts(bone.optJSONArray("rotation"), 3);
            boneModel.rotateAngleX = (float)Math.toRadians(rotations[0]);
            boneModel.rotateAngleY = (float)Math.toRadians(-rotations[1]);
            boneModel.rotateAngleZ = (float)Math.toRadians(rotations[2]);
            boneModel.mirror = bone.optBoolean("mirror");
            boneModel.parent = parent = this.bones.get(bone.optString("parent"));
            if (bone.has("side")) {
                boneModel.setSide(Side.valueOf(bone.optString("side").toUpperCase(Locale.ROOT)));
                if (boneModel.getSide() != null) {
                    this.containsSideOption = true;
                }
            }
            for (JsonElement cubes : bone.optJSONArray("cubes")) {
                JsonHolder cube = new JsonHolder(cubes.getAsJsonObject());
                int[] uvs = this.readInts(cube.optJSONArray("uv"), 2);
                float[] origins = this.readFloats(cube.optJSONArray("origin"), 3);
                float[] sizes = this.readFloats(cube.optJSONArray("size"), 3);
                float inflate = (float)cube.optDouble("inflate", 0.0) + (extraInflate ? 0.04f : 0.02f);
                if (cube.getObject().get("uv").isJsonObject()) {
                    boneModel.cubeList.add(new Cube(boneModel, origins[0], -origins[1] - sizes[1], origins[2], sizes[0], sizes[1], sizes[2], inflate, cube.optBoolean("mirror", boneModel.mirror), cube.optJSONObject("uv")));
                    continue;
                }
                boneModel.cubeList.add(new Cube(boneModel, uvs[0], uvs[1], origins[0], -origins[1] - sizes[1], origins[2], sizes[0], sizes[1], sizes[2], inflate, cube.optBoolean("mirror", boneModel.mirror)));
            }
            if (parent != null) {
                parent.addChild(boneModel);
                continue;
            }
            this.rootBone.addChild(boneModel);
        }
    }

    private float[] readFloats(JsonArray source, int size) {
        float[] read = new float[size];
        for (int i = 0; i < size; ++i) {
            read[i] = source.size() > i ? source.get(i).getAsFloat() : 0.0f;
        }
        return read;
    }

    private int[] readInts(JsonArray source, int size) {
        int[] read = new int[size];
        for (int i = 0; i < size; ++i) {
            read[i] = source.size() > i ? source.get(i).getAsInt() : 0;
        }
        return read;
    }

    public Bone getBoneByName(String name) {
        return this.bones.get(name);
    }

    public Animation getAnimationByName(String name) {
        for (Animation animation : this.animations) {
            if (!animation.getName().equals(name)) continue;
            return animation;
        }
        return null;
    }

    public List<Animation> getAnimations() {
        return this.animations;
    }

    public Set<EnumPart> getParts() {
        EnumSet<EnumPart> parts = EnumSet.noneOf(EnumPart.class);
        for (Bone bone : this.boneList) {
            EnumPart part = EnumPart.fromBoneName(bone.boxName);
            if (part == null) continue;
            parts.add(part);
        }
        return parts;
    }

    public boolean isContainsSideOption() {
        return this.containsSideOption;
    }

    public void render(UMatrixStack matrixStack, UVertexConsumerProvider vertexConsumerProvider, Bone rootBone, RenderMetadata metadata2, float lifetime) {
        Side side;
        class_742 player2 = metadata2.getPlayer();
        if (this.textureLocation == null) {
            this.textureLocation = new class_2960("essential", "textures/cosmetics/" + this.cosmetic.getId().toLowerCase(Locale.ROOT));
            class_1060 textureManager = UMinecraft.getMinecraft().method_1531();
            textureManager.method_4615(this.textureLocation);
            textureManager.method_4616(this.textureLocation, (class_1044)this.texture);
        }
        if (metadata2.getStandalone()) {
            matrixStack.push();
            matrixStack.scale(1.0f, -1.0f, -1.0f);
            if (player2 != null && player2.method_5715()) {
                matrixStack.translate(0.0f, 5.0f, 0.0f);
            }
            matrixStack.scale(0.9375, 0.9375, 0.9375);
        }
        float totalFrames = (float)this.totalHeight / rootBone.textureWidth;
        int frame = (int)(lifetime * 7.0f);
        float offset = (float)frame % totalFrames / totalFrames;
        if (player2 != null) {
            Set<String> hiddenBones = metadata2.getHiddenBones();
            Set<EnumPart> parts = metadata2.getParts();
            class_897 obj = class_310.method_1551().method_1561().method_3953((class_1297)player2);
            if (obj instanceof class_1007) {
                class_591 mainModel = (class_591)((class_1007)obj).method_4038();
                for (Bone bone : this.getBones(rootBone)) {
                    EnumPart part = EnumPart.fromBoneName(bone.boxName);
                    if (part == null) {
                        bone.visible = hiddenBones.contains(bone.boxName) ? Boolean.valueOf(false) : null;
                        continue;
                    }
                    bone.visible = (parts == null || parts.contains((Object)part)) && !hiddenBones.contains(bone.boxName);
                    switch (part) {
                        case RIGHT_ARM: {
                            this.copy(mainModel.field_3401, bone, RIGHT_ARM);
                            break;
                        }
                        case LEFT_ARM: {
                            this.copy(mainModel.field_27433, bone, LEFT_ARM);
                            break;
                        }
                        case BODY: {
                            this.copy(mainModel.field_3391, bone, BODY);
                            break;
                        }
                        case LEFT_LEG: {
                            this.copy(mainModel.field_3397, bone, LEFT_LEG);
                            break;
                        }
                        case RIGHT_LEG: {
                            this.copy(mainModel.field_3392, bone, RIGHT_LEG);
                            break;
                        }
                        case HEAD: {
                            this.copy(mainModel.field_3398, bone, HEAD);
                        }
                    }
                    if (!mainModel.field_3448) continue;
                    if (part == EnumPart.HEAD) {
                        bone.childScale = 0.75f;
                        bone.animOffsetY -= 8.0f;
                        continue;
                    }
                    bone.childScale = 0.5f;
                }
            }
        }
        if ((side = metadata2.getSide()) == null && this.containsSideOption) {
            side = Side.getDefaultSide();
        }
        rootBone.propagateVisibility(true, side);
        vertexConsumerProvider.provide(this.textureLocation, vertexConsumer -> rootBone.render(matrixStack, (UVertexConsumer)vertexConsumer, metadata2.getLight(), metadata2.getScale(), offset));
        if (metadata2.getStandalone()) {
            matrixStack.pop();
        }
    }

    public List<Bone> getBones(Bone bone) {
        ArrayList<Bone> bones = new ArrayList<Bone>();
        bones.add(bone);
        if (bone.childModels != null) {
            for (Bone childModel : bone.childModels) {
                bones.addAll(this.getBones(childModel));
            }
        }
        return bones;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    private void copy(class_630 renderer, Bone bone, Offset offset) {
        bone.rotateAngleX = renderer.field_3654;
        bone.rotateAngleY = -renderer.field_3675;
        bone.rotateAngleZ = renderer.field_3674;
        bone.pivotX = offset.pivotX;
        bone.pivotY = offset.pivotY;
        bone.pivotZ = offset.pivotZ;
        bone.animOffsetX += renderer.field_3657 + offset.offsetX;
        bone.animOffsetY += -renderer.field_3656 + offset.offsetY;
        bone.animOffsetZ += renderer.field_3655 + offset.offsetZ;
        bone.isHidden = false;
        bone.childScale = 1.0f;
    }

    public void resetAngles() {
        this.rootBone.resetAnimationOffsets(true);
    }

    static class Offset {
        private final float pivotX;
        private final float pivotY;
        private final float pivotZ;
        private final float offsetX;
        private final float offsetY;
        private final float offsetZ;

        public Offset(float pivotX, float pivotY, float pivotZ, float offsetX, float offsetY, float offsetZ) {
            this.pivotX = pivotX;
            this.pivotY = pivotY;
            this.pivotZ = pivotZ;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    public static class UVertexConsumerProvider {
        private final class_4597 provider;

        public UVertexConsumerProvider(class_4597 provider2) {
            this.provider = provider2;
        }

        void provide(class_2960 texture, Consumer<UVertexConsumer> block) {
            block.accept(UVertexConsumer.of(this.provider.getBuffer(class_1921.method_23689((class_2960)texture))));
        }
    }
}

