/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gg.essential.Essential;
import gg.essential.api.utils.JsonHolder;
import gg.essential.cosmetics.CosmeticSlot;
import gg.essential.cosmetics.EssentialModelRenderer;
import gg.essential.cosmetics.PlayerModelRenderState;
import gg.essential.cosmetics.SkinLayer;
import gg.essential.cosmetics.WearableBedrockModel;
import gg.essential.cosmetics.model.Cosmetic;
import gg.essential.cosmetics.model.CosmeticSetting;
import gg.essential.cosmetics.skinmask.MaskedSkinProvider;
import gg.essential.cosmetics.source.CosmeticsSource;
import gg.essential.cosmetics.source.LiveCosmeticsSource;
import gg.essential.handlers.GameProfileManager;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.model.EnumPart;
import gg.essential.network.connectionmanager.cosmetics.CosmeticsManager;
import gg.essential.util.UUIDUtil;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_742.class})
public abstract class MixinAbstractClientPlayer
implements AbstractClientPlayerExt {
    @Unique
    private CosmeticsSource cosmeticsSource;
    @Unique
    private final Map<Cosmetic, WearableBedrockModel> essentialCosmeticModels = new HashMap<Cosmetic, WearableBedrockModel>();
    @Unique
    private final Set<SkinLayer> coveredLayers = EnumSet.noneOf(SkinLayer.class);
    @Unique
    private final MaskedSkinProvider maskedSkinProvider = new MaskedSkinProvider();
    @Unique
    private ImmutableMap<CosmeticSlot, String> essentialCosmetics;
    @Unique
    private ImmutableMap<String, ImmutableList<CosmeticSetting>> essentialCosmeticSettings;
    @Unique
    private String essentialCosmeticsSkinType;
    @Unique
    private MaskedSkinProvider.Config cosmeticMaskConfig;
    @Unique
    private final PlayerModelRenderState playerModelRenderState = new PlayerModelRenderState(((class_1657)this).method_7334().getId());
    @Unique
    private Boolean serverSkinOverrideStatus = null;

    @Shadow
    public abstract String method_3121();

    @Override
    public CosmeticsSource getCosmeticsSource() {
        if (this.cosmeticsSource == null) {
            CosmeticsManager cosmeticsManager = Essential.getInstance().getConnectionManager().getCosmeticsManager();
            UUID uuid = ((class_1297)this).method_5667();
            this.cosmeticsSource = new LiveCosmeticsSource(cosmeticsManager, uuid);
        }
        return this.cosmeticsSource;
    }

    @Override
    public void setCosmeticsSource(CosmeticsSource cosmeticsSource) {
        this.cosmeticsSource = cosmeticsSource;
    }

    @Override
    @Nullable
    public ImmutableMap<CosmeticSlot, String> getEssentialCosmetics() {
        return this.essentialCosmetics;
    }

    @Override
    public void setEssentialCosmetics(@Nullable ImmutableMap<CosmeticSlot, String> essentialCosmetics) {
        this.essentialCosmetics = essentialCosmetics;
    }

    @Override
    public ImmutableMap<String, ImmutableList<CosmeticSetting>> getEssentialCosmeticSettings() {
        return this.essentialCosmeticSettings;
    }

    @Override
    public void setEssentialCosmeticSettings(ImmutableMap<String, ImmutableList<CosmeticSetting>> map2) {
        this.essentialCosmeticSettings = map2;
    }

    @Override
    @Nullable
    public String getEssentialCosmeticsSkinType() {
        return this.essentialCosmeticsSkinType;
    }

    @Override
    public void setEssentialCosmeticsSkinType(@Nullable String skinType) {
        this.essentialCosmeticsSkinType = skinType;
    }

    @Override
    @NotNull
    public Map<Cosmetic, WearableBedrockModel> getEssentialCosmeticModels() {
        return this.essentialCosmeticModels;
    }

    @Override
    @NotNull
    public Set<SkinLayer> getCoveredLayers() {
        return this.coveredLayers;
    }

    @Override
    public void cosmeticMaskConfig(@Nullable MaskedSkinProvider.Config config) {
        this.cosmeticMaskConfig = config;
    }

    @Override
    public class_2960 applyEssentialCosmeticsMask(class_2960 skin) {
        class_2960 maskedSkin;
        if (EssentialModelRenderer.cosmeticsShouldRender((class_1657)this) && (maskedSkin = this.maskedSkinProvider.provide(skin, this.method_3121(), this.cosmeticMaskConfig, this.playerModelRenderState)) != null) {
            return maskedSkin;
        }
        return skin;
    }

    @Override
    public PlayerModelRenderState getModelRenderState() {
        return this.playerModelRenderState;
    }

    @Override
    public Set<EnumPart> getCachedArmour() {
        if (this.cosmeticMaskConfig == null || this.cosmeticMaskConfig.armour == null) {
            return new HashSet<EnumPart>();
        }
        return this.cosmeticMaskConfig.armour;
    }

    @Override
    public boolean isSkinOverrodeByServer() {
        if (this.serverSkinOverrideStatus == null) {
            String values2 = GameProfileManager.getSafeTexturesValue(((class_1657)this).method_7334());
            JsonHolder root = new JsonHolder(new String(Base64.getDecoder().decode(values2)));
            this.serverSkinOverrideStatus = !root.optString("profileId").isEmpty() && !((class_1657)this).method_7334().getId().equals(UUIDUtil.formatWithDashes(root.optString("profileId")));
        }
        return this.serverSkinOverrideStatus;
    }
}

