/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import gg.essential.asm.EssentialTransformer;
import gg.essential.lib.mixinextras.MixinExtrasBootstrap;
import gg.essential.mixins.injection.points.AfterInvokeInInit;
import gg.essential.mixins.injection.points.BeforeConstantInInit;
import gg.essential.util.MixinUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class Plugin
implements IMixinConfigPlugin {
    private final boolean hasOptifine = Plugin.hasClass("optifine.OptiFineForgeTweaker") || Plugin.hasClass("me.modmuss50.optifabric.mod.OptifineInjector");
    private final EssentialTransformer[] transformers = new EssentialTransformer[0];
    private final Multimap<String, EssentialTransformer> transformerMap = ArrayListMultimap.create();

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
        MixinUtils.registerInjectionPoint(AfterInvokeInInit.class);
        MixinUtils.registerInjectionPoint(BeforeConstantInInit.class);
        for (EssentialTransformer transformer : this.transformers) {
            for (String target : transformer.getTargets()) {
                this.transformerMap.put((Object)target, (Object)transformer);
            }
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!this.hasOptifine && mixinClassName.endsWith("_Optifine")) {
            return false;
        }
        if (this.hasOptifine && mixinClassName.endsWith("_Zoom")) {
            return false;
        }
        return !mixinClassName.contains("compatibility") || Plugin.hasClass(targetClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        for (EssentialTransformer transformer : this.transformerMap.get((Object)targetClassName)) {
            transformer.transform(targetClass);
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static boolean hasClass(String name) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(name);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

