/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.weupnp;

import gg.essential.lib.weupnp.GatewayDevice;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayDiscover {
    public static final int PORT = 1900;
    public static final String IP = "239.255.255.250";
    private static final int DEFAULT_TIMEOUT = 3000;
    private int timeout = 3000;
    private String[] searchTypes;
    private static final String[] DEFAULT_SEARCH_TYPES = new String[]{"urn:schemas-upnp-org:device:InternetGatewayDevice:1", "urn:schemas-upnp-org:service:WANIPConnection:1", "urn:schemas-upnp-org:service:WANPPPConnection:1"};
    private final Map<InetAddress, GatewayDevice> devices = new HashMap<InetAddress, GatewayDevice>();

    public GatewayDiscover() {
        this(DEFAULT_SEARCH_TYPES);
    }

    public GatewayDiscover(String st) {
        this(new String[]{st});
    }

    public GatewayDiscover(String[] types) {
        this.searchTypes = types;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }

    public Map<InetAddress, GatewayDevice> discover() throws SocketException, UnknownHostException, IOException, SAXException, ParserConfigurationException {
        List<InetAddress> ips = this.getLocalInetAddresses(true, false, false);
        for (int i = 0; i < this.searchTypes.length; ++i) {
            String searchMessage = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nST: " + this.searchTypes[i] + "\r\n" + "MAN: \"ssdp:discover\"\r\n" + "MX: 2\r\n" + "\r\n";
            ArrayList<SendDiscoveryThread> threads = new ArrayList<SendDiscoveryThread>();
            for (InetAddress ip : ips) {
                SendDiscoveryThread thread2 = new SendDiscoveryThread(ip, searchMessage);
                threads.add(thread2);
                thread2.start();
            }
            for (SendDiscoveryThread thread3 : threads) {
                try {
                    thread3.join();
                }
                catch (InterruptedException e) {}
            }
            if (!this.devices.isEmpty()) break;
        }
        return this.devices;
    }

    private GatewayDevice parseMSearchReply(byte[] reply) {
        GatewayDevice device = new GatewayDevice();
        String replyString = new String(reply);
        StringTokenizer st = new StringTokenizer(replyString, "\n");
        while (st.hasMoreTokens()) {
            String line2 = st.nextToken().trim();
            if (line2.isEmpty() || line2.startsWith("HTTP/1.") || line2.startsWith("NOTIFY *")) continue;
            String key = line2.substring(0, line2.indexOf(58));
            String value2 = line2.length() > key.length() + 1 ? line2.substring(key.length() + 1) : null;
            key = key.trim();
            if (value2 != null) {
                value2 = value2.trim();
            }
            if (key.compareToIgnoreCase("location") == 0) {
                device.setLocation(value2);
                continue;
            }
            if (key.compareToIgnoreCase("st") != 0) continue;
            device.setSt(value2);
        }
        return device;
    }

    public GatewayDevice getValidGateway() {
        for (GatewayDevice device : this.devices.values()) {
            try {
                if (!device.isConnected()) continue;
                return device;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Map<InetAddress, GatewayDevice> getAllGateways() {
        return this.devices;
    }

    private List<InetAddress> getLocalInetAddresses(boolean getIPv4, boolean getIPv6, boolean sortIPv4BeforeIPv6) {
        Enumeration<NetworkInterface> networkInterfaces;
        ArrayList<InetAddress> arrayIPAddress = new ArrayList<InetAddress>();
        int lastIPv4Index = 0;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return arrayIPAddress;
        }
        if (networkInterfaces == null) {
            return arrayIPAddress;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface card = networkInterfaces.nextElement();
            try {
                if (card.isLoopback() || card.isPointToPoint() || card.isVirtual()) continue;
                if (!card.isUp()) {
                }
            }
            catch (SocketException e) {}
            continue;
            Enumeration<InetAddress> addresses = card.getInetAddresses();
            if (addresses == null) continue;
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                int index2 = arrayIPAddress.size();
                if (!getIPv4 || !getIPv6) {
                    if (getIPv4 && !Inet4Address.class.isInstance(inetAddress) || getIPv6 && !Inet6Address.class.isInstance(inetAddress)) {
                        continue;
                    }
                } else if (sortIPv4BeforeIPv6 && Inet4Address.class.isInstance(inetAddress)) {
                    index2 = lastIPv4Index++;
                }
                arrayIPAddress.add(index2, inetAddress);
            }
        }
        return arrayIPAddress;
    }

    private class SendDiscoveryThread
    extends Thread {
        InetAddress ip;
        String searchMessage;

        SendDiscoveryThread(InetAddress localIP, String searchMessage) {
            this.ip = localIP;
            this.searchMessage = searchMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DatagramSocket ssdp = null;
            try {
                ssdp = new DatagramSocket(new InetSocketAddress(this.ip, 0));
                byte[] searchMessageBytes = this.searchMessage.getBytes();
                DatagramPacket ssdpDiscoverPacket = new DatagramPacket(searchMessageBytes, searchMessageBytes.length);
                ssdpDiscoverPacket.setAddress(InetAddress.getByName(GatewayDiscover.IP));
                ssdpDiscoverPacket.setPort(1900);
                ssdp.send(ssdpDiscoverPacket);
                ssdp.setSoTimeout(GatewayDiscover.this.timeout);
                boolean waitingPacket = true;
                while (waitingPacket) {
                    DatagramPacket receivePacket = new DatagramPacket(new byte[1536], 1536);
                    try {
                        ssdp.receive(receivePacket);
                        byte[] receivedData = new byte[receivePacket.getLength()];
                        System.arraycopy(receivePacket.getData(), 0, receivedData, 0, receivePacket.getLength());
                        GatewayDevice gatewayDevice = GatewayDiscover.this.parseMSearchReply(receivedData);
                        gatewayDevice.setLocalAddress(this.ip);
                        gatewayDevice.loadDescription();
                        if (!Arrays.asList(GatewayDiscover.this.searchTypes).contains(gatewayDevice.getSt())) continue;
                        Map map2 = GatewayDiscover.this.devices;
                        synchronized (map2) {
                            GatewayDiscover.this.devices.put(this.ip, gatewayDevice);
                            break;
                        }
                    }
                    catch (SocketTimeoutException ste) {
                        waitingPacket = false;
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (null != ssdp) {
                    ssdp.close();
                }
            }
        }
    }
}

