/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.websocket.extensions;

import gg.essential.lib.websocket.exceptions.InvalidDataException;
import gg.essential.lib.websocket.exceptions.InvalidFrameException;
import gg.essential.lib.websocket.extensions.DefaultExtension;
import gg.essential.lib.websocket.framing.ControlFrame;
import gg.essential.lib.websocket.framing.DataFrame;
import gg.essential.lib.websocket.framing.Framedata;

public abstract class CompressionExtension
extends DefaultExtension {
    @Override
    public void isFrameValid(Framedata inputFrame) throws InvalidDataException {
        if (inputFrame instanceof DataFrame && (inputFrame.isRSV2() || inputFrame.isRSV3())) {
            throw new InvalidFrameException("bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3());
        }
        if (inputFrame instanceof ControlFrame && (inputFrame.isRSV1() || inputFrame.isRSV2() || inputFrame.isRSV3())) {
            throw new InvalidFrameException("bad rsv RSV1: " + inputFrame.isRSV1() + " RSV2: " + inputFrame.isRSV2() + " RSV3: " + inputFrame.isRSV3());
        }
    }
}

