/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.websocket;

import gg.essential.lib.websocket.WebSocket;
import gg.essential.lib.websocket.WebSocketListener;
import gg.essential.lib.websocket.drafts.Draft;
import gg.essential.lib.websocket.exceptions.InvalidDataException;
import gg.essential.lib.websocket.framing.Framedata;
import gg.essential.lib.websocket.framing.PingFrame;
import gg.essential.lib.websocket.framing.PongFrame;
import gg.essential.lib.websocket.handshake.ClientHandshake;
import gg.essential.lib.websocket.handshake.HandshakeImpl1Server;
import gg.essential.lib.websocket.handshake.ServerHandshake;
import gg.essential.lib.websocket.handshake.ServerHandshakeBuilder;

public abstract class WebSocketAdapter
implements WebSocketListener {
    private PingFrame pingFrame;

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response2) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        conn.sendFrame(new PongFrame((PingFrame)f));
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public PingFrame onPreparePing(WebSocket conn) {
        if (this.pingFrame == null) {
            this.pingFrame = new PingFrame();
        }
        return this.pingFrame;
    }
}

