/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.typesafeconfig.impl;

import gg.essential.lib.typesafeconfig.ConfigException;
import gg.essential.lib.typesafeconfig.ConfigOrigin;
import gg.essential.lib.typesafeconfig.ConfigSyntax;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigNode;
import gg.essential.lib.typesafeconfig.impl.AbstractConfigNodeValue;
import gg.essential.lib.typesafeconfig.impl.ConfigNodeArray;
import gg.essential.lib.typesafeconfig.impl.ConfigNodeComplexValue;
import gg.essential.lib.typesafeconfig.impl.ConfigNodeObject;
import gg.essential.lib.typesafeconfig.impl.Path;
import gg.essential.lib.typesafeconfig.impl.PathParser;
import java.util.ArrayList;
import java.util.Collection;

final class ConfigNodeRoot
extends ConfigNodeComplexValue {
    private final ConfigOrigin origin;

    ConfigNodeRoot(Collection<AbstractConfigNode> children2, ConfigOrigin origin) {
        super(children2);
        this.origin = origin;
    }

    @Override
    protected ConfigNodeRoot newNode(Collection<AbstractConfigNode> nodes) {
        throw new ConfigException.BugOrBroken("Tried to indent the root object");
    }

    protected ConfigNodeComplexValue value() {
        for (AbstractConfigNode node2 : this.children) {
            if (!(node2 instanceof ConfigNodeComplexValue)) continue;
            return (ConfigNodeComplexValue)node2;
        }
        throw new ConfigException.BugOrBroken("ConfigNodeRoot did not contain a value");
    }

    protected ConfigNodeRoot setValue(String desiredPath, AbstractConfigNodeValue value2, ConfigSyntax flavor) {
        ArrayList<AbstractConfigNode> childrenCopy = new ArrayList<AbstractConfigNode>(this.children);
        for (int i = 0; i < childrenCopy.size(); ++i) {
            AbstractConfigNode node2 = (AbstractConfigNode)childrenCopy.get(i);
            if (!(node2 instanceof ConfigNodeComplexValue)) continue;
            if (node2 instanceof ConfigNodeArray) {
                throw new ConfigException.WrongType(this.origin, "The ConfigDocument had an array at the root level, and values cannot be modified inside an array.");
            }
            if (!(node2 instanceof ConfigNodeObject)) continue;
            if (value2 == null) {
                childrenCopy.set(i, ((ConfigNodeObject)node2).removeValueOnPath(desiredPath, flavor));
            } else {
                childrenCopy.set(i, ((ConfigNodeObject)node2).setValueOnPath(desiredPath, value2, flavor));
            }
            return new ConfigNodeRoot(childrenCopy, this.origin);
        }
        throw new ConfigException.BugOrBroken("ConfigNodeRoot did not contain a value");
    }

    protected boolean hasValue(String desiredPath) {
        Path path = PathParser.parsePath(desiredPath);
        ArrayList childrenCopy = new ArrayList(this.children);
        for (int i = 0; i < childrenCopy.size(); ++i) {
            AbstractConfigNode node2 = (AbstractConfigNode)childrenCopy.get(i);
            if (!(node2 instanceof ConfigNodeComplexValue)) continue;
            if (node2 instanceof ConfigNodeArray) {
                throw new ConfigException.WrongType(this.origin, "The ConfigDocument had an array at the root level, and values cannot be modified inside an array.");
            }
            if (!(node2 instanceof ConfigNodeObject)) continue;
            return ((ConfigNodeObject)node2).hasValue(path);
        }
        throw new ConfigException.BugOrBroken("ConfigNodeRoot did not contain a value");
    }
}

