/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.platform;

import gg.essential.lib.okhttp3.OkHttpClient;
import gg.essential.lib.okhttp3.Protocol;
import gg.essential.lib.okhttp3.internal.platform.AndroidPlatform;
import gg.essential.lib.okhttp3.internal.platform.Jdk9Platform;
import gg.essential.lib.okhttp3.internal.platform.JdkWithJettyBootPlatform;
import gg.essential.lib.okhttp3.internal.tls.BasicCertificateChainCleaner;
import gg.essential.lib.okhttp3.internal.tls.BasicTrustRootIndex;
import gg.essential.lib.okhttp3.internal.tls.CertificateChainCleaner;
import gg.essential.lib.okhttp3.internal.tls.TrustRootIndex;
import gg.essential.lib.okio.Buffer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    public static final int INFO = 4;
    public static final int WARN = 5;
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        try {
            Class<?> sslContextClass = Class.forName("sun.security.ssl.SSLContextImpl");
            Object context = Platform.readFieldOrNull(sslSocketFactory, sslContextClass, "context");
            if (context == null) {
                return null;
            }
            return Platform.readFieldOrNull(context, X509TrustManager.class, "trustManager");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
    }

    public void afterHandshake(SSLSocket sslSocket) {
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    public void log(int level, String message, Throwable t) {
        Level logLevel = level == 5 ? Level.WARNING : Level.INFO;
        logger.log(logLevel, message, t);
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        return true;
    }

    public Object getStackTraceForCloseable(String closer) {
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(closer);
        }
        return null;
    }

    public void logCloseableLeak(String message, Object stackTrace) {
        if (stackTrace == null) {
            message = message + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        this.log(5, message, (Throwable)stackTrace);
    }

    public static List<String> alpnProtocolNames(List<Protocol> protocols) {
        ArrayList<String> names = new ArrayList<String>(protocols.size());
        int size = protocols.size();
        for (int i = 0; i < size; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            names.add(protocol.toString());
        }
        return names;
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(trustManager));
    }

    private static Platform findPlatform() {
        Platform android = AndroidPlatform.buildIfSupported();
        if (android != null) {
            return android;
        }
        Jdk9Platform jdk9 = Jdk9Platform.buildIfSupported();
        if (jdk9 != null) {
            return jdk9;
        }
        Platform jdkWithJettyBoot = JdkWithJettyBootPlatform.buildIfSupported();
        if (jdkWithJettyBoot != null) {
            return jdkWithJettyBoot;
        }
        return new Platform();
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        Buffer result2 = new Buffer();
        int size = protocols.size();
        for (int i = 0; i < size; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            result2.writeByte(protocol.toString().length());
            result2.writeUtf8(protocol.toString());
        }
        return result2.readByteArray();
    }

    static <T> T readFieldOrNull(Object instance2, Class<T> fieldType, String fieldName) {
        Object delegate;
        for (Class<?> c = instance2.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field field2 = c.getDeclaredField(fieldName);
                field2.setAccessible(true);
                Object value2 = field2.get(instance2);
                if (value2 == null || !fieldType.isInstance(value2)) {
                    return null;
                }
                return fieldType.cast(value2);
            }
            catch (NoSuchFieldException field2) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
        if (!fieldName.equals("delegate") && (delegate = Platform.readFieldOrNull(instance2, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(delegate, fieldType, fieldName);
        }
        return null;
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        return new BasicTrustRootIndex(trustManager.getAcceptedIssuers());
    }
}

