/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.http2;

import gg.essential.lib.okhttp3.internal.Util;
import gg.essential.lib.okio.ByteString;

public final class Header {
    public static final ByteString PSEUDO_PREFIX = ByteString.encodeUtf8(":");
    public static final ByteString RESPONSE_STATUS = ByteString.encodeUtf8(":status");
    public static final ByteString TARGET_METHOD = ByteString.encodeUtf8(":method");
    public static final ByteString TARGET_PATH = ByteString.encodeUtf8(":path");
    public static final ByteString TARGET_SCHEME = ByteString.encodeUtf8(":scheme");
    public static final ByteString TARGET_AUTHORITY = ByteString.encodeUtf8(":authority");
    public final ByteString name;
    public final ByteString value;
    final int hpackSize;

    public Header(String name, String value2) {
        this(ByteString.encodeUtf8(name), ByteString.encodeUtf8(value2));
    }

    public Header(ByteString name, String value2) {
        this(name, ByteString.encodeUtf8(value2));
    }

    public Header(ByteString name, ByteString value2) {
        this.name = name;
        this.value = value2;
        this.hpackSize = 32 + name.size() + value2.size();
    }

    public boolean equals(Object other) {
        if (other instanceof Header) {
            Header that = (Header)other;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.name.hashCode();
        result2 = 31 * result2 + this.value.hashCode();
        return result2;
    }

    public String toString() {
        return Util.format("%s: %s", this.name.utf8(), this.value.utf8());
    }
}

