/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3;

import gg.essential.lib.okhttp3.internal.Util;
import gg.essential.lib.okhttp3.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        this.namesAndValues = builder.namesAndValues.toArray(new String[builder.namesAndValues.size()]);
    }

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    @Nullable
    public String get(String name) {
        return Headers.get(this.namesAndValues, name);
    }

    @Nullable
    public Date getDate(String name) {
        String value2 = this.get(name);
        return value2 != null ? HttpDate.parse(value2) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int index2) {
        return this.namesAndValues[index2 * 2];
    }

    public String value(int index2) {
        return this.namesAndValues[index2 * 2 + 1];
    }

    public Set<String> names() {
        TreeSet<String> result2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result2.add(this.name(i));
        }
        return Collections.unmodifiableSet(result2);
    }

    public List<String> values(String name) {
        ArrayList<String> result2 = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equalsIgnoreCase(this.name(i))) continue;
            if (result2 == null) {
                result2 = new ArrayList<String>(2);
            }
            result2.add(this.value(i));
        }
        return result2 != null ? Collections.unmodifiableList(result2) : Collections.emptyList();
    }

    public long byteCount() {
        long result2 = this.namesAndValues.length * 2;
        int size = this.namesAndValues.length;
        for (int i = 0; i < size; ++i) {
            result2 += (long)this.namesAndValues[i].length();
        }
        return result2;
    }

    public Builder newBuilder() {
        Builder result2 = new Builder();
        Collections.addAll(result2.namesAndValues, this.namesAndValues);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Headers && Arrays.equals(((Headers)other).namesAndValues, this.namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            result2.append(this.name(i)).append(": ").append(this.value(i)).append("\n");
        }
        return result2.toString();
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> result2 = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            String name = this.name(i).toLowerCase(Locale.US);
            ArrayList<String> values2 = (ArrayList<String>)result2.get(name);
            if (values2 == null) {
                values2 = new ArrayList<String>(2);
                result2.put(name, values2);
            }
            values2.add(this.value(i));
        }
        return result2;
    }

    private static String get(String[] namesAndValues, String name) {
        for (int i = namesAndValues.length - 2; i >= 0; i -= 2) {
            if (!name.equalsIgnoreCase(namesAndValues[i])) continue;
            return namesAndValues[i + 1];
        }
        return null;
    }

    public static Headers of(String ... namesAndValues) {
        int i;
        if (namesAndValues == null) {
            throw new NullPointerException("namesAndValues == null");
        }
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        namesAndValues = (String[])namesAndValues.clone();
        for (i = 0; i < namesAndValues.length; ++i) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            namesAndValues[i] = namesAndValues[i].trim();
        }
        for (i = 0; i < namesAndValues.length; i += 2) {
            String name = namesAndValues[i];
            String value2 = namesAndValues[i + 1];
            if (name.length() != 0 && name.indexOf(0) == -1 && value2.indexOf(0) == -1) continue;
            throw new IllegalArgumentException("Unexpected header: " + name + ": " + value2);
        }
        return new Headers(namesAndValues);
    }

    public static Headers of(Map<String, String> headers) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        String[] namesAndValues = new String[headers.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey() == null || header.getValue() == null) {
                throw new IllegalArgumentException("Headers cannot be null");
            }
            String name = header.getKey().trim();
            String value2 = header.getValue().trim();
            if (name.length() == 0 || name.indexOf(0) != -1 || value2.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected header: " + name + ": " + value2);
            }
            namesAndValues[i] = name;
            namesAndValues[i + 1] = value2;
            i += 2;
        }
        return new Headers(namesAndValues);
    }

    public static final class Builder {
        final List<String> namesAndValues = new ArrayList<String>(20);

        Builder addLenient(String line2) {
            int index2 = line2.indexOf(":", 1);
            if (index2 != -1) {
                return this.addLenient(line2.substring(0, index2), line2.substring(index2 + 1));
            }
            if (line2.startsWith(":")) {
                return this.addLenient("", line2.substring(1));
            }
            return this.addLenient("", line2);
        }

        public Builder add(String line2) {
            int index2 = line2.indexOf(":");
            if (index2 == -1) {
                throw new IllegalArgumentException("Unexpected header: " + line2);
            }
            return this.add(line2.substring(0, index2).trim(), line2.substring(index2 + 1));
        }

        public Builder add(String name, String value2) {
            this.checkNameAndValue(name, value2);
            return this.addLenient(name, value2);
        }

        Builder addLenient(String name, String value2) {
            this.namesAndValues.add(name);
            this.namesAndValues.add(value2.trim());
            return this;
        }

        public Builder removeAll(String name) {
            for (int i = 0; i < this.namesAndValues.size(); i += 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                this.namesAndValues.remove(i);
                this.namesAndValues.remove(i);
                i -= 2;
            }
            return this;
        }

        public Builder set(String name, String value2) {
            this.checkNameAndValue(name, value2);
            this.removeAll(name);
            this.addLenient(name, value2);
            return this;
        }

        private void checkNameAndValue(String name, String value2) {
            char c;
            int i;
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            int length = name.length();
            for (i = 0; i < length; ++i) {
                c = name.charAt(i);
                if (c > ' ' && c < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", c, i, name));
            }
            if (value2 == null) {
                throw new NullPointerException("value for name " + name + " == null");
            }
            length = value2.length();
            for (i = 0; i < length; ++i) {
                c = value2.charAt(i);
                if ((c > '\u001f' || c == '\t') && c < '\u007f') continue;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", c, i, name, value2));
            }
        }

        public String get(String name) {
            for (int i = this.namesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!name.equalsIgnoreCase(this.namesAndValues.get(i))) continue;
                return this.namesAndValues.get(i + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

