/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3;

import gg.essential.lib.okhttp3.internal.Util;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public final class Challenge {
    private final String scheme;
    private final String realm;
    private final Charset charset;

    public Challenge(String scheme, String realm) {
        this(scheme, realm, Util.ISO_8859_1);
    }

    private Challenge(String scheme, String realm, Charset charset) {
        if (scheme == null) {
            throw new NullPointerException("scheme == null");
        }
        if (realm == null) {
            throw new NullPointerException("realm == null");
        }
        if (charset == null) {
            throw new NullPointerException("charset == null");
        }
        this.scheme = scheme;
        this.realm = realm;
        this.charset = charset;
    }

    public Challenge withCharset(Charset charset) {
        return new Challenge(this.scheme, this.realm, charset);
    }

    public String scheme() {
        return this.scheme;
    }

    public String realm() {
        return this.realm;
    }

    public Charset charset() {
        return this.charset;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Challenge && ((Challenge)other).scheme.equals(this.scheme) && ((Challenge)other).realm.equals(this.realm) && ((Challenge)other).charset.equals(this.charset);
    }

    public int hashCode() {
        int result2 = 29;
        result2 = 31 * result2 + this.realm.hashCode();
        result2 = 31 * result2 + this.scheme.hashCode();
        result2 = 31 * result2 + this.charset.hashCode();
        return result2;
    }

    public String toString() {
        return this.scheme + " realm=\"" + this.realm + "\" charset=\"" + this.charset + "\"";
    }
}

