/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.injector;

import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class WrapWithConditionInjector
extends Injector {
    public WrapWithConditionInjector(InjectionInfo info) {
        super(info, "@WrapWithCondition");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node2) {
        this.checkTargetIsLogicallyVoid(target, node2);
        this.checkTargetModifiers(target, false);
        this.wrapTargetWithCondition(target, node2);
    }

    private void checkTargetIsLogicallyVoid(Target target, InjectionNodes.InjectionNode node2) {
        Type returnType = this.getReturnType(node2.getCurrentTarget());
        if (returnType == null) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target, this}));
        }
        if (returnType != Type.VOID_TYPE) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an instruction with a non-void return type in %s in %s", new Object[]{this.annotationType, target, this}));
        }
    }

    private void wrapTargetWithCondition(Target target, InjectionNodes.InjectionNode node2) {
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        Type[] originalArgTypes = this.getEffectiveArgTypes(node2.getOriginalTarget());
        Type[] currentArgTypes = this.getEffectiveArgTypes(currentTarget);
        InsnList before = new InsnList();
        InsnList after = new InsnList();
        boolean isVirtualRedirect = node2.hasDecoration("redirector") && currentTarget.getOpcode() != 184;
        this.invokeHandler(target, originalArgTypes, currentArgTypes, isVirtualRedirect, before, after);
        target.wrapNode(currentTarget, currentTarget, before, after);
    }

    private void invokeHandler(Target target, Type[] originalArgTypes, Type[] currentArgTypes, boolean isVirtualRedirect, InsnList before, InsnList after) {
        Injector.InjectorData handler = new Injector.InjectorData(target, "condition wrapper");
        this.validateParams(handler, Type.BOOLEAN_TYPE, originalArgTypes);
        int[] argMap = this.storeArgs(target, currentArgTypes, before, 0);
        int[] handlerArgMap = ArrayUtils.addAll((int[])argMap, (int[])target.getArgIndices());
        if (isVirtualRedirect) {
            handlerArgMap = ArrayUtils.remove((int[])handlerArgMap, (int)0);
        }
        this.invokeHandlerWithArgs(this.methodArgs, before, handlerArgMap);
        LabelNode jumpTarget = new LabelNode();
        before.add((AbstractInsnNode)new JumpInsnNode(153, jumpTarget));
        this.pushArgs(currentArgTypes, before, argMap, 0, argMap.length);
        after.add((AbstractInsnNode)jumpTarget);
    }

    private Type getReturnType(AbstractInsnNode node2) {
        if (node2 instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node2;
            return Type.getReturnType((String)methodInsnNode.desc);
        }
        if (node2 instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)node2;
            if (fieldInsnNode.getOpcode() == 180 || fieldInsnNode.getOpcode() == 178) {
                return Type.getType((String)fieldInsnNode.desc);
            }
            return Type.VOID_TYPE;
        }
        return null;
    }

    private Type[] getEffectiveArgTypes(AbstractInsnNode node2) {
        if (node2 instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node2;
            return node2.getOpcode() == 184 ? Type.getArgumentTypes((String)methodInsnNode.desc) : (Type[])ArrayUtils.addAll((Object[])new Type[]{Type.getObjectType((String)methodInsnNode.owner)}, (Object[])Type.getArgumentTypes((String)methodInsnNode.desc));
        }
        if (node2 instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)node2;
            if (fieldInsnNode.getOpcode() == 181) {
                return new Type[]{Type.getObjectType((String)fieldInsnNode.owner), Type.getType((String)fieldInsnNode.desc)};
            }
            if (fieldInsnNode.getOpcode() == 179) {
                return new Type[]{Type.getType((String)fieldInsnNode.desc)};
            }
        }
        throw new UnsupportedOperationException();
    }
}

