/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.injector;

import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class ModifyReceiverInjector
extends Injector {
    public ModifyReceiverInjector(InjectionInfo info) {
        super(info, "@ModifyReceiver");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node2) {
        this.checkTargetIsValid(target, node2);
        this.checkTargetModifiers(target, false);
        this.modifyReceiverOfTarget(target, node2);
    }

    private void checkTargetIsValid(Target target, InjectionNodes.InjectionNode node2) {
        AbstractInsnNode insn = node2.getOriginalTarget();
        switch (insn.getOpcode()) {
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 185: {
                return;
            }
        }
        throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target, this}));
    }

    private void modifyReceiverOfTarget(Target target, InjectionNodes.InjectionNode node2) {
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        Type[] originalArgTypes = this.getEffectiveArgTypes(node2.getOriginalTarget());
        Type[] currentArgTypes = this.getEffectiveArgTypes(currentTarget);
        InsnList insns = new InsnList();
        boolean isVirtualRedirect = node2.hasDecoration("redirector") && currentTarget.getOpcode() != 184;
        this.injectReceiverModifier(target, originalArgTypes, currentArgTypes, isVirtualRedirect, insns);
        target.insertBefore(node2, insns);
    }

    private void injectReceiverModifier(Target target, Type[] originalArgTypes, Type[] currentArgTypes, boolean isVirtualRedirect, InsnList insns) {
        Injector.InjectorData handler = new Injector.InjectorData(target, "receiver modifier");
        this.validateParams(handler, originalArgTypes[0], originalArgTypes);
        int[] argMap = this.storeArgs(target, currentArgTypes, insns, 0);
        int[] handlerArgMap = ArrayUtils.addAll((int[])argMap, (int[])target.getArgIndices());
        if (isVirtualRedirect) {
            handlerArgMap = ArrayUtils.remove((int[])handlerArgMap, (int)0);
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        this.invokeHandlerWithArgs(this.methodArgs, insns, handlerArgMap);
        this.pushArgs(currentArgTypes, insns, argMap, isVirtualRedirect ? 2 : 1, argMap.length);
    }

    private Type[] getEffectiveArgTypes(AbstractInsnNode node2) {
        switch (node2.getOpcode()) {
            case 182: 
            case 183: 
            case 185: {
                MethodInsnNode methodInsnNode = (MethodInsnNode)node2;
                return (Type[])ArrayUtils.addAll((Object[])new Type[]{Type.getObjectType((String)methodInsnNode.owner)}, (Object[])Type.getArgumentTypes((String)methodInsnNode.desc));
            }
            case 180: {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)node2;
                return new Type[]{Type.getObjectType((String)fieldInsnNode.owner)};
            }
            case 181: {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)node2;
                return new Type[]{Type.getObjectType((String)fieldInsnNode.owner), Type.getType((String)fieldInsnNode.desc)};
            }
        }
        throw new UnsupportedOperationException();
    }
}

