/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.injector;

import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

public class ModifyExpressionValueInjector
extends Injector {
    public ModifyExpressionValueInjector(InjectionInfo info) {
        super(info, "@ModifyExpressionValue");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node2) {
        this.checkTargetReturnsAValue(target, node2);
        this.checkTargetModifiers(target, false);
        this.injectValueModifier(target, node2.getCurrentTarget());
    }

    private void checkTargetReturnsAValue(Target target, InjectionNodes.InjectionNode node2) {
        Type returnType = this.getReturnType(node2.getCurrentTarget());
        if (returnType == Type.VOID_TYPE) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an instruction with a return type of 'void' in %s in %s", new Object[]{this.annotationType, target, this}));
        }
        if (returnType == null) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target, this}));
        }
    }

    private void injectValueModifier(Target target, AbstractInsnNode valueNode) {
        Target.Extension extraStack = target.extendStack();
        InsnList after = new InsnList();
        this.invokeHandler(this.getReturnType(valueNode), target, extraStack, after);
        extraStack.apply();
        target.insns.insert(valueNode, after);
    }

    private void invokeHandler(Type valueType, Target target, Target.Extension extraStack, InsnList after) {
        Injector.InjectorData handler = new Injector.InjectorData(target, "expression value modifier");
        this.validateParams(handler, valueType, new Type[]{valueType});
        if (!this.isStatic) {
            after.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (valueType.getSize() == 2) {
                after.add((AbstractInsnNode)new InsnNode(91));
                after.add((AbstractInsnNode)new InsnNode(87));
            } else {
                after.add((AbstractInsnNode)new InsnNode(95));
            }
        }
        if (handler.captureTargetArgs > 0) {
            this.pushArgs(target.arguments, after, target.getArgIndices(), 0, handler.captureTargetArgs, extraStack);
        }
        this.invokeHandler(after);
    }

    private Type getReturnType(AbstractInsnNode node2) {
        if (node2 instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node2;
            return Type.getReturnType((String)methodInsnNode.desc);
        }
        if (node2 instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)node2;
            if (fieldInsnNode.getOpcode() == 180 || fieldInsnNode.getOpcode() == 178) {
                return Type.getType((String)fieldInsnNode.desc);
            }
            return Type.VOID_TYPE;
        }
        if (Bytecode.isConstant((AbstractInsnNode)node2)) {
            return Bytecode.getConstantType((AbstractInsnNode)node2);
        }
        return null;
    }
}

