/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.kbrewster.mojangapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.essential.lib.kbrewster.API;
import gg.essential.lib.kbrewster.exceptions.APIException;
import gg.essential.lib.kbrewster.exceptions.InvalidPlayerException;
import gg.essential.lib.kbrewster.mojangapi.authentication.AuthenticatedUser;
import gg.essential.lib.kbrewster.mojangapi.profile.Model;
import gg.essential.lib.kbrewster.mojangapi.profile.Name;
import gg.essential.lib.kbrewster.mojangapi.profile.Profile;
import gg.essential.lib.kbrewster.mojangapi.stats.MetricKeys;
import gg.essential.lib.kbrewster.mojangapi.stats.MojangStatistics;
import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.MultipartBody;
import gg.essential.lib.okhttp3.OkHttpClient;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;

@API.Reference(apiName="Mojang API", apiVersion="1.5")
public class MojangAPI
extends API {
    private static final String BASE_URL = "https://api.mojang.com";
    private static final String STATUS_URL = "https://status.mojang.com/check";
    private static final Pattern STRIPPED_UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final Pattern UUID_PATTERN = Pattern.compile("(\\w{8})-(\\w{4})-(\\w{4})-(\\w{4})-(\\w{12})");

    public static Map<String, String> getStatus() throws IOException {
        TreeMap<String, String> map2 = new TreeMap<String, String>();
        String json2 = MojangAPI.sendGet(STATUS_URL);
        JsonArray status = new JsonParser().parse(json2).getAsJsonArray();
        for (JsonElement element : status) {
            JsonObject obj = element.getAsJsonObject();
            obj.entrySet().forEach(s -> map2.put((String)s.getKey(), ((JsonElement)s.getValue()).getAsString()));
        }
        return map2;
    }

    public static Profile getProfile(UUID uuid) throws IOException, APIException {
        String json2 = MojangAPI.sendGet("https://sessionserver.mojang.com/session/minecraft/profile/" + MojangAPI.stripDashes(uuid));
        JsonElement jsonElement = new JsonParser().parse(json2);
        if (jsonElement.isJsonNull()) {
            throw new APIException("This shouldn't happen");
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.get("error") instanceof JsonNull) {
            throw new APIException(jsonObject.get("errorMessage").getAsString());
        }
        return (Profile)new Gson().fromJson((JsonElement)jsonObject, Profile.class);
    }

    public static String getName(UUID uuid) throws IOException, APIException {
        ArrayList<Name> names = MojangAPI.getNameHistory(uuid);
        if (names.size() == 0) {
            return uuid.toString();
        }
        return names.get(names.size() - 1).getName();
    }

    public static String getUsername(UUID uuid) throws IOException, APIException {
        return MojangAPI.getProfile(uuid).getName();
    }

    public static String stripDashes(String uuid) {
        return uuid.replaceAll("-", "");
    }

    public static String stripDashes(UUID uuid) {
        return MojangAPI.stripDashes(uuid.toString());
    }

    public static String addDashes(String uuid) {
        return STRIPPED_UUID_PATTERN.matcher(uuid).replaceAll("$1-$2-$3-$4-$5");
    }

    public static ArrayList<Name> getNameHistory(String username) throws IOException, APIException {
        UUID uuid = MojangAPI.getUUID(username);
        return MojangAPI.getNameHistory(uuid);
    }

    public static ArrayList<Name> getNameHistory(UUID uuid) {
        Gson gson = new Gson();
        ArrayList<Name> names = new ArrayList<Name>();
        try {
            String json2 = MojangAPI.sendGet(String.format("https://api.mojang.com/user/profiles/%s/names", MojangAPI.stripDashes(uuid)));
            JsonElement parser = new JsonParser().parse(json2);
            if (json2.isEmpty()) {
                throw new InvalidPlayerException();
            }
            if (!parser.isJsonArray()) {
                return names;
            }
            JsonArray arrayNames = parser.getAsJsonArray();
            arrayNames.forEach(obj -> {
                Name name = (Name)gson.fromJson(obj, Name.class);
                names.add(name);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return names;
    }

    public static UUID getUUID(String username) throws IOException, APIException, InvalidPlayerException {
        String json2 = MojangAPI.sendGet("https://api.mojang.com/users/profiles/minecraft/" + username);
        JsonElement parse2 = new JsonParser().parse(json2);
        if (parse2.isJsonNull()) {
            throw new InvalidPlayerException();
        }
        JsonObject obj = parse2.getAsJsonObject();
        if (obj.get("error") instanceof JsonNull) {
            throw new APIException(obj.get("errorMessage").getAsString());
        }
        return UUID.fromString(MojangAPI.addDashes(obj.get("id").getAsString()));
    }

    public static List<UUID> getUUIDs(List<String> usernames) throws IOException, APIException, InvalidPlayerException {
        String names = usernames.toString().replace("[", "[\"").replace(", ", "\", \"").replace("]", "\"]");
        System.out.println(names);
        String json2 = MojangAPI.sendPost("https://api.mojang.com/profiles/minecraft", names);
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        JsonElement parse2 = new JsonParser().parse(json2);
        for (JsonElement element : parse2.getAsJsonArray()) {
            if (parse2.isJsonNull()) {
                throw new InvalidPlayerException();
            }
            JsonObject obj = element.getAsJsonObject();
            uuids.add(UUID.fromString(MojangAPI.addDashes(obj.get("id").getAsString())));
        }
        return uuids;
    }

    public static List<UUID> getUUIDs(String ... usernames) throws IOException, APIException, InvalidPlayerException {
        String names = Arrays.toString(usernames).replace("[", "[\"").replace(", ", "\", \"").replace("]", "\"]");
        System.out.println(names);
        String json2 = MojangAPI.sendPost("https://api.mojang.com/profiles/minecraft", names);
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        JsonElement parse2 = new JsonParser().parse(json2);
        for (JsonElement element : parse2.getAsJsonArray()) {
            if (parse2.isJsonNull()) {
                throw new InvalidPlayerException();
            }
            JsonObject obj = element.getAsJsonObject();
            uuids.add(UUID.fromString(MojangAPI.addDashes(obj.get("id").getAsString())));
        }
        return uuids;
    }

    public static MojangStatistics getStatistics(MetricKeys key) throws IOException {
        String json2 = MojangAPI.sendPost("https://api.mojang.com/orders/statistics", "{\"metricKeys\": [\"" + key.getKey() + "\"]}");
        JsonElement obj = new JsonParser().parse(json2);
        return (MojangStatistics)new Gson().fromJson(obj, MojangStatistics.class);
    }

    public static void resetSkin(String sessionid, UUID uuid) throws IOException, APIException {
        Request request = new Request.Builder().url("https://api.mojang.com/user/profile/" + MojangAPI.stripDashes(uuid) + "/skin").header("Authorization", "Bearer " + sessionid).delete().build();
        String output = new OkHttpClient().newCall(request).execute().body().string();
        if (!output.isEmpty()) {
            throw new APIException(output);
        }
    }

    public static void changeSkin(String accessToken, UUID uuid, Model model, String url) throws IOException, APIException {
        String payload = String.format("model=%s&url=%s", model.getModel(), url);
        MediaType MEDIA_TYPE = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(MEDIA_TYPE, payload);
        Request request = new Request.Builder().url("https://api.mojang.com/user/profile/" + MojangAPI.stripDashes(uuid) + "/skin").header("Authorization", "Bearer " + accessToken).post(body).build();
        String output = new OkHttpClient().newCall(request).execute().body().string();
        if (!output.isEmpty()) {
            throw new APIException(output);
        }
    }

    public static void uploadSkin(String accessToken, UUID uuid, Model model, File file) throws IOException, APIException {
        MultipartBody body = new MultipartBody.Builder().addFormDataPart("file", file.getName(), RequestBody.create(MediaType.parse("image/jpeg"), file)).addFormDataPart("model", model.getModel()).build();
        Request request = new Request.Builder().url("https://api.mojang.com/user/profile/" + MojangAPI.stripDashes(uuid) + "/skin").header("Authorization", "Bearer " + accessToken).put(body).build();
        String output = new OkHttpClient().newCall(request).execute().body().string();
        if (!output.isEmpty()) {
            throw new APIException(output);
        }
    }

    public static AuthenticatedUser authenticate(String username, String password, String token, boolean requestUser) throws IOException, APIException {
        String response2;
        JsonObject json2;
        JsonObject payload = new JsonObject();
        JsonObject agent = new JsonObject();
        agent.addProperty("name", "minecraft");
        agent.addProperty("version", (Number)1);
        payload.add("agent", (JsonElement)agent);
        payload.addProperty("username", username);
        payload.addProperty("password", password);
        if (token != null) {
            payload.addProperty("clientToken", token);
        }
        if (requestUser) {
            payload.addProperty("requestUser", Boolean.valueOf(true));
        }
        if ((json2 = new JsonParser().parse(response2 = MojangAPI.sendPost("https://authserver.mojang.com/authenticate", payload.toString())).getAsJsonObject()).get("error") instanceof JsonNull) {
            throw new APIException(json2.get("errorMessage").getAsString());
        }
        return (AuthenticatedUser)new Gson().fromJson((JsonElement)json2, AuthenticatedUser.class);
    }

    public static void resetSkin(String accessToken, String username) throws IOException, APIException {
        MojangAPI.resetSkin(accessToken, MojangAPI.getUUID(username));
    }

    public static void changeSkin(String accessToken, String username, Model model, String url) throws IOException, APIException {
        MojangAPI.changeSkin(accessToken, MojangAPI.getUUID(username), model, url);
    }

    public static void uploadSkin(String accessToken, String username, Model model, File skin) throws IOException, APIException {
        MojangAPI.uploadSkin(accessToken, MojangAPI.getUUID(username), model, skin);
    }

    public static AuthenticatedUser authenticate(String username, String password, boolean requestUser) throws IOException, APIException {
        return MojangAPI.authenticate(username, password, null, requestUser);
    }

    public static Profile getProfile(String username) throws IOException, APIException {
        return MojangAPI.getProfile(MojangAPI.getUUID(username));
    }
}

