/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.kbrewster.eventbus;

import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.lib.kbrewster.eventbus.collection.ConcurrentSubscriberArrayList;
import gg.essential.lib.kbrewster.eventbus.collection.SubscriberArrayList;
import gg.essential.lib.kbrewster.eventbus.exception.ExceptionHandler;
import gg.essential.lib.kbrewster.eventbus.invokers.InvokerType;
import gg.essential.lib.kbrewster.eventbus.invokers.ReflectionInvoker;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventBus {
    private final AbstractMap<Class<?>, List<Subscriber>> subscribers;
    private final InvokerType invokerType;
    private final ExceptionHandler exceptionHandler;
    private final boolean threadSaftey;

    public final void register(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        for (Method method : obj.getClass().getDeclaredMethods()) {
            Subscribe sub;
            if (method.getAnnotation(Subscribe.class) == null) {
                continue;
            }
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull(method2, "method");
            Class<?> parameterClazz = method2.getParameterTypes()[0];
            if (method.getParameterCount() != 1) {
                throw (Throwable)new IllegalArgumentException("Subscribed method must only have one parameter.");
            }
            if (Intrinsics.areEqual(method.getReturnType(), Void.TYPE) ^ true) {
                throw (Throwable)new IllegalArgumentException("Subscribed method must be of type 'Void'. ");
            }
            Class<?> clazz = parameterClazz;
            Intrinsics.checkExpressionValueIsNotNull(clazz, "parameterClazz");
            if (clazz.isPrimitive()) {
                throw (Throwable)new IllegalArgumentException("Cannot subscribe method to a primitive.");
            }
            if ((parameterClazz.getModifiers() & 0x600) != 0) {
                throw (Throwable)new IllegalArgumentException("Cannot subscribe method to a polymorphic class.");
            }
            InvokerType.SubscriberMethod subscriberMethod = this.invokerType.setup(obj, obj.getClass(), parameterClazz, method);
            Subscriber subscriber = new Subscriber(obj, sub.priority(), subscriberMethod);
            this.subscribers.putIfAbsent(parameterClazz, this.threadSaftey ? (List)new ConcurrentSubscriberArrayList() : (List)new SubscriberArrayList());
            List<Subscriber> list = this.subscribers.get(parameterClazz);
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(subscriber);
        }
    }

    public final void unregister(@NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        for (Method method : obj.getClass().getDeclaredMethods()) {
            if (method.getAnnotation(Subscribe.class) == null) continue;
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull(method2, "method");
            List<Subscriber> list = this.subscribers.get(method2.getParameterTypes()[0]);
            if (list == null) continue;
            list.remove(new Subscriber(obj, -1, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void post(@NotNull Object event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        List<Subscriber> list = this.subscribers.get(event.getClass());
        if (list == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(list, "subscribers[event.javaClass] ?: return");
        List<Subscriber> events = list;
        int n = events.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            try {
                events.get((int)i).invoke(event);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e);
            }
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> void post(@NotNull Function0<? extends T> supplier) {
        int $i$f$post = 0;
        Intrinsics.checkParameterIsNotNull(supplier, "supplier");
        Intrinsics.reifiedOperationMarker(4, "T");
        List<Subscriber> list = this.getSubscribedEvents(Object.class);
        if (list == null) {
            return;
        }
        List<Subscriber> events = list;
        T event = supplier.invoke();
        int n = events.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            events.get((int)i).invoke(event);
            --i;
        }
    }

    @Nullable
    public final List<Subscriber> getSubscribedEvents(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        return this.subscribers.get(clazz);
    }

    private final void iterateSubclasses(Object obj, Function1<? super Class<?>, Unit> body) {
        int $i$f$iterateSubclasses = 0;
        Class<?> postClazz = obj.getClass();
        do {
            Class<?> clazz = postClazz;
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            body.invoke(clazz);
        } while ((postClazz = postClazz.getSuperclass()) != null);
    }

    @JvmOverloads
    public EventBus(@NotNull InvokerType invokerType, @NotNull ExceptionHandler exceptionHandler2, boolean threadSaftey) {
        Intrinsics.checkParameterIsNotNull(invokerType, "invokerType");
        Intrinsics.checkParameterIsNotNull(exceptionHandler2, "exceptionHandler");
        this.invokerType = invokerType;
        this.exceptionHandler = exceptionHandler2;
        this.threadSaftey = threadSaftey;
        this.subscribers = this.threadSaftey ? (AbstractMap)new ConcurrentHashMap() : (AbstractMap)new HashMap();
    }

    public /* synthetic */ EventBus(InvokerType invokerType, ExceptionHandler exceptionHandler2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            invokerType = new ReflectionInvoker();
        }
        if ((n & 2) != 0) {
            exceptionHandler2 = new ExceptionHandler(){

                @Override
                public void handle(@NotNull Exception exception) {
                    Intrinsics.checkParameterIsNotNull(exception, "exception");
                    throw (Throwable)exception;
                }
            };
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(invokerType, exceptionHandler2, bl);
    }

    @JvmOverloads
    public EventBus(@NotNull InvokerType invokerType, @NotNull ExceptionHandler exceptionHandler2) {
        this(invokerType, exceptionHandler2, false, 4, null);
    }

    @JvmOverloads
    public EventBus(@NotNull InvokerType invokerType) {
        this(invokerType, null, false, 6, null);
    }

    @JvmOverloads
    public EventBus() {
        this(null, null, false, 7, null);
    }

    public static final class Subscriber {
        @NotNull
        private final Object obj;
        private final int priority;
        private final InvokerType.SubscriberMethod invoker;

        public final void invoke(@Nullable Object arg) throws Exception {
            InvokerType.SubscriberMethod subscriberMethod = this.invoker;
            if (subscriberMethod == null) {
                Intrinsics.throwNpe();
            }
            subscriberMethod.invoke(arg);
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            boolean bl = false;
            Object object2 = object;
            return (object2 != null ? object2.hashCode() : 0) == this.hashCode();
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        @NotNull
        public final Object getObj() {
            return this.obj;
        }

        public final int getPriority() {
            return this.priority;
        }

        public Subscriber(@NotNull Object obj, int priority, @Nullable InvokerType.SubscriberMethod invoker) {
            Intrinsics.checkParameterIsNotNull(obj, "obj");
            this.obj = obj;
            this.priority = priority;
            this.invoker = invoker;
        }
    }
}

