/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.kbrewster;

import gg.essential.lib.okhttp3.MediaType;
import gg.essential.lib.okhttp3.OkHttpClient;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.RequestBody;
import gg.essential.lib.okhttp3.Response;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Reference(apiName="API", apiVersion="1.5")
public abstract class API {
    private static String apiName = API.class.getAnnotation(Reference.class).apiName();
    private static String apiVersion = API.class.getAnnotation(Reference.class).apiVersion();
    private static OkHttpClient client = new OkHttpClient();

    protected static String sendGet(String url, String contentType) throws IOException {
        Request request = new Request.Builder().url(url).header("User-Agent", contentType).build();
        Response response2 = client.newCall(request).execute();
        return response2.body().string();
    }

    protected static String sendGet(String url) throws IOException {
        return API.sendGet(url, "application/json");
    }

    protected static String sendPost(String url, String payload, String contentType) throws IOException {
        MediaType MEDIA_TYPE = MediaType.parse(contentType);
        RequestBody body = RequestBody.create(MEDIA_TYPE, payload);
        Request request = new Request.Builder().url(url).post(body).build();
        Response response2 = client.newCall(request).execute();
        return response2.body().string();
    }

    protected static String sendPost(String url, String payload) throws IOException {
        return API.sendPost(url, payload, "application/json");
    }

    public static String getApiName() {
        return apiName;
    }

    public static String getApiVersion() {
        return apiVersion;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Reference {
        public String apiName();

        public String apiVersion();
    }
}

