/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.stats;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u0001\u001eB/\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u0010\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R*\u0010\u0015\u001a\u0018\u0012\u000e\u0012\f0\u0013R\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u00140\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0012R$\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f0\u0013R\b\u0012\u0004\u0012\u00028\u00000\u00000\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lgg/essential/lib/jitsi/utils/stats/TimeBasedSlidingWindow;", "", "T", "value", "", "add", "(Ljava/lang/Object;)V", "evict", "()V", "forceEviction", "", "values", "()Ljava/util/Collection;", "Ljava/time/Clock;", "clock", "Ljava/time/Clock;", "Lkotlin/Function1;", "evictionHandler", "Lkotlin/jvm/functions/Function1;", "Lgg/essential/lib/jitsi/utils/stats/TimeBasedSlidingWindow$TimeEntry;", "", "evictionPredicate", "Ljava/util/ArrayDeque;", "queue", "Ljava/util/ArrayDeque;", "Ljava/time/Duration;", "windowSize", "Ljava/time/Duration;", "<init>", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function1;Ljava/time/Clock;)V", "TimeEntry", "jitsi-utils"})
public class TimeBasedSlidingWindow<T> {
    @NotNull
    private final Duration windowSize;
    @NotNull
    private final Function1<T, Unit> evictionHandler;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ArrayDeque<TimeEntry> queue;
    @NotNull
    private final Function1<TimeEntry, Boolean> evictionPredicate;

    public TimeBasedSlidingWindow(@NotNull Duration windowSize, @NotNull Function1<? super T, Unit> evictionHandler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(windowSize, "windowSize");
        Intrinsics.checkNotNullParameter(evictionHandler, "evictionHandler");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.windowSize = windowSize;
        this.evictionHandler = evictionHandler;
        this.clock = clock;
        this.queue = new ArrayDeque();
        this.evictionPredicate = new Function1<TimeEntry, Boolean>(this){
            final /* synthetic */ TimeBasedSlidingWindow<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TimeEntry entry) {
                Intrinsics.checkNotNullParameter(entry, "entry");
                return Duration.between(entry.getInsertionTime(), TimeBasedSlidingWindow.access$getClock$p(this.this$0).instant()).compareTo(TimeBasedSlidingWindow.access$getWindowSize$p(this.this$0)) > 0;
            }
        };
    }

    public /* synthetic */ TimeBasedSlidingWindow(Duration duration, Function1 function1, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(duration, function1, clock);
    }

    public final void add(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.queue.addFirst(new TimeEntry(value2));
        this.evict();
    }

    public final void forceEviction() {
        this.evict();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<T> values() {
        void $this$mapTo$iv$iv;
        this.evict();
        Iterable $this$map$iv = CollectionsKt.reversed((Iterable)this.queue);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TimeEntry timeEntry = (TimeEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.getValue();
            collection.add(t);
        }
        return (List)destination$iv$iv;
    }

    private final void evict() {
        while (true) {
            Object object = this.queue;
            boolean bl = false;
            if (!(!object.isEmpty())) break;
            object = this.queue.getLast();
            Intrinsics.checkNotNullExpressionValue(object, "queue.last");
            if (!this.evictionPredicate.invoke((TimeEntry)object).booleanValue()) break;
            this.evictionHandler.invoke(this.queue.getLast().getValue());
            this.queue.removeLast();
        }
    }

    public static final /* synthetic */ Duration access$getWindowSize$p(TimeBasedSlidingWindow $this) {
        return $this.windowSize;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fB\u0017\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lgg/essential/lib/jitsi/utils/stats/TimeBasedSlidingWindow$TimeEntry;", "", "Ljava/time/Instant;", "insertionTime", "Ljava/time/Instant;", "getInsertionTime", "()Ljava/time/Instant;", "value", "Ljava/lang/Object;", "getValue", "()Ljava/lang/Object;", "<init>", "(Lorg/jitsi/utils/stats/TimeBasedSlidingWindow;Ljava/lang/Object;)V", "(Lorg/jitsi/utils/stats/TimeBasedSlidingWindow;Ljava/lang/Object;Ljava/time/Instant;)V", "jitsi-utils"})
    public final class TimeEntry {
        @NotNull
        private final T value;
        @NotNull
        private final Instant insertionTime;

        public TimeEntry(@NotNull T value2, Instant insertionTime) {
            Intrinsics.checkNotNullParameter(TimeBasedSlidingWindow.this, "this$0");
            Intrinsics.checkNotNullParameter(value2, "value");
            Intrinsics.checkNotNullParameter(insertionTime, "insertionTime");
            this.value = value2;
            this.insertionTime = insertionTime;
        }

        @NotNull
        public final T getValue() {
            return this.value;
        }

        @NotNull
        public final Instant getInsertionTime() {
            return this.insertionTime;
        }

        public TimeEntry(T value2) {
            Intrinsics.checkNotNullParameter(TimeBasedSlidingWindow.this, "this$0");
            Intrinsics.checkNotNullParameter(value2, "value");
            Instant instant = TimeBasedSlidingWindow.this.clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
            this(value2, instant);
        }
    }
}

