/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.stats;

import gg.essential.lib.jitsi.utils.stats.TimeBasedSlidingWindow;
import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B\u001b\b\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0007R\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lgg/essential/lib/jitsi/utils/stats/MovingAverage;", "", "T", "", "value", "", "add", "(Ljava/lang/Number;)V", "", "get", "()D", "onEviction", "", "currSum", "J", "", "numElements", "I", "Lgg/essential/lib/jitsi/utils/stats/TimeBasedSlidingWindow;", "slidingWindow", "Lgg/essential/lib/jitsi/utils/stats/TimeBasedSlidingWindow;", "Ljava/time/Duration;", "windowSize", "Ljava/time/Clock;", "clock", "<init>", "(Ljava/time/Duration;Ljava/time/Clock;)V", "jitsi-utils"})
public final class MovingAverage<T extends Number> {
    @NotNull
    private final TimeBasedSlidingWindow<T> slidingWindow;
    private long currSum;
    private int numElements;

    @JvmOverloads
    public MovingAverage(@NotNull Duration windowSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(windowSize, "windowSize");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.slidingWindow = new TimeBasedSlidingWindow(windowSize, new Function1<T, Unit>(this){

            public final void invoke(@NotNull T p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                MovingAverage.access$onEviction((MovingAverage)this.receiver, p0);
            }
        }, clock);
    }

    public /* synthetic */ MovingAverage(Duration duration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(duration, clock);
    }

    public final synchronized double get() {
        this.slidingWindow.forceEviction();
        if (this.numElements == 0) {
            return 0.0;
        }
        return (double)this.currSum / (double)this.numElements;
    }

    public final synchronized void add(@NotNull T value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.slidingWindow.add(value2);
        MovingAverage movingAverage = this;
        movingAverage.currSum += ((Number)value2).longValue();
        movingAverage = this;
        int n = movingAverage.numElements;
        movingAverage.numElements = n + 1;
    }

    private final synchronized void onEviction(T value2) {
        MovingAverage movingAverage = this;
        movingAverage.currSum -= ((Number)value2).longValue();
        movingAverage = this;
        int n = movingAverage.numElements;
        movingAverage.numElements = n + -1;
    }

    @JvmOverloads
    public MovingAverage(@NotNull Duration windowSize) {
        Intrinsics.checkNotNullParameter(windowSize, "windowSize");
        this(windowSize, null, 2, null);
    }

    public static final /* synthetic */ void access$onEviction(MovingAverage $this, Number value2) {
        $this.onEviction(value2);
    }
}

