/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongSpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lgg/essential/lib/jitsi/utils/stats/Buckets;", "", "", "value", "", "addValue", "(J)V", "Ljava/util/concurrent/atomic/LongAdder;", "findBucket", "(J)Ljava/util/concurrent/atomic/LongAdder;", "Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "getSnapshot", "()Lorg/jitsi/utils/stats/Buckets$Snapshot;", "snapshot", "", "thresholdCounts", "[Ljava/util/concurrent/atomic/LongAdder;", "", "thresholds", "[J", "thresholdsNoMax", "<init>", "([J)V", "Snapshot", "jitsi-utils"})
public final class Buckets {
    @NotNull
    private final long[] thresholds;
    @NotNull
    private final LongAdder[] thresholdCounts;

    public Buckets(@NotNull long[] thresholdsNoMax) {
        Intrinsics.checkNotNullParameter(thresholdsNoMax, "thresholdsNoMax");
        LongSpreadBuilder longSpreadBuilder = new LongSpreadBuilder(2);
        longSpreadBuilder.addSpread(thresholdsNoMax);
        longSpreadBuilder.add(Long.MAX_VALUE);
        this.thresholds = longSpreadBuilder.toArray();
        int n = 0;
        int n2 = this.thresholds.length + 1;
        LongAdder[] longAdderArray = new LongAdder[n2];
        Buckets buckets = this;
        while (n < n2) {
            int n3 = n++;
            longAdderArray[n3] = new LongAdder();
        }
        buckets.thresholdCounts = longAdderArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Snapshot getSnapshot() {
        void $this$mapTo$iv$iv;
        int n = 0;
        int n2 = this.thresholds.length;
        Pair[] pairArray = new Pair[n2];
        while (n < n2) {
            int n3 = n++;
            pairArray[n3] = new Pair<Long, Long>(this.thresholds[n3], this.thresholdCounts[n3].sum());
        }
        Pair[] bucketCounts = pairArray;
        long p99 = 0L;
        p99 = Long.MAX_VALUE;
        long p999 = 0L;
        p999 = Long.MAX_VALUE;
        long sum = 0L;
        Pair[] $this$map$iv = bucketCounts;
        boolean $i$f$map = false;
        Pair[] pairArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var12_16 = $this$mapTo$iv$iv;
        int n4 = ((void)var12_16).length;
        for (int i = 0; i < n4; ++i) {
            void it;
            void item$iv$iv;
            void var16_21 = item$iv$iv = var12_16[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = ((Number)it.getSecond()).longValue();
            collection.add(l);
        }
        long totalCount = CollectionsKt.sumOfLong((List)destination$iv$iv);
        Pair[] $this$forEach$iv = bucketCounts;
        boolean $i$f$forEach = false;
        pairArray2 = $this$forEach$iv;
        int n5 = pairArray2.length;
        for (int i = 0; i < n5; ++i) {
            Pair element$iv;
            Pair it = element$iv = pairArray2[i];
            boolean bl = false;
            sum += ((Number)it.getSecond()).longValue();
            if (((Number)it.getFirst()).longValue() < p99 && (double)sum > 0.99 * (double)totalCount) {
                p99 = ((Number)it.getFirst()).longValue();
            }
            if (((Number)it.getFirst()).longValue() >= p999 || !((double)sum > 0.999 * (double)totalCount)) continue;
            p999 = ((Number)it.getFirst()).longValue();
        }
        if (totalCount < 100L || p99 == Long.MAX_VALUE) {
            p99 = -1L;
        }
        if (totalCount < 1000L || p999 == Long.MAX_VALUE) {
            p999 = -1L;
        }
        return new Snapshot(bucketCounts, p99, p999);
    }

    private final LongAdder findBucket(long value2) {
        int n = 0;
        int n2 = this.thresholds.length + -1;
        if (n <= n2) {
            do {
                int i;
                if (value2 > this.thresholds[i = n++]) continue;
                return this.thresholdCounts[i];
            } while (n <= n2);
        }
        return ArraysKt.last(this.thresholdCounts);
    }

    public final void addValue(long value2) {
        this.findBucket(value2).increment();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\"\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ@\u0010\r\u001a\u00020\u00002\u001a\b\u0002\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R)\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0019\u001a\u0004\b\u001a\u0010\u0006R\u0017\u0010\f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001b\u001a\u0004\b\u001c\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001b\u001a\u0004\b\u001d\u0010\b\u00a8\u0006 "}, d2={"Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "", "", "Lkotlin/Pair;", "", "component1", "()[Lkotlin/Pair;", "component2", "()J", "component3", "buckets", "p99bound", "p999bound", "copy", "([Lkotlin/Pair;JJ)Lorg/jitsi/utils/stats/Buckets$Snapshot;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "[Lkotlin/Pair;", "getBuckets", "J", "getP999bound", "getP99bound", "<init>", "([Lkotlin/Pair;JJ)V", "jitsi-utils"})
    public static final class Snapshot {
        @NotNull
        private final Pair<Long, Long>[] buckets;
        private final long p99bound;
        private final long p999bound;

        public Snapshot(@NotNull Pair<Long, Long>[] buckets, long p99bound, long p999bound) {
            Intrinsics.checkNotNullParameter(buckets, "buckets");
            this.buckets = buckets;
            this.p99bound = p99bound;
            this.p999bound = p999bound;
        }

        @NotNull
        public final Pair<Long, Long>[] getBuckets() {
            return this.buckets;
        }

        public final long getP99bound() {
            return this.p99bound;
        }

        public final long getP999bound() {
            return this.p999bound;
        }

        public boolean equals(@Nullable Object other) {
            Object[] objectArray;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (objectArray = other) == null ? null : objectArray.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jitsi.utils.stats.Buckets.Snapshot");
            }
            Snapshot cfr_ignored_0 = (Snapshot)other;
            objectArray = this.buckets;
            Object[] objectArray2 = ((Snapshot)other).buckets;
            boolean bl = false;
            return Arrays.equals(objectArray, objectArray2);
        }

        public int hashCode() {
            Object[] objectArray = this.buckets;
            boolean bl = false;
            return Arrays.hashCode(objectArray);
        }

        @NotNull
        public final Pair<Long, Long>[] component1() {
            return this.buckets;
        }

        public final long component2() {
            return this.p99bound;
        }

        public final long component3() {
            return this.p999bound;
        }

        @NotNull
        public final Snapshot copy(@NotNull Pair<Long, Long>[] buckets, long p99bound, long p999bound) {
            Intrinsics.checkNotNullParameter(buckets, "buckets");
            return new Snapshot(buckets, p99bound, p999bound);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, Pair[] pairArray, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                pairArray = snapshot.buckets;
            }
            if ((n & 2) != 0) {
                l = snapshot.p99bound;
            }
            if ((n & 4) != 0) {
                l2 = snapshot.p999bound;
            }
            return snapshot.copy(pairArray, l, l2);
        }

        @NotNull
        public String toString() {
            return "Snapshot(buckets=" + Arrays.toString(this.buckets) + ", p99bound=" + this.p99bound + ", p999bound=" + this.p999bound + ')';
        }
    }
}

