/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.stats;

import gg.essential.lib.jitsi.utils.AtomicExtensionsKt;
import gg.essential.lib.jitsi.utils.OrderedJsonObject;
import gg.essential.lib.jitsi.utils.stats.Buckets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001+B#\u0012\u0006\u0010(\u001a\u00020'\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0013\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\u00020\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010%\u00a8\u0006,"}, d2={"Lgg/essential/lib/jitsi/utils/stats/BucketStats;", "", "", "value", "", "addValue", "(J)V", "Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "b", "Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "getBucketsJson", "(Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;)Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "toJson", "()Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "", "getAverage", "()D", "average", "", "averageMaxLabel", "Ljava/lang/String;", "getAverageMaxLabel", "()Ljava/lang/String;", "bucketLabel", "getBucketLabel", "Lgg/essential/lib/jitsi/utils/stats/Buckets;", "buckets", "Lgg/essential/lib/jitsi/utils/stats/Buckets;", "Ljava/util/concurrent/atomic/AtomicLong;", "maxValue", "Ljava/util/concurrent/atomic/AtomicLong;", "Lgg/essential/lib/jitsi/utils/stats/BucketStats$Snapshot;", "getSnapshot", "()Lorg/jitsi/utils/stats/BucketStats$Snapshot;", "snapshot", "Ljava/util/concurrent/atomic/LongAdder;", "totalCount", "Ljava/util/concurrent/atomic/LongAdder;", "totalValue", "", "thresholdsNoMax", "<init>", "([JLjava/lang/String;Ljava/lang/String;)V", "Snapshot", "jitsi-utils"})
public class BucketStats {
    @NotNull
    private final String averageMaxLabel;
    @NotNull
    private final String bucketLabel;
    @NotNull
    private final LongAdder totalValue;
    @NotNull
    private final LongAdder totalCount;
    @NotNull
    private final AtomicLong maxValue;
    @NotNull
    private final Buckets buckets;

    public BucketStats(@NotNull long[] thresholdsNoMax, @NotNull String averageMaxLabel, @NotNull String bucketLabel) {
        Intrinsics.checkNotNullParameter(thresholdsNoMax, "thresholdsNoMax");
        Intrinsics.checkNotNullParameter(averageMaxLabel, "averageMaxLabel");
        Intrinsics.checkNotNullParameter(bucketLabel, "bucketLabel");
        this.averageMaxLabel = averageMaxLabel;
        this.bucketLabel = bucketLabel;
        long[] lArray = thresholdsNoMax;
        long[] lArray2 = ArraysKt.sortedArray(thresholdsNoMax);
        boolean bl = false;
        if (!Arrays.equals(lArray, lArray2)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Thresholds must be sorted: ", ArraysKt.joinToString$default(thresholdsNoMax, null, null, null, 0, null, null, 63, null)));
        }
        this.totalValue = new LongAdder();
        this.totalCount = new LongAdder();
        this.maxValue = new AtomicLong(0L);
        this.buckets = new Buckets(thresholdsNoMax);
    }

    public /* synthetic */ BucketStats(long[] lArray, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(lArray, string, string2);
    }

    @NotNull
    public final String getAverageMaxLabel() {
        return this.averageMaxLabel;
    }

    @NotNull
    public final String getBucketLabel() {
        return this.bucketLabel;
    }

    private final double getAverage() {
        return (double)this.totalValue.sum() / (double)this.totalCount.sum();
    }

    public final void addValue(long value2) {
        if (value2 >= 0L) {
            this.totalValue.add(value2);
            AtomicExtensionsKt.maxAssign(this.maxValue, value2);
            this.totalCount.increment();
            this.buckets.addValue(value2);
        }
    }

    @NotNull
    public final OrderedJsonObject toJson() {
        OrderedJsonObject orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        boolean bl2 = false;
        OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject;
        boolean bl3 = false;
        Snapshot snapshot = this.getSnapshot();
        $this$toJson_u24lambda_u2d0.put(Intrinsics.stringPlus("average", this.getAverageMaxLabel()), (Object)snapshot.getAverage());
        $this$toJson_u24lambda_u2d0.put(Intrinsics.stringPlus("max", this.getAverageMaxLabel()), (Object)snapshot.getMaxValue());
        $this$toJson_u24lambda_u2d0.put("total_value", (Object)snapshot.getTotalValue());
        $this$toJson_u24lambda_u2d0.put("total_count", (Object)snapshot.getTotalCount());
        $this$toJson_u24lambda_u2d0.put("buckets", this.getBucketsJson(snapshot.getBuckets()));
        return orderedJsonObject;
    }

    @NotNull
    public final Snapshot getSnapshot() {
        return new Snapshot(this.getAverage(), this.maxValue.get(), this.totalValue.sum(), this.totalCount.sum(), this.buckets.getSnapshot());
    }

    @NotNull
    public final OrderedJsonObject getBucketsJson(@NotNull Buckets.Snapshot b) {
        Intrinsics.checkNotNullParameter(b, "b");
        OrderedJsonObject orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        boolean bl2 = false;
        OrderedJsonObject $this$getBucketsJson_u24lambda_u2d1 = orderedJsonObject;
        boolean bl3 = false;
        int n = 0;
        int n2 = b.getBuckets().length - 2;
        if (n <= n2) {
            int i;
            do {
                i = n++;
                $this$getBucketsJson_u24lambda_u2d1.put("<= " + ((Number)b.getBuckets()[i].getFirst()).longValue() + this.getBucketLabel(), b.getBuckets()[i].getSecond());
            } while (i != n2);
        }
        int indexOfSecondToLast = b.getBuckets().length - 2;
        $this$getBucketsJson_u24lambda_u2d1.put("> " + ((Number)b.getBuckets()[indexOfSecondToLast].getFirst()).longValue() + this.getBucketLabel(), ArraysKt.last(b.getBuckets()).getSecond());
        $this$getBucketsJson_u24lambda_u2d1.put("p99<=", (Object)b.getP99bound());
        $this$getBucketsJson_u24lambda_u2d1.put("p999<=", (Object)b.getP999bound());
        return orderedJsonObject;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\r\u001a\u00020\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\t\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\nH\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJB\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\r\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001e\u001a\u0004\b\u001f\u0010\u0004R\u0017\u0010\u0011\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010#\u001a\u0004\b$\u0010\u0007R\u0017\u0010\u0010\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010#\u001a\u0004\b%\u0010\u0007R\u0017\u0010\u000f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010#\u001a\u0004\b&\u0010\u0007\u00a8\u0006)"}, d2={"Lgg/essential/lib/jitsi/utils/stats/BucketStats$Snapshot;", "", "", "component1", "()D", "", "component2", "()J", "component3", "component4", "Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "component5", "()Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "average", "maxValue", "totalValue", "totalCount", "buckets", "copy", "(DJJJLgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;)Lgg/essential/lib/jitsi/utils/stats/BucketStats$Snapshot;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "D", "getAverage", "Lgg/essential/lib/jitsi/utils/stats/Buckets$Snapshot;", "getBuckets", "()Lorg/jitsi/utils/stats/Buckets$Snapshot;", "J", "getMaxValue", "getTotalCount", "getTotalValue", "<init>", "(DJJJLorg/jitsi/utils/stats/Buckets$Snapshot;)V", "jitsi-utils"})
    public static final class Snapshot {
        private final double average;
        private final long maxValue;
        private final long totalValue;
        private final long totalCount;
        @NotNull
        private final Buckets.Snapshot buckets;

        public Snapshot(double average, long maxValue, long totalValue, long totalCount, @NotNull Buckets.Snapshot buckets) {
            Intrinsics.checkNotNullParameter(buckets, "buckets");
            this.average = average;
            this.maxValue = maxValue;
            this.totalValue = totalValue;
            this.totalCount = totalCount;
            this.buckets = buckets;
        }

        public final double getAverage() {
            return this.average;
        }

        public final long getMaxValue() {
            return this.maxValue;
        }

        public final long getTotalValue() {
            return this.totalValue;
        }

        public final long getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final Buckets.Snapshot getBuckets() {
            return this.buckets;
        }

        public final double component1() {
            return this.average;
        }

        public final long component2() {
            return this.maxValue;
        }

        public final long component3() {
            return this.totalValue;
        }

        public final long component4() {
            return this.totalCount;
        }

        @NotNull
        public final Buckets.Snapshot component5() {
            return this.buckets;
        }

        @NotNull
        public final Snapshot copy(double average, long maxValue, long totalValue, long totalCount, @NotNull Buckets.Snapshot buckets) {
            Intrinsics.checkNotNullParameter(buckets, "buckets");
            return new Snapshot(average, maxValue, totalValue, totalCount, buckets);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, double d, long l, long l2, long l3, Buckets.Snapshot snapshot2, int n, Object object) {
            if ((n & 1) != 0) {
                d = snapshot.average;
            }
            if ((n & 2) != 0) {
                l = snapshot.maxValue;
            }
            if ((n & 4) != 0) {
                l2 = snapshot.totalValue;
            }
            if ((n & 8) != 0) {
                l3 = snapshot.totalCount;
            }
            if ((n & 0x10) != 0) {
                snapshot2 = snapshot.buckets;
            }
            return snapshot.copy(d, l, l2, l3, snapshot2);
        }

        @NotNull
        public String toString() {
            return "Snapshot(average=" + this.average + ", maxValue=" + this.maxValue + ", totalValue=" + this.totalValue + ", totalCount=" + this.totalCount + ", buckets=" + this.buckets + ')';
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.average);
            result2 = result2 * 31 + Long.hashCode(this.maxValue);
            result2 = result2 * 31 + Long.hashCode(this.totalValue);
            result2 = result2 * 31 + Long.hashCode(this.totalCount);
            result2 = result2 * 31 + this.buckets.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)other;
            if (!Intrinsics.areEqual((Object)this.average, (Object)snapshot.average)) {
                return false;
            }
            if (this.maxValue != snapshot.maxValue) {
                return false;
            }
            if (this.totalValue != snapshot.totalValue) {
                return false;
            }
            if (this.totalCount != snapshot.totalCount) {
                return false;
            }
            return Intrinsics.areEqual(this.buckets, snapshot.buckets);
        }
    }
}

