/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.queue;

import gg.essential.lib.jitsi.utils.OrderedJsonObject;
import gg.essential.lib.jitsi.utils.queue.PacketQueue;
import gg.essential.lib.jitsi.utils.queue.QueueStatistics;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u001d\u0012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0011\u0010\t\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0006R\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013RV\u0010\u0019\u001aD\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00170\u0017\u0018\u0001 \u0016* \u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00170\u0017\u0018\u00010\u00180\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0013R\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lgg/essential/lib/jitsi/utils/queue/QueueStatisticsObserver;", "T", "Lgg/essential/lib/jitsi/utils/queue/PacketQueue$Observer;", "pkt", "", "added", "(Ljava/lang/Object;)V", "dropped", "Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "getStats", "()Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "removed", "Ljava/time/Clock;", "clock", "Ljava/time/Clock;", "getClock", "()Ljava/time/Clock;", "Lgg/essential/lib/jitsi/utils/queue/QueueStatistics;", "globalStats", "Lgg/essential/lib/jitsi/utils/queue/QueueStatistics;", "", "", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "", "insertionTime", "Ljava/util/Map;", "localStats", "Lgg/essential/lib/jitsi/utils/queue/PacketQueue;", "queue", "Lgg/essential/lib/jitsi/utils/queue/PacketQueue;", "getQueue", "()Lorg/jitsi/utils/queue/PacketQueue;", "Ljava/util/concurrent/atomic/AtomicInteger;", "queueSize", "Ljava/util/concurrent/atomic/AtomicInteger;", "<init>", "(Lorg/jitsi/utils/queue/PacketQueue;Ljava/time/Clock;)V", "jitsi-utils"})
public final class QueueStatisticsObserver<T>
implements PacketQueue.Observer<T> {
    @NotNull
    private final PacketQueue<T> queue;
    @NotNull
    private final Clock clock;
    @Nullable
    private final Map<Object, Instant> insertionTime;
    @Nullable
    private final QueueStatistics localStats;
    @NotNull
    private final QueueStatistics globalStats;
    @NotNull
    private final AtomicInteger queueSize;

    public QueueStatisticsObserver(@NotNull PacketQueue<T> queue, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(queue, "queue");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.queue = queue;
        this.clock = clock;
        this.insertionTime = QueueStatistics.TRACK_TIMES ? Collections.synchronizedMap(new IdentityHashMap()) : null;
        this.localStats = QueueStatistics.DEBUG ? new QueueStatistics(this.queue.capacity(), this.clock) : null;
        this.globalStats = QueueStatistics.Companion.globalStatsFor$jitsi_utils(this.queue, this.clock);
        this.queueSize = new AtomicInteger(0);
    }

    @NotNull
    public final PacketQueue<T> getQueue() {
        return this.queue;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @Override
    public void added(T pkt) {
        this.queueSize.incrementAndGet();
        Object object = this.insertionTime;
        if (object != null) {
            object.put(pkt, (Instant)this.clock.instant());
        }
        object = this.localStats;
        if (object != null) {
            ((QueueStatistics)object).added();
        }
        this.globalStats.added();
    }

    @Override
    public void removed(T pkt) {
        Duration duration;
        int queueLength = this.queueSize.decrementAndGet();
        Map<Object, Instant> map2 = this.insertionTime;
        if (map2 == null) {
            duration = null;
        } else {
            Instant instant = map2.get(pkt);
            if (instant == null) {
                duration = null;
            } else {
                Instant instant2 = instant;
                boolean bl = false;
                boolean bl2 = false;
                Instant $this$removed_u24lambda_u2d0 = instant2;
                boolean bl3 = false;
                Instant now = this.getClock().instant();
                duration = Duration.between($this$removed_u24lambda_u2d0, now);
            }
        }
        Duration wait = duration;
        map2 = this.localStats;
        if (map2 != null) {
            ((QueueStatistics)((Object)map2)).removed(queueLength, wait);
        }
        this.globalStats.removed(queueLength, wait);
    }

    @Override
    public void dropped(T pkt) {
        this.queueSize.decrementAndGet();
        Object object = this.insertionTime;
        if (object != null) {
            object.remove(pkt);
        }
        object = this.localStats;
        if (object != null) {
            ((QueueStatistics)object).dropped();
        }
        this.globalStats.dropped();
    }

    @Nullable
    public OrderedJsonObject getStats() {
        QueueStatistics queueStatistics = this.localStats;
        return queueStatistics == null ? null : queueStatistics.getStats();
    }
}

