/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.queue;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gg.essential.lib.jitsi.utils.OrderedJsonObject;
import gg.essential.lib.jitsi.utils.queue.PacketQueue;
import gg.essential.lib.jitsi.utils.stats.BucketStats;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b!\u0010\"J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u001f\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001e\u00a8\u0006$"}, d2={"Lgg/essential/lib/jitsi/utils/queue/QueueStatistics;", "", "", "added", "()V", "dropped", "", "queueSize", "Ljava/time/Duration;", "waitTime", "removed", "(ILjava/time/Duration;)V", "Ljava/time/Clock;", "clock", "Ljava/time/Clock;", "getClock", "()Ljava/time/Clock;", "Ljava/time/Instant;", "firstPacketAdded", "Ljava/time/Instant;", "Lgg/essential/lib/jitsi/utils/stats/BucketStats;", "queueLengthStats", "Lgg/essential/lib/jitsi/utils/stats/BucketStats;", "queueWaitStats", "Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "getStats", "()Lorg/jitsi/utils/OrderedJsonObject;", "stats", "Ljava/util/concurrent/atomic/LongAdder;", "totalPacketsAdded", "Ljava/util/concurrent/atomic/LongAdder;", "totalPacketsDropped", "totalPacketsRemoved", "<init>", "(ILjava/time/Clock;)V", "Companion", "jitsi-utils"})
public final class QueueStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final LongAdder totalPacketsAdded;
    @NotNull
    private final LongAdder totalPacketsRemoved;
    @NotNull
    private final LongAdder totalPacketsDropped;
    @Nullable
    private Instant firstPacketAdded;
    @NotNull
    private final BucketStats queueLengthStats;
    @Nullable
    private final BucketStats queueWaitStats;
    @JvmField
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DEBUG;
    @JvmField
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TRACK_TIMES;
    @NotNull
    private static final ConcurrentHashMap<String, QueueStatistics> queueStatsById;
    @NotNull
    private static final long[] waitBucketSizes;

    public QueueStatistics(int queueSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        this.totalPacketsAdded = new LongAdder();
        this.totalPacketsRemoved = new LongAdder();
        this.totalPacketsDropped = new LongAdder();
        this.queueLengthStats = new BucketStats(QueueStatistics.Companion.getQueueLengthBucketSizes(queueSize), "_queue_size_at_remove", "");
        this.queueWaitStats = TRACK_TIMES ? new BucketStats(waitBucketSizes, "_queue_wait_time_ms", " ms") : null;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final OrderedJsonObject getStats() {
        Object object;
        Object object2;
        OrderedJsonObject stats = new OrderedJsonObject();
        Instant now = this.clock.instant();
        Object object3 = stats;
        String string = "added_packets";
        Object object4 = this.totalPacketsAdded.sum();
        boolean bl = false;
        object3.put(string, object4);
        object3 = stats;
        string = "removed_packets";
        object4 = this.totalPacketsRemoved.sum();
        bl = false;
        object3.put(string, object4);
        object3 = stats;
        string = "dropped_packets";
        object4 = this.totalPacketsDropped.sum();
        bl = false;
        object3.put(string, object4);
        if (this.firstPacketAdded != null) {
            Duration duration = Duration.between(this.firstPacketAdded, now);
            double duration_s = (double)duration.toNanos() / 1.0E9;
            Map map2 = stats;
            String string2 = "duration_s";
            Object object5 = duration_s;
            boolean bl2 = false;
            map2.put(string2, object5);
            double packetsRemoved = this.totalPacketsRemoved.sum();
            object5 = stats;
            object2 = "average_remove_rate_pps";
            object = packetsRemoved / duration_s;
            boolean bl3 = false;
            object5.put(object2, object);
        }
        object3 = stats;
        Object object6 = "queue_size_at_remove";
        object4 = this.queueLengthStats.toJson();
        boolean bl4 = false;
        object3.put(object6, object4);
        object3 = this.queueWaitStats;
        if (object3 != null) {
            object6 = object3;
            boolean bl5 = false;
            bl4 = false;
            Object it = object6;
            boolean bl6 = false;
            object2 = stats;
            object = "queue_wait_time";
            OrderedJsonObject orderedJsonObject = ((BucketStats)it).toJson();
            boolean bl7 = false;
            object2.put(object, orderedJsonObject);
        }
        return stats;
    }

    public final void added() {
        if (this.firstPacketAdded == null) {
            this.firstPacketAdded = this.clock.instant();
        }
        this.totalPacketsAdded.increment();
    }

    public final void removed(int queueSize, @Nullable Duration waitTime) {
        BucketStats bucketStats;
        this.totalPacketsRemoved.increment();
        this.queueLengthStats.addValue(queueSize);
        if (waitTime != null && (bucketStats = this.queueWaitStats) != null) {
            bucketStats.addValue(waitTime.toMillis());
        }
    }

    public final void dropped() {
        this.totalPacketsDropped.increment();
    }

    static {
        queueStatsById = new ConcurrentHashMap();
        long[] lArray = new long[]{2L, 5L, 20L, 50L, 200L, 500L, 1000L};
        waitBucketSizes = lArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u0011\u001a\u00020\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lgg/essential/lib/jitsi/utils/queue/QueueStatistics$Companion;", "", "", "capacity", "", "getQueueLengthBucketSizes", "(I)[J", "Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "getStatistics", "()Lgg/essential/lib/jitsi/utils/OrderedJsonObject;", "Lgg/essential/lib/jitsi/utils/queue/PacketQueue;", "queue", "Ljava/time/Clock;", "clock", "Lgg/essential/lib/jitsi/utils/queue/QueueStatistics;", "globalStatsFor$jitsi_utils", "(Lgg/essential/lib/jitsi/utils/queue/PacketQueue;Ljava/time/Clock;)Lgg/essential/lib/jitsi/utils/queue/QueueStatistics;", "globalStatsFor", "", "DEBUG", "Z", "TRACK_TIMES", "Ljava/util/concurrent/ConcurrentHashMap;", "", "queueStatsById", "Ljava/util/concurrent/ConcurrentHashMap;", "waitBucketSizes", "[J", "<init>", "()V", "jitsi-utils"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QueueStatistics globalStatsFor$jitsi_utils(@NotNull PacketQueue<?> queue, @NotNull Clock clock) {
            Intrinsics.checkNotNullParameter(queue, "queue");
            Intrinsics.checkNotNullParameter(clock, "clock");
            QueueStatistics queueStatistics = queueStatsById.computeIfAbsent(queue.id(), arg_0 -> Companion.globalStatsFor$lambda-0(queue, clock, arg_0));
            Intrinsics.checkNotNullExpressionValue(queueStatistics, "queueStatsById.computeIf\u2026acity(), clock)\n        }");
            return queueStatistics;
        }

        @NotNull
        public final OrderedJsonObject getStatistics() {
            OrderedJsonObject orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            boolean bl2 = false;
            OrderedJsonObject $this$getStatistics_u24lambda_u2d2 = orderedJsonObject;
            boolean bl3 = false;
            Set set = queueStatsById.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "queueStatsById.entries");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl4 = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, "it.key");
                $this$getStatistics_u24lambda_u2d2.put(k, ((QueueStatistics)it.getValue()).getStats());
            }
            return orderedJsonObject;
        }

        private final long[] getQueueLengthBucketSizes(int capacity) {
            int boundedCapacity = RangesKt.coerceAtMost(capacity, 16384);
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(0L);
            for (long i = 1L; i < (long)boundedCapacity; i *= (long)4) {
                list.add(i);
            }
            if (capacity == boundedCapacity) {
                long threeQuarters;
                long half = capacity / 2;
                if (half > ((Number)CollectionsKt.last((List)list)).longValue()) {
                    list.add(half);
                }
                if ((threeQuarters = (long)(capacity * 3 / 4)) > ((Number)CollectionsKt.last((List)list)).longValue()) {
                    list.add(threeQuarters);
                }
            } else {
                list.add(Long.valueOf(boundedCapacity));
            }
            return CollectionsKt.toLongArray((Collection<Long>)list);
        }

        private static final QueueStatistics globalStatsFor$lambda-0(PacketQueue $queue, Clock $clock, String it) {
            Intrinsics.checkNotNullParameter($queue, "$queue");
            Intrinsics.checkNotNullParameter($clock, "$clock");
            Intrinsics.checkNotNullParameter(it, "it");
            return new QueueStatistics($queue.capacity(), $clock);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

