/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.logging2;

import gg.essential.lib.jitsi.utils.logging2.LogContext;
import gg.essential.lib.jitsi.utils.logging2.Logger;
import gg.essential.lib.jitsi.utils.logging2.LoggerImpl;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a)\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002\"\b\b\u0000\u0010\u0001*\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a%\u0010\u000b\u001a\u00020\n*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a%\u0010\r\u001a\u00020\n*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\f\u001a%\u0010\u000e\u001a\u00020\n*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\f\u001a9\u0010\u0012\u001a\u00020\u0006\"\b\b\u0000\u0010\u0001*\u00020\u0000*\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00062\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a/\u0010\u0018\u001a\u00020\u0006\"\b\b\u0000\u0010\u0001*\u00020\u0000*\u00028\u00002\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a%\u0010\u001a\u001a\u00020\n*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"", "T", "Ljava/lang/Class;", "javaClass", "getClassForLogging", "(Ljava/lang/Class;)Ljava/lang/Class;", "Lgg/essential/lib/jitsi/utils/logging2/Logger;", "Lkotlin/Function0;", "", "msg", "", "cdebug", "(Lgg/essential/lib/jitsi/utils/logging2/Logger;Lkotlin/jvm/functions/Function0;)V", "cerror", "cinfo", "parentLogger", "", "childContext", "createChildLogger", "(Ljava/lang/Object;Lorg/jitsi/utils/logging2/Logger;Ljava/util/Map;)Lorg/jitsi/utils/logging2/Logger;", "Ljava/util/logging/Level;", "minLogLevel", "Lgg/essential/lib/jitsi/utils/logging2/LogContext;", "logContext", "createLogger", "(Ljava/lang/Object;Ljava/util/logging/Level;Lorg/jitsi/utils/logging2/LogContext;)Lorg/jitsi/utils/logging2/Logger;", "cwarn", "jitsi-utils"})
public final class LoggerExtensionsKt {
    @NotNull
    public static final <T> Logger createLogger(@NotNull T $this$createLogger, @NotNull Level minLogLevel, @NotNull LogContext logContext) {
        Intrinsics.checkNotNullParameter($this$createLogger, "<this>");
        Intrinsics.checkNotNullParameter(minLogLevel, "minLogLevel");
        Intrinsics.checkNotNullParameter(logContext, "logContext");
        return new LoggerImpl(LoggerExtensionsKt.getClassForLogging($this$createLogger.getClass()).getName(), minLogLevel, logContext);
    }

    public static /* synthetic */ Logger createLogger$default(Object object, Level level, LogContext logContext, int n, Object object2) {
        if ((n & 1) != 0) {
            Level level2 = Level.ALL;
            Intrinsics.checkNotNullExpressionValue(level2, "ALL");
            level = level2;
        }
        if ((n & 2) != 0) {
            logContext = new LogContext();
        }
        return LoggerExtensionsKt.createLogger(object, level, logContext);
    }

    @NotNull
    public static final <T> Logger createChildLogger(@NotNull T $this$createChildLogger, @NotNull Logger parentLogger, @NotNull Map<String, String> childContext) {
        Intrinsics.checkNotNullParameter($this$createChildLogger, "<this>");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(childContext, "childContext");
        Logger logger = parentLogger.createChildLogger(LoggerExtensionsKt.getClassForLogging($this$createChildLogger.getClass()).getName(), childContext);
        Intrinsics.checkNotNullExpressionValue(logger, "parentLogger.createChild\u2026lass).name, childContext)");
        return logger;
    }

    public static /* synthetic */ Logger createChildLogger$default(Object object, Logger logger, Map map2, int n, Object object2) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return LoggerExtensionsKt.createChildLogger(object, logger, map2);
    }

    @NotNull
    public static final <T> Class<?> getClassForLogging(@NotNull Class<T> javaClass) {
        Class<Object> clazz;
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        Class<?> clazz2 = javaClass.getEnclosingClass();
        if (clazz2 == null) {
            clazz = javaClass;
        } else {
            Class<?> clazz3 = clazz2;
            boolean bl = false;
            boolean bl2 = false;
            Class<?> it = clazz3;
            boolean bl3 = false;
            KClass<?> kClass = KClasses.getCompanionObject(JvmClassMappingKt.getKotlinClass(it));
            Class<?> clazz4 = Intrinsics.areEqual(kClass == null ? null : JvmClassMappingKt.getJavaClass(kClass), javaClass) ? clazz3 : null;
            clazz = clazz4 == null ? javaClass : clazz4;
        }
        return clazz;
    }

    public static final void cinfo(@NotNull Logger $this$cinfo, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter($this$cinfo, "<this>");
        Intrinsics.checkNotNullParameter(msg, "msg");
        boolean $i$f$cinfo = false;
        if ($this$cinfo.isInfoEnabled()) {
            $this$cinfo.info(msg.invoke());
        }
    }

    public static final void cdebug(@NotNull Logger $this$cdebug, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter($this$cdebug, "<this>");
        Intrinsics.checkNotNullParameter(msg, "msg");
        boolean $i$f$cdebug = false;
        if ($this$cdebug.isDebugEnabled()) {
            $this$cdebug.debug(msg.invoke());
        }
    }

    public static final void cwarn(@NotNull Logger $this$cwarn, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter($this$cwarn, "<this>");
        Intrinsics.checkNotNullParameter(msg, "msg");
        boolean $i$f$cwarn = false;
        if ($this$cwarn.isWarnEnabled()) {
            $this$cwarn.warn(msg.invoke());
        }
    }

    public static final void cerror(@NotNull Logger $this$cerror, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter($this$cerror, "<this>");
        Intrinsics.checkNotNullParameter(msg, "msg");
        boolean $i$f$cerror = false;
        $this$cerror.error(msg.invoke());
    }
}

