/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.logging;

import gg.essential.lib.jitsi.utils.logging.InstanceLogger;
import gg.essential.lib.jitsi.utils.logging.LoggerImpl;
import java.util.Objects;
import java.util.logging.Level;

public abstract class Logger {
    public static Logger getLogger(Class<?> clazz) throws NullPointerException {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) throws NullPointerException {
        return new LoggerImpl(java.util.logging.Logger.getLogger(name));
    }

    public static Logger getLogger(Logger loggingDelegate, Logger levelDelegate) {
        return new InstanceLogger(loggingDelegate, levelDelegate);
    }

    @Deprecated
    public void logEntry() {
        if (this.isLoggable(Level.FINEST)) {
            StackTraceElement caller2 = new Throwable().getStackTrace()[1];
            this.log(Level.FINEST, "[entry] " + caller2.getMethodName());
        }
    }

    @Deprecated
    public void logExit() {
        if (this.isLoggable(Level.FINEST)) {
            StackTraceElement caller2 = new Throwable().getStackTrace()[1];
            this.log(Level.FINEST, "[exit] " + caller2.getMethodName());
        }
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(Level.FINER);
    }

    public void trace(Object msg) {
        this.log(Level.FINER, msg);
    }

    public void trace(Object msg, Throwable t) {
        this.log(Level.FINER, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(Level.FINE);
    }

    public void debug(Object msg) {
        this.log(Level.FINE, msg);
    }

    public void debug(Object msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(Level.INFO);
    }

    public void info(Object msg) {
        this.log(Level.INFO, msg);
    }

    public void info(Object msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(Level.WARNING);
    }

    public void warn(Object msg) {
        this.log(Level.WARNING, msg);
    }

    public void warn(Object msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }

    public void error(Object msg) {
        this.log(Level.SEVERE, msg);
    }

    public void error(Object msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    public void fatal(Object msg) {
        this.error(msg);
    }

    public void fatal(Object msg, Throwable t) {
        this.error(msg, t);
    }

    public void setLevelFatal() {
        this.setLevel(Level.SEVERE);
    }

    public void setLevelError() {
        this.setLevel(Level.SEVERE);
    }

    public void setLevelWarn() {
        this.setLevel(Level.WARNING);
    }

    public void setLevelInfo() {
        this.setLevel(Level.INFO);
    }

    public void setLevelDebug() {
        this.setLevel(Level.FINE);
    }

    public void setLevelTrace() {
        this.setLevel(Level.FINER);
    }

    public void setLevelAll() {
        this.setLevel(Level.ALL);
    }

    public void setLevelOff() {
        this.setLevel(Level.OFF);
    }

    public void reset() {
    }

    public abstract void setLevel(Level var1);

    public abstract Level getLevel();

    abstract boolean isLoggable(Level var1);

    public abstract void log(Level var1, Object var2);

    public abstract void log(Level var1, Object var2, Throwable var3);

    public void log(Level level, Category category, String msg) {
        Objects.requireNonNull(category, "category");
        this.log(level, category.prepend + msg);
    }

    public void log(Level level, Category category, String msg, Throwable thrown) {
        Objects.requireNonNull(category, "category");
        this.log(level, category.prepend + msg, thrown);
    }

    public void debug(Category category, String msg) {
        this.log(Level.FINE, category, msg);
    }

    public void debug(Category category, String msg, Throwable t) {
        this.log(Level.FINE, category, msg, t);
    }

    public void error(Category category, String msg) {
        this.log(Level.SEVERE, category, msg);
    }

    public void error(Category category, String msg, Throwable t) {
        this.log(Level.SEVERE, category, msg, t);
    }

    public void info(Category category, String msg, Throwable t) {
        this.log(Level.INFO, category, msg, t);
    }

    public void info(Category category, String msg) {
        this.log(Level.INFO, category, msg);
    }

    public static enum Category {
        STATISTICS("stat"),
        VOLATILE("vol");

        private String name;
        private String prepend;

        private Category(String name) {
            this.name = name;
            this.prepend = "CAT=" + name + " ";
        }

        public String toString() {
            return this.name;
        }
    }
}

