/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class CustomizableThreadFactory
implements ThreadFactory {
    private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private final String threadNamePrefix;
    private final boolean isDaemon;

    public CustomizableThreadFactory(String threadNamePrefix, boolean isDaemon) {
        this.threadNamePrefix = threadNamePrefix;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread2 = this.defaultThreadFactory.newThread(r);
        if (this.threadNamePrefix != null && !this.threadNamePrefix.isEmpty()) {
            thread2.setName(this.threadNamePrefix + thread2.getName());
        }
        if (thread2.isDaemon() != this.isDaemon) {
            thread2.setDaemon(this.isDaemon);
        }
        return thread2;
    }
}

