/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils;

public class TimestampUtils {
    public static final long MAX_TIMESTAMP_VALUE = 0xFFFFFFFFL;
    public static final long ROLLOVER_DELTA_VALUE = 0x80000000L;

    public static long subtractAsUnsignedInt32(long t12, long t22) {
        return t12 - t22 & 0xFFFFFFFFL;
    }

    public static boolean isNewerTimestamp(long t12, long t22) {
        if (t12 == t22) {
            return false;
        }
        if (TimestampUtils.subtractAsUnsignedInt32(t12, t22) == 0x80000000L) {
            return t12 > t22;
        }
        return TimestampUtils.subtractAsUnsignedInt32(t12, t22) < 0x80000000L;
    }

    public static long latestTimestamp(long timestamp1, long timestamp2) {
        return TimestampUtils.isNewerTimestamp(timestamp1, timestamp2) ? timestamp1 : timestamp2;
    }
}

