/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils;

public enum MediaType {
    AUDIO("audio"),
    VIDEO("video"),
    TEXT("text"),
    APPLICATION("application"),
    MESSAGE("message"),
    IMAGE("image"),
    CONTROL("control"),
    DATA("data");

    private final String mediaTypeName;

    private MediaType(String mediaTypeName) {
        this.mediaTypeName = mediaTypeName;
    }

    public String toString() {
        return this.mediaTypeName;
    }

    public static MediaType parseString(String mediaTypeName) throws IllegalArgumentException {
        if (AUDIO.toString().equalsIgnoreCase(mediaTypeName)) {
            return AUDIO;
        }
        if (VIDEO.toString().equalsIgnoreCase(mediaTypeName)) {
            return VIDEO;
        }
        if (TEXT.toString().equalsIgnoreCase(mediaTypeName)) {
            return TEXT;
        }
        if (APPLICATION.toString().equalsIgnoreCase(mediaTypeName)) {
            return APPLICATION;
        }
        if (MESSAGE.toString().equalsIgnoreCase(mediaTypeName)) {
            return MESSAGE;
        }
        if (IMAGE.toString().equalsIgnoreCase(mediaTypeName)) {
            return IMAGE;
        }
        if (CONTROL.toString().equalsIgnoreCase(mediaTypeName)) {
            return CONTROL;
        }
        if (DATA.toString().equalsIgnoreCase(mediaTypeName)) {
            return DATA;
        }
        throw new IllegalArgumentException(mediaTypeName + " is not a currently supported MediaType");
    }
}

