/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private int cacheSize;

    public static <T> Set<T> lruSet(int cacheSize, boolean accessOrder) {
        return Collections.newSetFromMap(new LRUCache(cacheSize, accessOrder));
    }

    public LRUCache(int cacheSize) {
        this(cacheSize, false);
    }

    public LRUCache(int cacheSize, boolean accessOrder) {
        super(16, 0.75f, accessOrder);
        this.cacheSize = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }
}

