/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.jitsi.utils;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayUtils {
    public static <T> T[] add(T[] array, Class<T> componentType, T element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (array == null) {
            array = (Object[])Array.newInstance(componentType, 1);
        } else {
            for (T a : array) {
                if (!element.equals(a)) continue;
                return array;
            }
            Object[] newArray = (Object[])Array.newInstance(componentType, array.length + 1);
            System.arraycopy(array, 0, newArray, 0, array.length);
            array = newArray;
        }
        array[array.length - 1] = element;
        return array;
    }

    public static <T> T[] insert(T element, T[] array, Class<T> componentType) {
        T[] arrayToReturn = array;
        boolean inserted = false;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            array[i] = element;
            inserted = true;
            break;
        }
        if (!inserted) {
            arrayToReturn = ArrayUtils.add(array, componentType, element);
        }
        return arrayToReturn;
    }

    private ArrayUtils() {
    }

    public static <T> T[] concat(T[] first2, T[] second2) {
        if (ArrayUtils.isNullOrEmpty(first2)) {
            return second2;
        }
        if (ArrayUtils.isNullOrEmpty(second2)) {
            return first2;
        }
        T[] result2 = Arrays.copyOf(first2, first2.length + second2.length);
        System.arraycopy(second2, 0, result2, first2.length, second2.length);
        return result2;
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || array.length == 0;
    }
}

