/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.util;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class PeriodicRunnable {
    private final ScheduledExecutorService timer;
    private final ExecutorService executor;
    private final Object syncRoot = new Object();
    private volatile boolean running = false;
    private ScheduledFuture<?> scheduledSubmit;
    private Future<?> submittedExecute;

    protected PeriodicRunnable(ScheduledExecutorService timer2, ExecutorService executor) {
        if (timer2 == null) {
            throw new IllegalArgumentException("timer is null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor is null");
        }
        this.timer = timer2;
        this.executor = executor;
    }

    protected abstract Duration getDelayUntilNextRun();

    protected abstract void run();

    public void schedule() {
        if (this.running) {
            return;
        }
        Duration delay2 = this.getDelayUntilNextRun();
        this.scheduleNextRun(delay2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.running) {
            return;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                if (this.scheduledSubmit != null) {
                    this.scheduledSubmit.cancel(true);
                    this.scheduledSubmit = null;
                }
                if (this.submittedExecute != null) {
                    this.submittedExecute.cancel(true);
                    this.submittedExecute = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextRun(Duration delay2) {
        Object object = this.syncRoot;
        synchronized (object) {
            boolean isRecurrentRun;
            boolean bl = isRecurrentRun = this.submittedExecute != null;
            if (isRecurrentRun && !this.running) {
                return;
            }
            if (delay2.isNegative()) {
                this.running = false;
                this.scheduledSubmit = null;
                this.submittedExecute = null;
                return;
            }
            this.running = true;
            if (delay2.isZero()) {
                this.submitExecuteRun();
            } else {
                this.scheduledSubmit = this.timer.schedule(this::submitExecuteRun, delay2.toNanos(), TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitExecuteRun() {
        if (!this.running) {
            return;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.submittedExecute = this.executor.submit(this::executeRun);
        }
    }

    private void executeRun() {
        if (!this.running) {
            return;
        }
        try {
            this.run();
        }
        finally {
            if (this.running) {
                Duration delayMillis = this.getDelayUntilNextRun();
                this.scheduleNextRun(delayMillis);
            }
        }
    }

    static PeriodicRunnable create(ScheduledExecutorService timer2, ExecutorService executor, final Duration period, final Runnable r) {
        return new PeriodicRunnable(timer2, executor){

            @Override
            protected Duration getDelayUntilNextRun() {
                return period;
            }

            @Override
            protected void run() {
                r.run();
            }
        };
    }
}

