/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.ice4j.stunclient;

import gg.essential.lib.ice4j.StunException;
import gg.essential.lib.ice4j.StunMessageEvent;
import gg.essential.lib.ice4j.Transport;
import gg.essential.lib.ice4j.TransportAddress;
import gg.essential.lib.ice4j.attribute.MappedAddressAttribute;
import gg.essential.lib.ice4j.attribute.XorMappedAddressAttribute;
import gg.essential.lib.ice4j.message.Message;
import gg.essential.lib.ice4j.message.MessageFactory;
import gg.essential.lib.ice4j.message.Response;
import gg.essential.lib.ice4j.socket.IceSocketWrapper;
import gg.essential.lib.ice4j.stack.StunStack;
import gg.essential.lib.ice4j.stunclient.BlockingRequestSender;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleAddressDetector {
    private static final Logger logger = Logger.getLogger(SimpleAddressDetector.class.getName());
    private StunStack stunStack = null;
    private TransportAddress serverAddress = null;
    private BlockingRequestSender requestSender = null;

    public SimpleAddressDetector(TransportAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public TransportAddress getServerAddress() {
        return this.serverAddress;
    }

    public void shutDown() {
        this.stunStack = null;
        this.requestSender = null;
    }

    public void start() {
        this.stunStack = new StunStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportAddress getMappingFor(IceSocketWrapper socket) throws IOException, BindException {
        TransportAddress localAddress = new TransportAddress((InetSocketAddress)socket.getLocalSocketAddress(), Transport.UDP);
        this.stunStack.addSocket(socket);
        this.requestSender = new BlockingRequestSender(this.stunStack, localAddress);
        StunMessageEvent evt = null;
        try {
            evt = this.requestSender.sendRequestAndWaitForResponse(MessageFactory.createBindingRequest(), this.serverAddress);
        }
        catch (StunException exc) {
            logger.log(Level.SEVERE, "Internal Error. We apparently constructed a faulty request.", exc);
            TransportAddress transportAddress = null;
            return transportAddress;
        }
        finally {
            this.stunStack.removeSocket(localAddress);
        }
        if (evt != null) {
            Response res = (Response)evt.getMessage();
            MappedAddressAttribute maAtt = (MappedAddressAttribute)res.getAttribute('\u0001');
            if (maAtt != null) {
                return maAtt.getAddress();
            }
            XorMappedAddressAttribute xorAtt = (XorMappedAddressAttribute)res.getAttribute(' ');
            if (xorAtt != null) {
                byte[] xoring = new byte[16];
                System.arraycopy(Message.MAGIC_COOKIE, 0, xoring, 0, 4);
                System.arraycopy(res.getTransactionID(), 0, xoring, 4, 12);
                return xorAtt.applyXor(xoring);
            }
        }
        return null;
    }
}

